/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.hover;

import java.util.ArrayList;
import java.util.List;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.text.JavaWordFinder;
import melnorme.lang.ide.ui.LangEditorTextHoversRegistry;
import melnorme.lang.ide.ui.editor.hover.AbstractEditorTextHover;
import melnorme.lang.ide.ui.editor.hover.ILangEditorTextHover;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.texteditor.ITextEditor;

public class BestMatchHover
extends AbstractEditorTextHover
implements IInformationProviderExtension2 {
    protected final ISourceBuffer sourceBuffer;
    protected final ITextEditor editor;
    protected List<ILangEditorTextHover<?>> fInstantiatedTextHovers;
    protected ILangEditorTextHover<?> matchedHover;

    public BestMatchHover(ISourceBuffer sourceBuffer, ITextEditor editor) {
        this.sourceBuffer = (ISourceBuffer)Assert.AssertNamespace.assertNotNull((Object)sourceBuffer);
        this.editor = editor;
        this.prepareTextHovers();
    }

    protected void installTextHovers() {
        List<Class<ILangEditorTextHover<?>>> textHoverSpecs = LangEditorTextHoversRegistry.getTextHoversSpecifications();
        this.fInstantiatedTextHovers = new ArrayList(textHoverSpecs.size());
        int i = 0;
        while (i < textHoverSpecs.size()) {
            Class<ILangEditorTextHover<?>> klass = textHoverSpecs.get(i);
            try {
                this.fInstantiatedTextHovers.add(klass.newInstance());
            }
            catch (InstantiationException e) {
                LangCore.logInternalError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LangCore.logInternalError((Throwable)e);
            }
            ++i;
        }
    }

    protected void prepareTextHovers() {
        this.installTextHovers();
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return BestMatchHover.doGetHoverRegion(textViewer, offset);
    }

    public static IRegion doGetHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        ISourceBuffer hoverSourceBuffer = this.sourceBuffer.getReadOnlyView();
        return this.getInformation(textViewer, hoverRegion, hoverSourceBuffer);
    }

    public Object getInformation(ITextViewer textViewer, IRegion hoverRegion, ISourceBuffer hoverSourceBuffer) {
        this.matchedHover = null;
        for (ILangEditorTextHover<?> hover : this.fInstantiatedTextHovers) {
            Object info;
            if (hover == null || (info = hover.getHoverInfo(hoverSourceBuffer, hoverRegion, CoreUtil.option((Object)this.editor), textViewer)) == null) continue;
            this.matchedHover = hover;
            return info;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.matchedHover == null) {
            return null;
        }
        return this.matchedHover.getHoverControlCreator();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.matchedHover == null) {
            return null;
        }
        return this.matchedHover.getInformationPresenterControlCreator();
    }
}

