/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.hover;

import melnorme.lang.tooling.utils.HTMLHelper;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.MiscUtil;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BrowserControlCreator
extends AbstractReusableInformationControlCreator {
    protected final String statusFieldText;
    public static String DEFAULT_CSS = MiscUtil.getClassResource(BrowserControlCreator.class, (String)"defaultHoverStyle.css");

    public BrowserControlCreator() {
        this(null);
    }

    public BrowserControlCreator(String statusFieldText) {
        this.statusFieldText = statusFieldText;
    }

    public IInformationControl doCreateInformationControl(Shell parent) {
        if (!BrowserInformationControl.isAvailable((Composite)parent)) {
            return new DefaultInformationControl(parent, true);
        }
        return this.doCreateBrowserInformationControl(parent, "org.eclipse.jface.dialogfont");
    }

    protected IInformationControl doCreateBrowserInformationControl(Shell parent, String font) {
        if (this.statusFieldText == null) {
            return new BrowserInformationControl(parent, font, true);
        }
        return new BrowserInformationControl(parent, font, this.statusFieldText){

            public IInformationControlCreator getInformationPresenterControlCreator() {
                return BrowserControlCreator.this.getEnrichedInformationPresenterControlCreator();
            }
        };
    }

    public IInformationControlCreator getEnrichedInformationPresenterControlCreator() {
        return null;
    }

    public static String wrapHTMLBody(String content) {
        return new HTMLHelper().wrapHTMLBody(content, DEFAULT_CSS);
    }

    public static class EnrichableBrowserControlCreator
    extends BrowserControlCreator {
        protected final IInformationControlCreator enrichedInformationControlCreator;

        public EnrichableBrowserControlCreator(IInformationControlCreator enrichedInformationControlCreator, String statusFieldText) {
            super(statusFieldText);
            Assert.AssertNamespace.assertNotNull((Object)statusFieldText);
            this.enrichedInformationControlCreator = enrichedInformationControlCreator;
        }

        @Override
        public IInformationControlCreator getEnrichedInformationPresenterControlCreator() {
            return this.enrichedInformationControlCreator;
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(this.statusFieldText);
            }
            return true;
        }
    }
}

