/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.structure;

import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.AbstractWidget;
import melnorme.util.swt.components.misc.StatusMessageWidget;
import melnorme.utilbox.fields.ListenerListHelper;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractContentOutlinePage
extends Page
implements IContentOutlinePage,
IPostSelectionProvider {
    protected final ListenerListHelper<ISelectionChangedListener> selectionChangedListeners = new ListenerListHelper();
    protected final ListenerListHelper<ISelectionChangedListener> postSelectionChangedListeners = new ListenerListHelper();
    protected Composite topControl;
    protected TreeViewer treeViewer;
    protected StatusMessageWidget statusWidget;

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void dispose() {
        this.selectionChangedListeners.clear();
        this.postSelectionChangedListeners.clear();
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.topControl = SWTFactoryUtil.createGridComposite(parent, 1, null);
        this.topControl.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).create());
        this.statusWidget = new StatusMessageWidget(){

            @Override
            protected GridLayoutFactory createTopLevelLayout() {
                return GridLayoutFactory.fillDefaults().numColumns(this.getPreferredLayoutColumns()).margins(5, 5);
            }
        };
        this.statusWidget.createComponent(this.topControl, AbstractWidget.gdGrabHorizontal());
        this.createTreeViewer(this.topControl);
        this.treeViewer.getTree().setLayoutData((Object)AbstractWidget.gdGrabAll());
    }

    public Control getControl() {
        return this.topControl;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.setupTreeViewerListeners();
        this.createTreeViewerMenu();
        return this.treeViewer;
    }

    protected void createTreeViewerMenu() {
        Tree tree = this.treeViewer.getTree();
        String menuId = String.valueOf(LangUIPlugin.PLUGIN_ID) + ".OutlineContextMenu";
        MenuManager manager = new MenuManager("OutlineContextMenu", menuId);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                AbstractContentOutlinePage.this.contextMenuAboutToShow(m);
            }
        });
        Menu treeContextMenu = manager.createContextMenu((Control)tree);
        tree.setMenu(treeContextMenu);
        this.getSite().registerContextMenu(menuId, manager, (ISelectionProvider)this.treeViewer);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (menu.isEmpty()) {
            menu.add((IContributionItem)new Separator("additions"));
        }
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.addListener((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.addListener((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.removeListener((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.removeListener((Object)listener);
    }

    protected void setupTreeViewerListeners() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (ISelectionChangedListener listener : AbstractContentOutlinePage.this.selectionChangedListeners.getListeners()) {
                    listener.selectionChanged(event);
                }
                AbstractContentOutlinePage.this.treeViewerSelectionChanged(event);
            }
        });
        this.getTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (ISelectionChangedListener listener : AbstractContentOutlinePage.this.postSelectionChangedListeners.getListeners()) {
                    listener.selectionChanged(event);
                }
                AbstractContentOutlinePage.this.treeViewerPostSelectionChanged(event);
            }
        });
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }

    protected void treeViewerSelectionChanged(SelectionChangedEvent event) {
    }

    protected void treeViewerPostSelectionChanged(SelectionChangedEvent event) {
    }
}

