/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.structure;

import _org.eclipse.jdt.internal.ui.util.StringMatcher;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.editor.structure.EditorStructureUtil;
import melnorme.lang.ide.ui.editor.structure.StructureElementContentProvider;
import melnorme.lang.ide.ui.text.AbstractLangBasicSourceViewerConfiguration;
import melnorme.lang.ide.ui.views.AbstractFilteredTreePopupControl;
import melnorme.lang.ide.ui.views.StructureElementLabelProvider;
import melnorme.lang.tooling.structure.ISourceFileStructure;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class LangOutlineInformationControl
extends AbstractFilteredTreePopupControl {
    protected StringMatcher stringMatcher;

    public LangOutlineInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle);
    }

    protected abstract IPreferenceStore getPreferenceStore();

    @Override
    protected String getDialogSettingsId() {
        return String.valueOf(LangUIPlugin.PLUGIN_ID) + ".QuickOutline";
    }

    @Override
    protected void createTreeViewer(Composite parent, int treeStyle) {
        super.createTreeViewer(parent, treeStyle);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)StructureElementLabelProvider.createLangLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new StructureElementContentProvider());
    }

    @Override
    public void setInput(Object information) {
        ISourceFileStructure structure = null;
        if (information instanceof ISourceFileStructure) {
            structure = (ISourceFileStructure)information;
        }
        if (structure != null) {
            super.doSetInput(structure, null);
        } else {
            LangCore.logInternalError((Throwable)new Exception("Could not determine structure from input."));
            super.setInput(null);
        }
    }

    @Override
    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                EditorStructureUtil.openInEditorAndReveal(selectedElement);
            }
            catch (CoreException ce) {
                EclipseCore.logStatus((CoreException)ce);
            }
        }
    }

    @Override
    protected void setFilteringString(String pattern) {
        if (pattern.length() > 0) {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.stringMatcher = new StringMatcher(String.valueOf(pattern) + "*", ignoreCase, false);
        }
        super.setFilteringString(pattern);
    }

    @Override
    protected boolean matchNameDirectlyFilteredIn(String matchName) {
        return this.stringMatcher.match(matchName);
    }

    public static class OutlineInformationControlCreator
    implements IInformationControlCreator {
        protected final AbstractLangBasicSourceViewerConfiguration svc;

        public OutlineInformationControlCreator(AbstractLangBasicSourceViewerConfiguration svc) {
            this.svc = svc;
        }

        public IInformationControl createInformationControl(Shell parent) {
            int shellStyle = 16;
            int treeStyle = 768;
            return new LangOutlineInformationControl(parent, shellStyle, treeStyle){

                @Override
                protected IPreferenceStore getPreferenceStore() {
                    return svc.getPreferenceStore();
                }
            };
        }
    }
}

