/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.text;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public final class LangPairMatcher
extends DefaultCharacterPairMatcher
implements IDisposable {
    protected final char[] pairs;

    public LangPairMatcher(char[] pairs) {
        super(pairs, "___go_partioning", true);
        this.pairs = (char[])Assert.AssertNamespace.assertNotNull((Object)pairs);
    }

    public void dispose() {
        super.dispose();
    }

    private boolean isOpeningBracket(char character) {
        int i = 0;
        while (i < this.pairs.length) {
            if (character == this.pairs[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private boolean isClosingBracket(char character) {
        int i = 1;
        while (i < this.pairs.length) {
            if (character == this.pairs[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public int getOffsetAdjustment(IDocument document, int offset, int length) {
        block6: {
            if (length == 0 || Math.abs(length) > 1) {
                return 0;
            }
            if (length >= 0) break block6;
            if (this.isOpeningBracket(document.getChar(offset))) {
                return 1;
            }
        }
        try {
            if (this.isClosingBracket(document.getChar(offset - 1))) {
                return -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }
}

