/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.fields;

import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.LangUIMessages;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.fields.ButtonTextField;
import melnorme.utilbox.concurrency.OperationCancellation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectField
extends ButtonTextField {
    public ProjectField() {
        super("Project:", LangUIMessages.mainTab_projectButton);
    }

    protected IProject getProject() {
        String projectName = (String)this.getFieldValue();
        if (projectName == null || projectName.isEmpty()) {
            return null;
        }
        return EclipseUtils.getWorkspaceRoot().getProject(projectName);
    }

    @Override
    protected Composite doCreateTopLevelControl(Composite parent) {
        return SWTFactoryUtil.createGroup(parent, this.getLabelText(), 0);
    }

    @Override
    protected GridLayoutFactory createTopLevelLayout() {
        return GridLayoutFactory.swtDefaults().numColumns(this.getPreferredLayoutColumns());
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents_Label(Composite parent) {
    }

    @Override
    protected String getNewValueFromButtonSelection() throws OperationCancellation {
        IProject project = this.chooseProject();
        return project == null ? null : project.getName();
    }

    protected IProject chooseProject() throws OperationCancellation {
        Shell shell = this.button.getShell();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle(LangUIMessages.projectField_chooseProject_title);
        dialog.setMessage(LangUIMessages.projectField_chooseProject_message);
        try {
            Object[] projects = this.getDialogChooseElements();
            dialog.setElements(projects);
        }
        catch (CoreException ce) {
            EclipseCore.logStatus((CoreException)ce);
        }
        IProject project = this.getProject();
        if (project != null && project.isOpen()) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        throw new OperationCancellation();
    }

    protected IProject[] getDialogChooseElements() throws CoreException {
        return EclipseUtils.getOpenedProjects(null);
    }
}

