/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.launch;

import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.utils.ControlUtils;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.lang.ide.ui.utils.operations.BasicUIOperation;
import melnorme.lang.ide.ui.utils.operations.CalculateValueUIOperation;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.HashSet2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class BaseLaunchShortcut
implements ILaunchShortcut {
    protected Shell getActiveShell() {
        return WorkbenchUtils.getActiveWorkbenchShell();
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.launchElements(ssel.toArray(), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFile editorFile = EditorUtils.findFileOfEditor(editor);
        if (editorFile != null) {
            this.launchElements(CoreUtil.array((Object[])new IFile[]{editorFile}), mode);
        } else {
            UIOperationsStatusHandler.handleInternalError("Don't know how to launch editor.", null);
        }
    }

    public void launchElements(final Object[] elements, final String mode) {
        new CalculateValueUIOperation<ILaunchable[]>("Configuring launch"){

            @Override
            protected ILaunchable[] doBackgroundValueComputation(IOperationMonitor pm) throws CommonException, OperationCancellation {
                HashSet2 launchables = new HashSet2();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    BaseLaunchShortcut.this.doFindLaunchables((HashSet2<ILaunchable>)launchables, element, pm);
                    ++n2;
                }
                return (ILaunchable[])launchables.toArray(ILaunchable.class);
            }

            @Override
            protected void handleComputationResult(ILaunchable[] result) throws CommonException {
                BaseLaunchShortcut.this.handleFoundLaunchables(result, mode);
            }
        }.executeAndHandle();
    }

    protected void doFindLaunchables(HashSet2<ILaunchable> launchTargets, Object element, IOperationMonitor om) throws CommonException, OperationCancellation {
        ILaunchable launchTarget = this.getLaunchTargetForElement(element, om);
        if (launchTarget != null) {
            launchTargets.add((Object)launchTarget);
        }
    }

    protected abstract ILaunchable getLaunchTargetForElement(Object var1, IOperationMonitor var2) throws CommonException, OperationCancellation;

    protected void handleFoundLaunchables(ILaunchable[] launchables, String mode) throws CommonException {
        ILaunchable launchableResource;
        try {
            launchableResource = this.getLaunchableResource(launchables);
        }
        catch (OperationCancellation e) {
            return;
        }
        this.launchTarget(launchableResource, mode);
    }

    protected ILaunchable getLaunchableResource(ILaunchable[] launchables) throws CommonException, OperationCancellation {
        if (launchables == null || launchables.length == 0) {
            throw new CommonException("Selection contains no launchables");
        }
        if (launchables.length == 1) {
            return launchables[0];
        }
        return this.chooseLaunchable(launchables);
    }

    protected ILaunchable chooseLaunchable(ILaunchable[] launchTargets) throws OperationCancellation {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveShell(), (ILabelProvider)this.createLaunchTargetLabelProvider());
        dialog.setTitle("Select a launchable resource to launch");
        dialog.setMessage("Select a launchable resource to launch");
        return (ILaunchable)ControlUtils.setElementsAndOpenDialog(dialog, launchTargets);
    }

    protected LabelProvider createLaunchTargetLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                ILaunchable launchable = (ILaunchable)element;
                return launchable.getFullLabel();
            }
        };
    }

    public void launchTarget(final ILaunchable launchTarget, final String mode) {
        new BasicUIOperation("Preparing launch"){

            @Override
            public void execute() throws CommonException, OperationCancellation {
                try {
                    BaseLaunchShortcut.this.doLaunchTarget(launchTarget, mode);
                }
                catch (CoreException e) {
                    throw EclipseUtils.createCommonException((CoreException)e);
                }
            }
        }.executeAndHandle();
    }

    protected void doLaunchTarget(ILaunchable launchTarget, String mode) throws CoreException, OperationCancellation {
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(launchTarget);
        if (config == null) {
            config = launchTarget.createNewConfiguration();
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return (ILaunchConfigurationType)Assert.AssertNamespace.assertNotNull((Object)this.getLaunchManager().getLaunchConfigurationType(this.getLaunchTypeId()));
    }

    protected abstract String getLaunchTypeId();

    protected ILaunchConfiguration findExistingLaunchConfiguration(ILaunchable launchable) throws CoreException, OperationCancellation {
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(this.getLaunchConfigType());
        ArrayList2 matchingConfigs = new ArrayList2();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (launchable.matchesLaunchConfiguration(config)) {
                matchingConfigs.add((Object)config);
            }
            ++n2;
        }
        if (matchingConfigs.isEmpty()) {
            return null;
        }
        if (matchingConfigs.size() == 1) {
            return (ILaunchConfiguration)matchingConfigs.get(0);
        }
        return this.chooseConfiguration((Indexable<ILaunchConfiguration>)matchingConfigs);
    }

    protected ILaunchConfiguration chooseConfiguration(Indexable<ILaunchConfiguration> configs) throws OperationCancellation {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        try {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveShell(), (ILabelProvider)labelProvider);
            dialog.setTitle("Launch configurations");
            dialog.setMessage("&Select existing configuration:");
            dialog.setMultipleSelection(false);
            ILaunchConfiguration iLaunchConfiguration = ControlUtils.setElementsAndOpenDialog(dialog, configs);
            return iLaunchConfiguration;
        }
        finally {
            labelProvider.dispose();
        }
    }

    public static interface ILaunchable {
        public String getFullLabel();

        public IProject getProject();

        default public String getProjectName() {
            return this.getProject().getName();
        }

        public boolean matchesLaunchConfiguration(ILaunchConfiguration var1) throws CoreException;

        public ILaunchConfiguration createNewConfiguration() throws CoreException;
    }
}

