/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.launch;

import melnorme.lang.ide.core.launch.BuildTargetLaunchCreator;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.launch.BaseLaunchShortcut;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchShortcut;

public abstract class LangLaunchShortcut
extends BaseLaunchShortcut
implements ILaunchShortcut {
    public String getLaunchNameForSubTarget(String subTargetName) {
        return "[" + subTargetName + "]";
    }

    @Override
    protected BaseLaunchShortcut.ILaunchable getLaunchTargetForElement(Object element, IOperationMonitor om) throws CommonException, OperationCancellation {
        IProject project = this.getAssociatedProject(element);
        if (project == null) {
            return null;
        }
        BuildTargetLaunchCreator btLaunchCreator = new BuildTargetLaunchCreator();
        btLaunchCreator.initFromProject(project);
        return this.getLaunchableForElement(element, project, btLaunchCreator, om);
    }

    protected BuildTargetLaunchable getLaunchableForElement(Object element, IProject project, BuildTargetLaunchCreator btLaunchCreator, IOperationMonitor om) throws CommonException, OperationCancellation {
        return new BuildTargetLaunchable(project, btLaunchCreator);
    }

    protected IProject getAssociatedProject(Object element) {
        IResource resource = element instanceof IResource ? (IResource)element : (IResource)EclipseUtils.getAdapter((Object)element, IResource.class);
        return resource == null ? null : resource.getProject();
    }

    public class BuildTargetLaunchable
    implements BaseLaunchShortcut.ILaunchable {
        protected final IProject project;
        protected final BuildTargetLaunchCreator btLaunchCreator;

        public BuildTargetLaunchable(IProject project, BuildTargetLaunchCreator btLaunchCreator) {
            this.project = project;
            this.btLaunchCreator = btLaunchCreator;
            Assert.AssertNamespace.assertNotNull((Object)btLaunchCreator.getTargetName());
        }

        @Override
        public IProject getProject() {
            return this.project;
        }

        @Override
        public String getFullLabel() {
            return this.btLaunchCreator.getSuggestedConfigName();
        }

        public String getBuildTargetName() {
            return this.btLaunchCreator.getTargetName();
        }

        @Override
        public boolean matchesLaunchConfiguration(ILaunchConfiguration config) throws CoreException {
            BuildTargetLaunchCreator otherLaunchSettings = (BuildTargetLaunchCreator)EclipseUtils.callCore(() -> new BuildTargetLaunchCreator(config));
            BuildTargetData data = this.btLaunchCreator.data;
            BuildTargetData otherData = otherLaunchSettings.data;
            return CoreUtil.areEqual((Object)this.getProjectName(), (Object)otherLaunchSettings.projectName) && CoreUtil.areEqual((Object)data.targetName, (Object)otherData.targetName) && CoreUtil.areEqual((Object)data.buildCommand, (Object)otherData.buildCommand) && CoreUtil.areEqual((Object)data.executablePath, (Object)otherData.executablePath);
        }

        @Override
        public ILaunchConfiguration createNewConfiguration() throws CoreException {
            return (ILaunchConfiguration)EclipseUtils.callCore(() -> this.btLaunchCreator.createNewConfiguration(LangLaunchShortcut.this.getLaunchConfigType()));
        }
    }
}

