/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.launch;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.BuildTargetLaunchCreator;
import melnorme.lang.ide.core.launch.BuildTargetSource;
import melnorme.lang.ide.core.launch.CompositeBuildTargetSettings;
import melnorme.lang.ide.core.launch.ProjectLaunchSettings;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.build.BuildTargetEditor;
import melnorme.lang.ide.ui.launch.BuildTargetField;
import melnorme.lang.ide.ui.launch.ProjectBasedLaunchConfigurationTab;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonGetter;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class MainLaunchConfigurationTab
extends ProjectBasedLaunchConfigurationTab {
    protected final BuildManager buildManager = LangCore.getBuildManager();
    protected final BuildTargetSource buildTargetSource = this.init_buildTargetSource();
    protected final BuildTargetField buildTargetField = this.init_createBuildTargetField();
    protected final BuildTargetEditor buildTargetEditor = this.init_BuildTargetSettingsComponent();

    public MainLaunchConfigurationTab() {
        this(true);
    }

    public MainLaunchConfigurationTab(boolean initialize) {
        if (initialize) {
            this.initBindings();
        }
    }

    protected BuildTargetSource init_buildTargetSource() {
        return new BuildTargetSource(){

            public String getProjectName() {
                return MainLaunchConfigurationTab.this.getProjectName();
            }

            public String getBuildTargetName() {
                return MainLaunchConfigurationTab.this.getBuildTargetName();
            }
        };
    }

    protected BuildTargetField init_createBuildTargetField() {
        return new BuildTargetField();
    }

    protected BuildManager getBuildManager() {
        return this.buildManager;
    }

    protected ToolManager getToolManager() {
        return this.getBuildManager().getToolManager();
    }

    protected String getProgramPathString() {
        return (String)this.buildTargetEditor.programPathField.getFieldValue();
    }

    protected String getBuildTargetName() {
        return (String)this.buildTargetField.getFieldValue();
    }

    protected boolean isDefaultProgramPath() {
        return this.buildTargetEditor.programPathField.isUseDefault();
    }

    protected BuildTargetEditor init_BuildTargetSettingsComponent() {
        BuildTargetEditor component = new BuildTargetEditor(this.getBuildManager(), false, (CommonGetter<CommandInvocation>)((CommonGetter)this::getDefaultBuildTargetBuildCommand), (CommonGetter<String>)((CommonGetter)this::getDefaultProgramPath));
        component.programPathField.setLabelText("Path of launch executable:");
        component.buildCommandField.getEnablementField().setLabelText("Use Build Target settings");
        component.programPathField.getUseDefaultField().setLabelText("Use Build Target settings");
        return component;
    }

    protected CommandInvocation getDefaultBuildTargetBuildCommand() throws CommonException {
        return this.buildTargetSource.getBuildTarget().getEffectiveBuildCommand2();
    }

    protected String getDefaultProgramPath() throws CommonException {
        return this.buildTargetSource.getBuildTarget().getEffectiveValidExecutablePath();
    }

    protected CompositeBuildTargetSettings getBuildTargetSettings() throws CommonException {
        return new CompositeBuildTargetSettings(this.buildTargetSource){

            public CommandInvocation getBuildCommand() {
                return MainLaunchConfigurationTab.this.buildTargetEditor.getEffectiveBuildCommand();
            }

            public String getExecutablePath() {
                return MainLaunchConfigurationTab.this.buildTargetEditor.getEffectiveProgramPathValue();
            }
        };
    }

    @Override
    protected void doValidate() throws StatusException {
        super.doValidate();
        this.buildTargetField.validate();
        this.buildTargetEditor.validate();
    }

    protected void initBindings() {
        this.projectField.addChangeListener(this::projectFieldChanged);
        this.buildTargetField.addChangeListener(this::buildTargetFieldChanged);
        this.buildTargetEditor.buildCommandField.field().addChangeListener(this::updateLaunchConfigurationDialog);
        this.buildTargetEditor.programPathField.addChangeListener(this::updateLaunchConfigurationDialog);
    }

    public void projectFieldChanged() {
        ProjectBuildInfo buildInfo;
        IProject project = this.getValidProjectOrNull();
        if (project != null && (buildInfo = this.getBuildManager().getBuildInfo(project)) != null) {
            Collection2 buildTargets = buildInfo.getBuildTargets();
            this.buildTargetField.setFieldOptions((Indexable<String>)buildTargets.map(buildTarget -> buildTarget.getTargetName()));
        }
        this.updateLaunchConfigurationDialog();
    }

    public void buildTargetFieldChanged() {
        IProject project = this.getValidProjectOrNull();
        if (project != null) {
            this.buildTargetEditor.setInput(this.getBuildTargetData());
            this.updateLaunchConfigurationDialog();
        }
    }

    protected BuildTargetData getBuildTargetData() {
        return new BuildTargetData(this.getBuildTargetName(), true, true, (CommandInvocation)this.buildTargetEditor.buildCommandField.getEffectiveFieldValue(), this.buildTargetEditor.programPathField.getEffectiveFieldValue());
    }

    @Override
    protected void createCustomControls(Composite parent) {
        this.buildTargetField.createComponent(parent, new GridData(768));
        this.buildTargetEditor.createComponent(parent, new GridData(1808));
    }

    protected ProjectLaunchSettings getDefaultProjectLaunchSettings() {
        return new BuildTargetLaunchCreator();
    }

    protected BuildTargetLaunchCreator doInitializeFrom_createSettings(ILaunchConfiguration config) throws CommonException {
        try {
            return new BuildTargetLaunchCreator(config);
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException((CoreException)e);
        }
    }

    @Override
    public void doInitializeFrom(ILaunchConfiguration config) throws CommonException {
        BuildTargetLaunchCreator buildSettings = this.doInitializeFrom_createSettings(config);
        super.initializeFrom((ProjectLaunchSettings)buildSettings);
        this.initializeBuildTargetField(buildSettings);
        this.initializeBuildTargetSettings(buildSettings);
    }

    protected void initializeBuildTargetField(BuildTargetLaunchCreator btLaunchCreator) {
        this.buildTargetField.setFieldValue(btLaunchCreator.getTargetName());
    }

    protected void initializeBuildTargetSettings(BuildTargetLaunchCreator btLaunchCreator) {
        this.buildTargetEditor.buildCommandField.setEffectiveFieldValue(btLaunchCreator.getBuildCommand());
        this.buildTargetEditor.programPathField.setEffectiveFieldValue(btLaunchCreator.getExecutablePath());
    }

    @Override
    protected ProjectLaunchSettings getLaunchSettingsFromTab() {
        BuildTargetData btData = this.getBuildTargetData();
        return new BuildTargetLaunchCreator(this.getProjectName(), btData);
    }
}

