/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.ui.navigator.BuildTargetsContainer;
import melnorme.lang.ide.ui.navigator.ElementContainer;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.resources.IProject;

public class BuildTargetElement
extends ElementContainer<ElementContainer<?>> {
    protected final BuildTarget buildTarget;
    protected final IProject project;

    public BuildTargetElement(IProject project, BuildTarget buildTarget) {
        super(null);
        this.project = project;
        this.buildTarget = (BuildTarget)Assert.AssertNamespace.assertNotNull((Object)buildTarget);
    }

    public String getTargetDisplayName() {
        String targetName = this.buildTarget.getTargetName();
        return targetName.isEmpty() ? "<default>" : targetName;
    }

    public BuildManager getBuildManager() {
        return BuildManager.getInstance();
    }

    public BuildTarget getBuildTarget() {
        return this.buildTarget;
    }

    public IProject getProject() {
        return this.project;
    }

    protected ProjectBuildInfo getBuildInfoOrNull() {
        if (this.getParent() instanceof BuildTargetsContainer) {
            BuildTargetsContainer buildTargetsContainer = (BuildTargetsContainer)this.getParent();
            return buildTargetsContainer.buildInfo;
        }
        return null;
    }

    public int getOrder() {
        ProjectBuildInfo buildInfo = this.getBuildInfoOrNull();
        if (buildInfo == null) {
            return 0;
        }
        return buildInfo.getBuildTargets().indexUntil(elem -> elem.getTargetName().equals(this.buildTarget.getTargetName()));
    }
}

