/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import java.text.MessageFormat;
import melnorme.lang.ide.core.launch.BuildTargetLaunchCreator;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.ui.launch.LangLaunchShortcut;
import melnorme.lang.ide.ui.navigator.BuildTargetElement;
import melnorme.lang.ide.ui.navigator.BuildTargetsContainer;
import melnorme.lang.ide.ui.navigator.LangNavigatorActionProvider;
import melnorme.lang.ide.ui.utils.BuildUtilities;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.ide.ui.utils.operations.AbstractJobUIOperation;
import melnorme.lang.tooling.bundle.LaunchArtifact;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.fntypes.CommonGetter;
import melnorme.utilbox.ownership.Disposable;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class BuildTargetsActionGroup
extends LangNavigatorActionProvider.ViewPartActionGroup {
    public BuildTargetsActionGroup(IViewPart viewPart) {
        super(viewPart);
    }

    public void fillContextMenu(IMenuManager menu) {
        Object firstSel = this.getSelectionFirstElement();
        if (firstSel instanceof BuildTargetsContainer) {
            BuildTargetsContainer buildTargetsContainer = (BuildTargetsContainer)firstSel;
            menu.add((IAction)new BuildAllTargetsAction(buildTargetsContainer));
            menu.add((IAction)new BuildEnabledTargetsAction(buildTargetsContainer));
            menu.add((IContributionItem)new Separator("additions"));
            menu.add((IAction)new ConfigureBuildTargetAction(buildTargetsContainer));
        }
        if (firstSel instanceof BuildTargetElement) {
            BuildTargetElement buildTargetElement = (BuildTargetElement)firstSel;
            menu.add((IAction)new BuildSingleTargetAction(buildTargetElement));
            this.addLaunchActions(menu, buildTargetElement);
            menu.add((IContributionItem)new Separator("configure_BuildTarget"));
            menu.add((IAction)new ToggleEnabledAction(buildTargetElement));
            menu.add((IAction)new ToggleAutoBuildEnabledAction(buildTargetElement));
            menu.add((IAction)new ConfigureBuildTargetAction(buildTargetElement));
        }
    }

    protected void addLaunchActions(IMenuManager menu, BuildTargetElement buildTargetElement) {
        BuildTarget buildTarget = buildTargetElement.getBuildTarget();
        LaunchArtifact mainLaunchArtifact = (LaunchArtifact)CommonGetter.getOrNull(() -> ((BuildTarget)buildTarget).getMainLaunchArtifact());
        Indexable launchSubArtifacts = (Indexable)CommonGetter.getOrNull(() -> ((BuildTarget)buildTarget).getSubLaunchArtifacts());
        String suggestedLaunchSuffix = buildTargetElement.getTargetDisplayName();
        if (buildTarget.isDefaultBuildType()) {
            suggestedLaunchSuffix = null;
        }
        LaunchBuildTargetAction runTargetAction = new LaunchBuildTargetAction(buildTargetElement, true, null, suggestedLaunchSuffix, MessageFormat.format("Run {0}", buildTargetElement.getTargetDisplayName()));
        LaunchBuildTargetAction debugTargetAction = new LaunchBuildTargetAction(buildTargetElement, false, null, suggestedLaunchSuffix, MessageFormat.format("Debug {0}", buildTargetElement.getTargetDisplayName()));
        if (launchSubArtifacts == null) {
            if (mainLaunchArtifact != null) {
                menu.add((IAction)runTargetAction);
                menu.add((IAction)debugTargetAction);
            }
            return;
        }
        MenuManager runSubTargetsMenu = new MenuManager("Run ");
        MenuManager debugSubTargetsMenu = new MenuManager("Debug ");
        if (mainLaunchArtifact != null) {
            this.addMainArtifactAction(buildTarget, runTargetAction, debugTargetAction, runSubTargetsMenu, debugSubTargetsMenu);
        }
        for (LaunchArtifact launchArtifact : launchSubArtifacts) {
            String launchName = this.createLaunchShortcut().getLaunchNameForSubTarget(launchArtifact.getName());
            String artifactPath = launchArtifact.getArtifactPath();
            runSubTargetsMenu.add((IAction)new LaunchBuildTargetAction(buildTargetElement, true, artifactPath, launchName, "Run " + launchName + " - " + artifactPath));
            debugSubTargetsMenu.add((IAction)new LaunchBuildTargetAction(buildTargetElement, false, artifactPath, launchName, "Debug " + launchName + " - " + artifactPath));
        }
        menu.add((IContributionItem)runSubTargetsMenu);
        menu.add((IContributionItem)debugSubTargetsMenu);
    }

    protected void addMainArtifactAction(BuildTarget buildTarget, LaunchBuildTargetAction runTargetAction, LaunchBuildTargetAction debugTargetAction, MenuManager runSubTargetsMenu, MenuManager debugSubTargetsMenu) {
        if (buildTarget.isDefaultBuildType()) {
            runTargetAction.setText("Run default executable");
            debugTargetAction.setText("Debug default executable");
        }
        runSubTargetsMenu.add((IAction)runTargetAction);
        runSubTargetsMenu.add((IContributionItem)new Separator());
        debugSubTargetsMenu.add((IAction)debugTargetAction);
        debugSubTargetsMenu.add((IContributionItem)new Separator());
    }

    public void fillActionBars(IActionBars actionBars) {
        Object firstSel = this.getSelectionFirstElement();
        if (firstSel instanceof BuildTargetElement) {
            BuildTargetElement buildTargetElement = (BuildTargetElement)firstSel;
            this.fillActionBars(actionBars, buildTargetElement);
        }
    }

    protected void fillActionBars(IActionBars actionBars, BuildTargetElement buildTargetElement) {
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)new BuildSingleTargetAction(buildTargetElement));
    }

    public static BuildTargetLaunchCreator buildTargetLaunchCreator(IProject project, String targetName, String executablePath, String launchNameSuffixSuggestion) {
        BuildTargetData buildTargetData = new BuildTargetData(targetName, false, false, null, executablePath);
        return new BuildTargetLaunchCreator(project.getName(), buildTargetData, launchNameSuffixSuggestion);
    }

    protected abstract LangLaunchShortcut createLaunchShortcut();

    protected String getProjectConfigPropertyPage() {
        return "com.googlecode.goclipse.ui.propertyPages.ProjectBuildConfiguration";
    }

    public static abstract class AbstractBuildElementAction
    extends Action {
        protected final BuildManager buildManager;
        protected final IProject project;
        protected final String opName;

        public AbstractBuildElementAction(BuildTargetsContainer buildTargetContainer, String opName) {
            this(buildTargetContainer, opName, 0);
        }

        public AbstractBuildElementAction(BuildTargetsContainer buildTargetContainer, String opName, int style) {
            this(buildTargetContainer.getBuildManager(), buildTargetContainer.getProject(), opName, style);
        }

        public AbstractBuildElementAction(BuildManager buildManager, IProject project, String opName, int style) {
            super(opName, style);
            this.buildManager = (BuildManager)Assert.AssertNamespace.assertNotNull((Object)buildManager);
            this.project = (IProject)Assert.AssertNamespace.assertNotNull((Object)project);
            this.opName = opName;
        }

        public IProject getProject() {
            return this.project;
        }

        public BuildManager getBuildManager() {
            return this.buildManager;
        }

        public ProjectBuildInfo getBuildInfo() {
            return this.getBuildManager().getBuildInfo(this.getProject());
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (StatusException se) {
                UIOperationsStatusHandler.handleStatus(this.getStatusDialogTitle(), se);
            }
        }

        protected String getStatusDialogTitle() {
            return "Error during: " + this.getText();
        }

        public void doRun() throws StatusException {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Disposable reg = this.buildManager.autoBuildsEnablement().enterDisable();){
                BuildUtilities.saveEditors((Indexable<IProject>)CoreUtil.list((Object[])new IProject[]{this.getProject()}));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            new AbstractJobUIOperation(this.getJobTitle()){

                @Override
                protected void doBackgroundComputation(IOperationMonitor om) throws CommonException, OperationCancellation {
                    this.doJobRun(om);
                }
            }.execute();
        }

        protected String getJobTitle() {
            return this.opName;
        }

        protected void doJobRun(IOperationMonitor om) throws CommonException, OperationCancellation {
        }
    }

    public static abstract class AbstractBuildTargetAction
    extends AbstractBuildElementAction {
        protected final BuildTargetElement buildTargetElement;
        protected final BuildTarget buildTarget;

        public AbstractBuildTargetAction(BuildTargetElement buildTargetElement, String text) {
            this(buildTargetElement, text, 0);
        }

        public AbstractBuildTargetAction(BuildTargetElement buildTargetElement, String text, int style) {
            super(buildTargetElement.getBuildManager(), buildTargetElement.project, text, style);
            this.buildTargetElement = (BuildTargetElement)Assert.AssertNamespace.assertNotNull((Object)buildTargetElement);
            this.buildTarget = buildTargetElement.getBuildTarget();
        }

        protected String getBuildTargetName() {
            return this.buildTarget.getBuildTargetName();
        }
    }

    public static class BuildAllTargetsAction
    extends AbstractBuildElementAction {
        public BuildAllTargetsAction(BuildTargetsContainer buildTargetContainer) {
            super(buildTargetContainer, "Build All");
        }

        @Override
        protected void doJobRun(IOperationMonitor om) throws CommonException, OperationCancellation {
            Collection2 enabledTargets = this.getBuildInfo().getBuildTargets();
            this.getBuildManager().newBuildTargetsOperation(this.getProject(), enabledTargets).execute(om);
        }
    }

    public static class BuildEnabledTargetsAction
    extends AbstractBuildElementAction {
        public BuildEnabledTargetsAction(BuildTargetsContainer buildTargetContainer) {
            super(buildTargetContainer, "Build Enabled");
        }

        @Override
        protected void doJobRun(IOperationMonitor om) throws CommonException, OperationCancellation {
            ArrayList2 enabledTargets = this.getBuildInfo().getEnabledTargets(true);
            this.getBuildManager().newBuildTargetsOperation(this.getProject(), (Collection2)enabledTargets).execute(om);
        }
    }

    public static class BuildSingleTargetAction
    extends AbstractBuildTargetAction {
        public BuildSingleTargetAction(BuildTargetElement buildTargetElement) {
            super(buildTargetElement, "Build target");
        }

        @Override
        protected String getJobTitle() {
            return MessageFormat.format("Building target `{1}` of project {0}", this.getProject().getName(), this.buildTargetElement.getTargetDisplayName());
        }

        @Override
        public void doRun() throws StatusException {
            super.doRun();
        }

        @Override
        protected void doJobRun(IOperationMonitor om) throws CommonException, OperationCancellation {
            this.getBuildManager().newBuildTargetOperation(this.getProject(), this.buildTarget).execute(om);
        }
    }

    public class ConfigureBuildTargetAction
    extends AbstractBuildElementAction {
        protected String targetName;

        public ConfigureBuildTargetAction(BuildTargetsContainer buildTargetContainer) {
            super(buildTargetContainer.getBuildManager(), buildTargetContainer.getProject(), "Configure targets...", 0);
        }

        public ConfigureBuildTargetAction(BuildTargetElement buildTargetElement) {
            super(buildTargetElement.getBuildManager(), buildTargetElement.getProject(), "Configure target...", 0);
            this.targetName = buildTargetElement.getBuildTarget().getTargetName();
        }

        @Override
        public void doRun() throws StatusException {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)BuildTargetsActionGroup.this.getShell(), (IAdaptable)this.getProject(), (String)BuildTargetsActionGroup.this.getProjectConfigPropertyPage(), null, (Object)this.targetName);
            dialog.open();
        }
    }

    public class LaunchBuildTargetAction
    extends AbstractBuildTargetAction {
        public String mode;
        public BuildTargetLaunchCreator launchCreator;

        public LaunchBuildTargetAction(BuildTargetElement buildTargetElement, boolean isRun, String exePathOverride, String launchNameSuggestion, String actionText) {
            super(buildTargetElement, "");
            this.mode = isRun ? "run" : "debug";
            this.setText(actionText);
            String targetName = this.buildTarget.getTargetName();
            this.launchCreator = BuildTargetsActionGroup.buildTargetLaunchCreator(this.project, targetName, exePathOverride, launchNameSuggestion);
        }

        protected String getTargetName() {
            return this.buildTarget.getTargetName();
        }

        @Override
        public void doRun() throws StatusException {
            LangLaunchShortcut launchShortcut;
            LangLaunchShortcut langLaunchShortcut = launchShortcut = BuildTargetsActionGroup.this.createLaunchShortcut();
            langLaunchShortcut.getClass();
            LangLaunchShortcut.BuildTargetLaunchable launchable = langLaunchShortcut.new LangLaunchShortcut.BuildTargetLaunchable(this.project, this.launchCreator);
            launchShortcut.launchTarget(launchable, this.mode);
        }
    }

    public static class ToggleAutoBuildEnabledAction
    extends ToggleEnabledAction {
        public ToggleAutoBuildEnabledAction(BuildTargetElement buildTargetElement) {
            super(buildTargetElement);
            this.setText("Enable for auto-check (invoke on editor save)");
            this.setChecked(this.buildTarget.isAutoBuildEnabled());
        }

        @Override
        protected void doRun0() throws CommonException {
            this.getBuildInfo().changeEnable(this.getBuildTargetName(), this.buildTarget.isNormalBuildEnabled(), this.isChecked());
        }
    }

    public static class ToggleEnabledAction
    extends AbstractBuildTargetAction {
        public ToggleEnabledAction(BuildTargetElement buildTargetElement) {
            super(buildTargetElement, "Enable for workspace build", 2);
            this.setChecked(this.buildTarget.isNormalBuildEnabled());
        }

        @Override
        public void doRun() throws StatusException {
            try {
                this.doRun0();
            }
            catch (CommonException e) {
                throw e.toStatusException(Severity.ERROR);
            }
        }

        protected void doRun0() throws CommonException {
            this.getBuildInfo().changeEnable(this.getBuildTargetName(), this.isChecked(), this.buildTarget.isAutoBuildEnabled());
        }
    }
}

