/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.project_model.view.DependenciesContainer;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.actions.RunUIOperationAction;
import melnorme.lang.ide.ui.navigator.BuildTargetsActionGroup;
import melnorme.lang.ide.ui.utils.operations.AbstractUIOperation;
import melnorme.utilbox.collections.ArrayList2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public abstract class LangNavigatorActionProvider
extends CommonActionProvider {
    protected final ArrayList2<ActionGroup> actionGroups = new ArrayList2();

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite && (workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite()).getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.initActionGroups(viewPart);
        }
    }

    protected void initActionGroups(IViewPart viewPart) {
        this.actionGroups.add((Object)this.createBuildTargetsActionGroup(viewPart));
        this.actionGroups.add((Object)this.createProjectBuildActionGroup(viewPart));
    }

    public void setContext(ActionContext context) {
        for (ActionGroup actionGroup : this.actionGroups) {
            actionGroup.setContext(context);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        for (ActionGroup actionGroup : this.actionGroups) {
            actionGroup.fillActionBars(actionBars);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        for (ActionGroup actionGroup : this.actionGroups) {
            actionGroup.fillContextMenu(menu);
        }
    }

    protected abstract BuildTargetsActionGroup createBuildTargetsActionGroup(IViewPart var1);

    protected BuildOperationsActionGroup createProjectBuildActionGroup(IViewPart viewPart) {
        return new BuildOperationsActionGroup(viewPart);
    }

    public static class BuildOperationsActionGroup
    extends ViewPartActionGroup {
        protected final BuildAction buildAction = new BuildAction(() -> viewPart.getSite().getShell(), 10);

        public BuildOperationsActionGroup(IViewPart viewPart) {
            super(viewPart);
            this.buildAction.setActionDefinitionId("org.eclipse.ui.project.buildProject");
        }

        public void fillContextMenu(IMenuManager menu) {
            IProject project = this.getBundleProjectFromSelection();
            if (project == null) {
                return;
            }
            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                IStructuredSelection structuredSel = this.getStructuredSelection();
                if (structuredSel != null) {
                    this.buildAction.selectionChanged(structuredSel);
                }
                menu.appendToGroup("group.build", (IAction)this.buildAction);
            }
        }
    }

    public static abstract class BundleOperationsActionGroup
    extends ViewPartActionGroup {
        public BundleOperationsActionGroup(IViewPart viewPart) {
            super(viewPart);
        }

        public void fillContextMenu(IMenuManager menu) {
            IProject project = this.getBundleProjectFromSelection();
            if (project == null) {
                return;
            }
            MenuManager bundleOpsMenu = new MenuManager(this.getMenuName(), LangImages.NAV_Library, "bundleMenu");
            this.initActions(bundleOpsMenu, project);
            menu.prependToGroup("group.build", (IContributionItem)bundleOpsMenu);
        }

        protected abstract String getMenuName();

        protected abstract void initActions(MenuManager var1, IProject var2);

        protected void addRunOperationAction(MenuManager bundleOpsMenu, AbstractUIOperation operation) {
            bundleOpsMenu.add((IAction)new RunUIOperationAction(operation));
        }
    }

    public static class ViewPartActionGroup
    extends ActionGroup {
        protected final IViewPart viewPart;

        public ViewPartActionGroup(IViewPart viewPart) {
            this.viewPart = viewPart;
        }

        protected Shell getShell() {
            return this.viewPart.getSite().getShell();
        }

        protected IStructuredSelection getStructuredSelection() {
            ISelection selection = this.getContext().getSelection();
            if (selection instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            return null;
        }

        protected Object getSelectionFirstElement() {
            IStructuredSelection ssel = this.getStructuredSelection();
            if (ssel != null) {
                return ssel.getFirstElement();
            }
            return this.getContext().getSelection();
        }

        public IProject getBundleProjectFromSelection() {
            Object selElement = this.getSelectionFirstElement();
            if (selElement instanceof IProject) {
                return (IProject)selElement;
            }
            if (selElement instanceof DependenciesContainer) {
                DependenciesContainer dependenciesContainer = (DependenciesContainer)selElement;
                return (IProject)dependenciesContainer.getParent();
            }
            if (selElement instanceof IFile) {
                IFile file = (IFile)selElement;
                if (LangCore.getBundleModelManager().resourceIsManifest((IResource)file)) {
                    return file.getProject();
                }
            }
            return null;
        }
    }
}

