/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.preferences;

import melnorme.lang.ide.core.text.format.FormatterIndentMode;
import melnorme.lang.ide.ui.CodeFormatterConstants;
import melnorme.lang.ide.ui.LangAutoEditPreferenceConstants;
import melnorme.lang.ide.ui.preferences.common.AbstractPreferencesBlock2;
import melnorme.lang.ide.ui.preferences.common.PreferencesPageContext;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.util.swt.components.fields.ComboBoxField;
import melnorme.util.swt.components.fields.NumberField;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.fields.FieldValueListener;
import org.eclipse.swt.widgets.Composite;

public class EditorTypingConfigurationBlock
extends AbstractPreferencesBlock2 {
    public EditorTypingConfigurationBlock(PreferencesPageContext prefContext) {
        super(prefContext);
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 1;
    }

    @Override
    protected void createContents(Composite topControl) {
        this.createAutoClosingGroup(topControl);
        this.createAutoEditGroup(topControl);
        this.createIndentationGroup(topControl);
    }

    protected void createAutoClosingGroup(Composite parent) {
        Composite group = EditorTypingConfigurationBlock.createSubsection(parent, "Automatically close:", 2);
        this.createAndBindComponent(group, LangAutoEditPreferenceConstants.AE_CLOSE_BRACES, new CheckBoxField("{Braces}"));
    }

    protected Composite createAutoEditGroup(Composite parent) {
        Composite group = EditorTypingConfigurationBlock.createSubsection(parent, "Auto Indent", 2);
        this.createAndBindComponent(group, LangAutoEditPreferenceConstants.AE_SMART_INDENT, new CheckBoxField("Smart indent on newline"));
        this.createAndBindComponent(group, LangAutoEditPreferenceConstants.AE_SMART_DEINDENT, new CheckBoxField("Smart indent deletion (delete full indent)"));
        this.createAndBindComponent(group, LangAutoEditPreferenceConstants.AE_PARENTHESES_AS_BLOCKS, new CheckBoxField("Consider (parentheses) the same as {braces} for block smart indent"));
        return group;
    }

    protected void createIndentationGroup(Composite composite) {
        Composite generalGroup = EditorTypingConfigurationBlock.createSubsection(composite, "Indentation", 2);
        String[] INDENT_MODE__LABELS = new String[]{"Tabs", "Spaces"};
        String[] INDENT_MODE__VALUES = (String[])CoreUtil.array((Object[])new String[]{FormatterIndentMode.TAB.toString(), FormatterIndentMode.SPACES.toString()});
        final ComboBoxField indentModeField = new ComboBoxField("Indentation mode:", INDENT_MODE__LABELS, INDENT_MODE__VALUES);
        this.createCheckboxField(generalGroup, CodeFormatterConstants.FORMATTER_INDENT_MODE, indentModeField);
        this.createIntField(generalGroup, CodeFormatterConstants.FORMATTER_TAB_SIZE, this.createNumberField("Displayed tab &size:", 2));
        final NumberField indentationSizeField = this.createNumberField("&Indentation size (for spaces policy):", 2);
        this.createIntField(generalGroup, CodeFormatterConstants.FORMATTER_INDENTATION_SPACES_SIZE, indentationSizeField);
        FieldValueListener.FieldChangeListener indentModeValueListener = new FieldValueListener.FieldChangeListener(){

            public void fieldValueChanged() {
                boolean enabled = CoreUtil.areEqual((Object)indentModeField.getFieldStringValue(), (Object)FormatterIndentMode.SPACES.toString());
                indentationSizeField.setEnabled(enabled);
            }
        };
        indentModeField.addChangeListener(indentModeValueListener);
        indentModeValueListener.fieldValueChanged();
    }
}

