/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.preferences;

import java.util.Map;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.BuildTargetSource;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.core.utils.ProjectValidator;
import melnorme.lang.ide.ui.build.BuildTargetEditor;
import melnorme.lang.ide.ui.launch.BuildTargetField;
import melnorme.lang.ide.ui.preferences.common.IPreferencesEditor;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.CompositeWidget;
import melnorme.util.swt.components.IDisableableWidget;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonGetter;
import melnorme.utilbox.status.Severity;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ProjectBuildConfigurationComponent
extends CompositeWidget
implements IPreferencesEditor {
    protected final BuildManager buildManager = LangCore.getBuildManager();
    protected final IProject project;
    protected final BuildTargetField buildTargetField;
    protected final BuildTargetEditor buildTargetEditor;
    protected final HashMap2<String, BuildTargetData> buildOptionsToChange = new HashMap2();
    protected final BuildTargetSource buildTargetSource = new BuildTargetSource(){

        public String getProjectName() {
            return ProjectBuildConfigurationComponent.this.project == null ? null : ProjectBuildConfigurationComponent.this.project.getName();
        }

        public String getBuildTargetName() {
            return ProjectBuildConfigurationComponent.this.getBuildTargetName();
        }
    };

    public ProjectBuildConfigurationComponent(IProject project) {
        super(false);
        this.project = project;
        this.buildTargetField = this.init_createBuildTargetField();
        this.buildTargetEditor = this.init_createBuildTargetSettingsComponent();
        this.addChildWidget(this.buildTargetField);
        this.addChildWidget(this.buildTargetEditor);
        this.buildTargetField.addListener(true, __ -> this.handleBuildTargetChanged());
        this.initialize();
    }

    protected BuildTargetField init_createBuildTargetField() {
        return new BuildTargetField();
    }

    protected BuildTargetEditor init_createBuildTargetSettingsComponent() {
        return new BuildTargetEditor(this.getBuildManager(), true, (CommonGetter<CommandInvocation>)((CommonGetter)this::getDefaultBuildCommand), (CommonGetter<String>)((CommonGetter)this::getDefaultExecutablePath));
    }

    public BuildTargetField getBuildTargetField() {
        return this.buildTargetField;
    }

    public BuildTargetEditor getBuildTargetEditor() {
        return this.buildTargetEditor;
    }

    protected BuildManager getBuildManager() {
        return this.buildManager;
    }

    public IProject getValidProject() throws CommonException {
        if (this.project == null) {
            throw new CommonException(new ProjectValidator().msg_ProjectNotSpecified());
        }
        return this.project;
    }

    public String getBuildTargetName() {
        return (String)this.buildTargetField.getFieldValue();
    }

    protected ProjectBuildInfo getBuildInfo() throws CommonException {
        return this.getBuildManager().getValidBuildInfo(this.getValidProject());
    }

    protected void initialize() {
        ProjectBuildInfo buildInfo;
        try {
            buildInfo = this.getBuildInfo();
        }
        catch (CommonException ce) {
            this.handleStatusException(ce);
            return;
        }
        this.buildOptionsToChange.clear();
        Collection2 buildTargets = buildInfo.getBuildTargets();
        for (BuildTarget buildTarget2 : buildTargets) {
            this.buildOptionsToChange.put((Object)buildTarget2.getTargetName(), (Object)buildTarget2.getDataCopy());
        }
        this.buildTargetField.setFieldOptions((Indexable<String>)buildInfo.getBuildTargets().map(buildTarget -> buildTarget.getTargetName()));
    }

    protected void handleBuildTargetChanged() {
        String buildTargetName = this.getBuildTargetName();
        this.buildTargetEditor.setEnabled(buildTargetName != null);
        if (buildTargetName == null) {
            return;
        }
        BuildTargetData buildTargetData = (BuildTargetData)this.buildOptionsToChange.get((Object)buildTargetName);
        this.buildTargetEditor.setInput(buildTargetData);
    }

    public BuildTarget getOriginalBuildTarget() throws CommonException {
        return this.buildTargetSource.getBuildTarget();
    }

    public CommandInvocation getDefaultBuildCommand() throws CommonException {
        String defaultBuildCommandArgs = this.getOriginalBuildTarget().getDefaultBuildCommand();
        return new CommandInvocation(defaultBuildCommandArgs);
    }

    public String getDefaultExecutablePath() throws CommonException {
        return this.getOriginalBuildTarget().getDefaultExecutablePath();
    }

    protected void handleStatusException(CommonException ce) {
        UIOperationsStatusHandler.handleStatus(true, "Error", ce.toStatusException(Severity.ERROR));
    }

    @Override
    protected void createContents(Composite topControl) {
        super.createContents(topControl);
        SWTFactoryUtil.createPushButton(topControl, "Restore all targets to defaults", null, new GridData(128), e -> this.loadDefaults());
    }

    @Override
    protected GridData getLayoutData(IDisableableWidget subComponent) {
        return super.getLayoutData(subComponent);
    }

    @Override
    public boolean saveSettings() {
        if (this.project == null) {
            return false;
        }
        try {
            this.doSaveSettings();
        }
        catch (CommonException e) {
            return false;
        }
        this.updateWidgetFromInput();
        return true;
    }

    @Override
    public void doSaveSettings() throws CommonException {
        for (Map.Entry entry : this.buildOptionsToChange.entrySet()) {
            String targetName = (String)entry.getKey();
            BuildTargetData value = (BuildTargetData)entry.getValue();
            this.getBuildInfo().changeBuildTarget(targetName, value);
        }
    }

    @Override
    public void loadDefaults() {
        ProjectBuildInfo buildInfo;
        if (this.project == null) {
            return;
        }
        try {
            buildInfo = this.getBuildInfo();
        }
        catch (CommonException e) {
            UIOperationsStatusHandler.handleStatus(true, "Error loading defaults", e);
            return;
        }
        for (Map.Entry entry : this.buildOptionsToChange) {
            String targetName = (String)entry.getKey();
            BuildTargetData newData = buildInfo.getDefaultBuildTarget(targetName).getDataCopy();
            entry.setValue(newData);
        }
        this.handleBuildTargetChanged();
    }
}

