/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.preferences;

import melnorme.lang.ide.core.utils.prefs.IGlobalPreference;
import melnorme.lang.ide.core.utils.prefs.IProjectPreference;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.preferences.common.AbstractPreferencesBlock2;
import melnorme.lang.ide.ui.preferences.common.IPreferencesEditor;
import melnorme.lang.ide.ui.preferences.common.PreferencesPageContext;
import melnorme.lang.ide.ui.utils.ControlUtils;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.AbstractDisableableWidget;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.fields.IProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;

public abstract class ProjectPreferencesBlock
extends AbstractPreferencesBlock2
implements IPreferencesEditor {
    protected final IProject project;
    protected final IProjectPreference<Boolean> useProjectSettingsPref;
    protected final CheckBoxField useProjectSettingsField = new CheckBoxField("Use project specific settings");
    protected final AbstractDisableableWidget projectSettingsBlock;

    public ProjectPreferencesBlock(IProject project, IProjectPreference<Boolean> useProjectSettingsPref) {
        super(new ProjectPreferencesPageContext(project, useProjectSettingsPref));
        this.project = project;
        this.useProjectSettingsPref = useProjectSettingsPref;
        this.projectSettingsBlock = this.init_createProjectSettingsBlock2();
        this.useProjectSettingsField.registerListener(newValue -> this.projectSettingsBlock.setEnabled((boolean)newValue));
        this.prefContext.bindToPreference(this.useProjectSettingsField, useProjectSettingsPref);
        this.validation.addStatusField(true, this.projectSettingsBlock.getStatusField());
    }

    protected abstract AbstractDisableableWidget init_createProjectSettingsBlock2();

    @Override
    public void doSaveSettings() throws CommonException {
        this.prefContext.doSaveSettings();
    }

    @Override
    public void loadDefaults() {
        this.prefContext.loadDefaults();
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents(Composite topControl) {
        this.useProjectSettingsField.createComponent(topControl, GridDataFactory.fillDefaults().create());
        String prefPageId = this.getWorkspacePrefPageId();
        Link link = ControlUtils.createOpenPreferencesDialogLink(topControl, prefPageId, "Configure workspace settings", null);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)link);
        SWTFactoryUtil.createLabel(topControl, 258, "", GridDataFactory.fillDefaults().span(2, 1).create());
        this.projectSettingsBlock.createComponent(topControl, ProjectPreferencesBlock.gdfFillDefaults().span(2, 1).grab(true, false).create());
        this.useProjectSettingsField.fireFieldValueChanged();
    }

    protected String getWorkspacePrefPageId() {
        return String.valueOf(LangUIPlugin.PLUGIN_ID) + ".PreferencePages.Root";
    }

    public static class PreferencePropertyBinding<T>
    implements IPreferencesEditor {
        protected final IProperty<T> property;
        protected final IProjectPreference<T> preference;
        protected final IProject project;

        public PreferencePropertyBinding(IProperty<T> property, IProjectPreference<T> preference, IProject project) {
            this.property = property;
            this.preference = preference;
            this.project = project;
            property.set(preference.getStoredValue(CoreUtil.option((Object)project)));
        }

        public void updateFieldFromInput() {
            this.property.set(this.preference.getStoredValue(CoreUtil.option((Object)this.project)));
        }

        @Override
        public void loadDefaults() {
            this.property.set(this.preference.getGlobalPreference().get());
        }

        @Override
        public void doSaveSettings() throws CommonException {
            this.preference.setValue(this.project, this.property.get());
        }
    }

    protected static class ProjectPreferencesPageContext
    extends PreferencesPageContext {
        protected final IProject project;
        protected final IProjectPreference<Boolean> useProjectSettingsPref;

        public ProjectPreferencesPageContext(IProject project, IProjectPreference<Boolean> useProjectSettingsPref) {
            this.project = (IProject)Assert.AssertNamespace.assertNotNull((Object)project);
            this.useProjectSettingsPref = (IProjectPreference)Assert.AssertNamespace.assertNotNull(useProjectSettingsPref);
        }

        @Override
        public <T> IPreferencesEditor getPreferencesBinder(IProperty<T> field, IGlobalPreference<T> globalPref) {
            IProjectPreference pref = globalPref.getProjectPreference();
            Assert.AssertNamespace.assertTrue((pref == this.useProjectSettingsPref || pref.getEnableProjectSettingPref() == this.useProjectSettingsPref ? 1 : 0) != 0);
            return new PreferencePropertyBinding<T>(field, pref, this.project);
        }
    }
}

