/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.preferences.common;

import melnorme.lang.ide.core.CoreSettings;
import melnorme.lang.ide.core.utils.prefs.DerivedValuePreference;
import melnorme.lang.ide.core.utils.prefs.IGlobalPreference;
import melnorme.lang.ide.core.utils.prefs.IProjectPreference;
import melnorme.lang.ide.ui.preferences.common.IPreferencesEditor;
import melnorme.util.swt.components.FieldWidget;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.IField;
import melnorme.utilbox.fields.IProperty;
import melnorme.utilbox.fields.validation.ValidationField;

public class PreferencesPageContext
implements IPreferencesEditor {
    protected final ArrayList2<IPreferencesEditor> prefAdapters = new ArrayList2();

    @Override
    public void loadDefaults() {
        for (IPreferencesEditor prefAdapter : this.prefAdapters) {
            prefAdapter.loadDefaults();
        }
    }

    @Override
    public void doSaveSettings() throws CommonException {
        for (IPreferencesEditor prefAdapter : this.prefAdapters) {
            prefAdapter.doSaveSettings();
        }
    }

    public void addPrefElement(IPreferencesEditor prefElement) {
        this.prefAdapters.add((Object)prefElement);
    }

    public void bindToPreference(FieldWidget<String> field, CoreSettings.SettingsField<?> prefField) {
        this.bindToPreference((IProperty)field, (IGlobalPreference)prefField.getGlobalPreference());
        field.addFieldValidator(true, prefField.getValidator());
    }

    public <T> void bindToPreference(IProperty<T> field, IProjectPreference<T> pref) {
        this.bindToPreference(field, (IGlobalPreference<T>)pref.getGlobalPreference());
    }

    public <T> void bindToPreference(IProperty<T> field, IGlobalPreference<T> pref) {
        this.addPrefElement(this.getPreferencesBinder(field, pref));
    }

    public <T> IPreferencesEditor getPreferencesBinder(IProperty<T> field, IGlobalPreference<T> pref) {
        return new GlobalPreferenceAdapter<T>(pref, field);
    }

    public void bindToValidatedPreference(FieldWidget<String> field, DerivedValuePreference<?> derivedPref) {
        this.bindToPreference((IProperty)field, (IGlobalPreference)derivedPref.getPreference());
        field.addFieldValidator(true, derivedPref.getValidator());
    }

    public void bindToValidatedPreference(IField<String> field, DerivedValuePreference<?> derivedPref, ValidationField validation) {
        this.bindToPreference((IProperty)field, (IGlobalPreference)derivedPref.getPreference());
        validation.addFieldValidator(true, field, derivedPref.getValidator());
    }

    public class GlobalPreferenceAdapter<T>
    implements IPreferencesEditor {
        protected final IGlobalPreference<T> preference;
        protected final IProperty<T> property;

        public GlobalPreferenceAdapter(IGlobalPreference<T> preference, IProperty<T> property) {
            this.preference = (IGlobalPreference)Assert.AssertNamespace.assertNotNull(preference);
            this.property = (IProperty)Assert.AssertNamespace.assertNotNull(property);
            property.set(preference.asField().get());
        }

        @Override
        public void doSaveSettings() throws CommonException {
            this.preference.setInstanceScopeValue(this.property.get());
        }

        @Override
        public void loadDefaults() {
            this.property.set(this.preference.getDefaultValue());
        }
    }
}

