/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text;

import _org.eclipse.jdt.internal.ui.text.HTMLAnnotationHover;
import com.googlecode.goclipse.ui.editor.text.GoAutoEditStrategy;
import java.util.Map;
import melnorme.lang.ide.core.TextSettings_Actual;
import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.core.text.TextSourceUtils;
import melnorme.lang.ide.core.text.format.FormatterIndentMode;
import melnorme.lang.ide.ui.CodeFormatterConstants;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.LangUIPlugin_Actual;
import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.editor.ProjectionViewerExt;
import melnorme.lang.ide.ui.editor.hover.BestMatchHover;
import melnorme.lang.ide.ui.editor.hover.HoverInformationProvider;
import melnorme.lang.ide.ui.editor.structure.LangOutlineInformationControl;
import melnorme.lang.ide.ui.editor.structure.StructureElementInformationProvider;
import melnorme.lang.ide.ui.text.LangBasicSourceViewerConfiguration;
import melnorme.lang.ide.ui.text.completion.CompletionProposalsGrouping;
import melnorme.lang.ide.ui.text.completion.ContenAssistProcessorExt;
import melnorme.lang.ide.ui.text.completion.ContentAssistantExt;
import melnorme.lang.ide.ui.text.completion.LangContentAssistProcessor;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractLangSourceViewerConfiguration
extends LangBasicSourceViewerConfiguration {
    protected final ISourceBufferExt sourceBuffer;
    protected final ITextEditor editor_opt;

    public AbstractLangSourceViewerConfiguration(IPreferenceStore preferenceStore, ISourceBufferExt sourceBuffer, ITextEditor editor) {
        super(preferenceStore);
        this.sourceBuffer = (ISourceBufferExt)Assert.AssertNamespace.assertNotNull((Object)sourceBuffer);
        this.editor_opt = editor;
    }

    public ITextEditor getEditor_orNull() {
        return this.editor_opt;
    }

    public final ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return this.getBestMatchHover();
    }

    protected BestMatchHover getBestMatchHover() {
        return new BestMatchHover((ISourceBuffer)this.sourceBuffer, this.getEditor_orNull());
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(false){

            protected boolean isIncluded(Annotation annotation) {
                return AbstractLangSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return AbstractLangSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] stringArray = this.getConfiguredContentTypes(sourceViewer);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            presenter.setInformationProvider(this.getInformationProvider(contentType, sourceViewer), contentType);
            ++n2;
        }
        presenter.setSizeConstraints(100, 12, false, true);
        return presenter;
    }

    protected IInformationProvider getInformationProvider(String contentType, ISourceViewer sourceViewer) {
        return new HoverInformationProvider(this.getBestMatchHover());
    }

    protected IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        };
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put(EditorSettings_Actual.EDITOR_CODE_TARGET, this.editor_opt);
        return targets;
    }

    public void installOutlinePresenter(LangSourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        StructureElementInformationProvider provider = new StructureElementInformationProvider(this.sourceBuffer);
        String[] stringArray = this.getConfiguredContentTypes(sourceViewer);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            presenter.setInformationProvider((IInformationProvider)provider, contentType);
            ++n2;
        }
        presenter.setSizeConstraints(50, 20, true, false);
        presenter.install((ITextViewer)sourceViewer);
        sourceViewer.setOutlinePresenter((IInformationPresenter)presenter);
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer) {
        return new LangOutlineInformationControl.OutlineInformationControlCreator(this);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{this.getToggleCommentPrefix(), ""};
    }

    protected abstract String getToggleCommentPrefix();

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return (IAutoEditStrategy[])CoreUtil.array((Object[])new GoAutoEditStrategy[]{LangUIPlugin_Actual.createAutoEditStrategy(sourceViewer, contentType)});
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        FormatterIndentMode indentMode = CodeFormatterConstants.fromPrefStore();
        int spaceIndentationSize = (Integer)CodeFormatterConstants.FORMATTER_INDENTATION_SPACES_SIZE.get();
        String spaceIndent = TextSourceUtils.getNSpaces((int)spaceIndentationSize);
        switch (indentMode) {
            case TAB: {
                return (String[])CoreUtil.array((Object[])new String[]{"\t", spaceIndent, ""});
            }
            case SPACES: {
                return (String[])CoreUtil.array((Object[])new String[]{spaceIndent, "\t", ""});
            }
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    @Override
    protected void updateIndentationSettings(SourceViewer sourceViewer, String property) {
        super.updateIndentationSettings(sourceViewer, property);
        if (CodeFormatterConstants.FORMATTER_INDENTATION_SPACES_SIZE.key.equals(property) || CodeFormatterConstants.FORMATTER_INDENT_MODE.key.equals(property)) {
            String[] stringArray = this.getConfiguredContentTypes((ISourceViewer)sourceViewer);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                String[] prefixes = this.getIndentPrefixes((ISourceViewer)sourceViewer, contentType);
                sourceViewer.setIndentPrefixes(prefixes, contentType);
                ++n2;
            }
        }
    }

    public ContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (sourceViewer instanceof LangSourceViewer) {
            LangSourceViewer langSourceViewer = (LangSourceViewer)sourceViewer;
            ContentAssistantExt assistant = this.createContentAssitant(langSourceViewer);
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.setRestoreCompletionProposalSize(LangUIPlugin.getDialogSettings("completion_proposal_size"));
            assistant.setInformationControlCreator(this.getInformationControl_ContentAsssist(AbstractLangSourceViewerConfiguration.getAdditionalInfoAffordanceString()));
            assistant.setContextInformationPopupOrientation(20);
            assistant.enableColoredLabels(true);
            this.configureContentAssistantProcessors(assistant);
            assistant.configure();
            return assistant;
        }
        return null;
    }

    protected ContentAssistantExt createContentAssitant(LangSourceViewer langSourceViewer) {
        return new ContentAssistantExt(this.getPreferenceStore(), langSourceViewer);
    }

    protected void configureContentAssistantProcessors(ContentAssistantExt assistant) {
        ArrayList2<CompletionProposalsGrouping> categories = this.getContentAssistCategoriesProvider().getCategories();
        LangContentAssistProcessor defaultCAP = this.createContentAssistProcessor(assistant, (Indexable<CompletionProposalsGrouping>)categories);
        TextSettings_Actual.LangPartitionTypes[] langPartitionTypesArray = TextSettings_Actual.LangPartitionTypes.values();
        int n = langPartitionTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextSettings_Actual.LangPartitionTypes partitionType = langPartitionTypesArray[n2];
            ContenAssistProcessorExt cap = partitionType.getId().equals("__dftl_partition_content_type") ? defaultCAP : new ContenAssistProcessorExt.NullContentAssistProcessorExt();
            assistant.setContentAssistProcessor(cap, partitionType.getId());
            ++n2;
        }
    }

    protected LangContentAssistProcessor createContentAssistProcessor(ContentAssistantExt assistant, Indexable<CompletionProposalsGrouping> categories) {
        return new LangContentAssistProcessor(assistant, categories, this.sourceBuffer, this.getEditor_orNull());
    }

    protected abstract LangContentAssistProcessor.ContentAssistCategoriesBuilder getContentAssistCategoriesProvider();

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    @Override
    public void configureViewer(ProjectionViewerExt sourceViewer) {
        super.configureViewer(sourceViewer);
        if (sourceViewer instanceof LangSourceViewer) {
            LangSourceViewer langSourceViewer = (LangSourceViewer)sourceViewer;
            this.installOutlinePresenter(langSourceViewer);
        }
    }
}

