/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.coloring;

import melnorme.lang.ide.core.utils.prefs.PreferenceHelper;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.text.coloring.TextStyling;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.MiscUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class TextStylingPreference
extends PreferenceHelper<TextStyling> {
    protected static final Indexable<String> suffixes = CoreUtil.list((Object[])new String[]{"_bold", "_italic", "_strikethrough", "_underline", "_enabled"});

    public TextStylingPreference(String key, TextStyling styling) {
        this(LangUIPlugin.PLUGIN_ID, key, styling);
    }

    public TextStylingPreference(String qualifer, String key, TextStyling defaultValue) {
        super(qualifer, key, (Object)defaultValue);
    }

    protected TextStyling getPrefValue(PreferenceHelper.IPreferencesAccess prefsAccess) {
        return TextStylingPreference.getFromStore(prefsAccess, this.key);
    }

    protected void setPrefValue(IEclipsePreferences preferences, TextStyling value) {
        TextStylingPreference.setToStore(preferences, this.key, value);
    }

    protected TextStyling parseString(String stringValue) {
        throw Assert.AssertNamespace.assertFail();
    }

    protected String valueToString(TextStyling value) {
        throw Assert.AssertNamespace.assertFail();
    }

    public static void setToStore(IEclipsePreferences store, String key, TextStyling textStyle) {
        store.putBoolean(TextStylingPreference.getEnabledKey(key), textStyle.isEnabled);
        store.put(TextStylingPreference.getColorKey(key), StringConverter.asString((RGB)textStyle.rgb));
        store.putBoolean(TextStylingPreference.getBoldKey(key), textStyle.isBold);
        store.putBoolean(TextStylingPreference.getItalicKey(key), textStyle.isItalic);
        store.putBoolean(TextStylingPreference.getStrikethroughKey(key), textStyle.isStrikethrough);
        store.putBoolean(TextStylingPreference.getUnderlineKey(key), textStyle.isUnderline);
    }

    public static TextStyling getFromStore(PreferenceHelper.IPreferencesAccess prefsHelper, String colorKey) {
        RGB rgb = TextStylingPreference.getRgb(prefsHelper, TextStylingPreference.getColorKey(colorKey));
        boolean isEnabled = TextStylingPreference.getBoolean(prefsHelper, TextStylingPreference.getEnabledKey(colorKey));
        boolean isBold = TextStylingPreference.getBoolean(prefsHelper, TextStylingPreference.getBoldKey(colorKey));
        boolean isItalic = TextStylingPreference.getBoolean(prefsHelper, TextStylingPreference.getItalicKey(colorKey));
        boolean isStrikethrough = TextStylingPreference.getBoolean(prefsHelper, TextStylingPreference.getStrikethroughKey(colorKey));
        boolean isUnderline = TextStylingPreference.getBoolean(prefsHelper, TextStylingPreference.getUnderlineKey(colorKey));
        return new TextStyling(isEnabled, rgb, isBold, isItalic, isStrikethrough, isUnderline);
    }

    protected static boolean getBoolean(PreferenceHelper.IPreferencesAccess prefsHelper, String key) {
        return MiscUtil.parseBoolean((String)prefsHelper.getString(key));
    }

    public static String getColorKey(String key) {
        return String.valueOf(key);
    }

    public static String getEnabledKey(String key) {
        return String.valueOf(key) + "_enabled";
    }

    public static String getBoldKey(String key) {
        return String.valueOf(key) + "_bold";
    }

    public static String getItalicKey(String key) {
        return String.valueOf(key) + "_italic";
    }

    public static String getStrikethroughKey(String key) {
        return String.valueOf(key) + "_strikethrough";
    }

    public static String getUnderlineKey(String key) {
        return String.valueOf(key) + "_underline";
    }

    public static RGB getRgb(PreferenceHelper.IPreferencesAccess prefsHelper, String key) {
        return StringConverter.asRGB((String)prefsHelper.getString(key), (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
    }

    protected void handlePreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String suffix;
        String baseKey;
        String changedKey = event.getKey();
        if (changedKey.startsWith(baseKey = this.key) && ((suffix = changedKey.substring(baseKey.length())).isEmpty() || suffixes.contains((Object)suffix))) {
            this.field.setFieldValue((Object)((TextStyling)this.get()));
        }
    }
}

