/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.coloring;

import melnorme.lang.ide.core.utils.prefs.IPreferenceIdentifier;
import melnorme.lang.ide.ui.LangUI;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.ThemeHelper;
import melnorme.lang.ide.ui.text.coloring.TextStyling;
import melnorme.lang.ide.ui.text.coloring.TextStylingPreference;
import melnorme.util.swt.SWTUtil;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.Field;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IField;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;

public class ThemedTextStylingPreference
implements IFieldView<TextStyling>,
IPreferenceIdentifier {
    protected final String key;
    protected final String key_Dark;
    protected final TextStylingPreference defaultPref;
    protected final TextStylingPreference darkPref;
    protected final Field<TextStyling> effectiveValue = new Field();

    public ThemedTextStylingPreference(String key, TextStyling defaultValue, TextStyling defaultValueDark) {
        this(LangUIPlugin.PLUGIN_ID, key, defaultValue, defaultValueDark);
    }

    public ThemedTextStylingPreference(String qualifer, String key, TextStyling defaultValue, TextStyling defaultValueDark) {
        this.key = key;
        this.key_Dark = String.valueOf(key) + "#dark#";
        this.defaultPref = new TextStylingPreference(qualifer, key, defaultValue);
        this.darkPref = new TextStylingPreference(qualifer, this.key_Dark, defaultValueDark);
        this.defaultPref.asField().registerListener(__ -> this.updateEffectiveValue());
        this.darkPref.asField().registerListener(__ -> this.updateEffectiveValue());
        LangUI.getInstance().getThemeHelper().asOwner().bind((IDisposable)new ThemeHelper.ThemeChangeListener(){

            public void handleEvent(Event event) {
                ThemedTextStylingPreference.this.updateEffectiveValue();
            }
        });
        this.effectiveValue.setFieldValue((Object)((TextStyling)this.defaultPref.getFromPrefStore()));
        this.updateEffectiveValue();
    }

    public TextStylingPreference getDefaultThemePref() {
        return this.defaultPref;
    }

    public TextStylingPreference getDarkPref() {
        return this.darkPref;
    }

    protected void updateEffectiveValue() {
        SWTUtil.runInSWTThread(() -> this.effectiveValue.setFieldValue((Object)((TextStyling)this.getEffectivePreference().getFromPrefStore())));
    }

    protected TextStyling getEffectiveValue() {
        Assert.AssertNamespace.assertTrue((this.getEffectivePreference().get() == this.effectiveValue.get() ? 1 : 0) != 0);
        return (TextStyling)this.effectiveValue.get();
    }

    protected TextStylingPreference getEffectivePreference() {
        if (this.isOverridingThemeActive()) {
            return this.darkPref;
        }
        return this.defaultPref;
    }

    protected boolean isOverridingThemeActive() {
        Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        return LangUI.getInstance().getThemeHelper().getIdOfActiveThemeForCurrentDisplay().contains("dark");
    }

    public TextStyling getDefaultValue() {
        return (TextStyling)this.getEffectivePreference().getDefaultValue();
    }

    public String getActiveKey() {
        if (this.isOverridingThemeActive()) {
            return this.key_Dark;
        }
        return this.key;
    }

    public void setInstanceScopeValue(TextStyling value) throws CommonException {
        this.getEffectivePreference().setInstanceScopeValue(value);
    }

    public IField<TextStyling> asField() {
        return this.effectiveValue;
    }

    public TextStyling getFieldValue() {
        return (TextStyling)this.asField().getFieldValue();
    }

    public void addListener(FieldValueListener<? super TextStyling> listener) {
        this.asField().addListener(listener);
    }

    public void removeListener(FieldValueListener<? super TextStyling> listener) {
        this.asField().removeListener(listener);
    }

    public String getPrefId() {
        return this.key;
    }
}

