/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.coloring;

import melnorme.lang.ide.ui.text.coloring.StylingPreferences;
import melnorme.lang.ide.ui.text.coloring.TextStyling;
import melnorme.lang.ide.ui.text.coloring.ThemedTextStylingPreference;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.jface.text.ColorManager2;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.ownership.IOwner;
import melnorme.utilbox.ownership.LifecycleObject;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TokenRegistry
extends LifecycleObject {
    protected final HashMap2<String, Token> tokens = new HashMap2();
    protected final ColorManager2 colorManager;
    protected final StylingPreferences stylingPrefs;

    public TokenRegistry(ColorManager2 colorManager, StylingPreferences stylingPrefs) {
        this.colorManager = (ColorManager2)Assert.AssertNamespace.assertNotNull((Object)colorManager);
        this.stylingPrefs = (StylingPreferences)Assert.AssertNamespace.assertNotNull((Object)stylingPrefs);
    }

    public IToken getToken(ThemedTextStylingPreference stylingPref) {
        return this.doGetToken(stylingPref.getPrefId(), this.stylingPrefs.get(stylingPref));
    }

    protected Token doGetToken(String id, IFieldView<TextStyling> stylingPref) {
        Assert.AssertNamespace.assertNotNull((Object)id);
        Assert.AssertNamespace.assertNotNull(stylingPref);
        Assert.AssertNamespace.assertTrue((boolean)SWTUtil.isUIThread());
        Token token = (Token)this.tokens.get((Object)id);
        if (token == null) {
            Token newToken = new Token((Object)this.createTextAttribute(stylingPref));
            stylingPref.bindOwnedListener((IOwner)this.owned, __ -> this.updateToken(newToken, stylingPref));
            this.tokens.put((Object)id, (Object)newToken);
            token = newToken;
        }
        return token;
    }

    protected TextAttribute createTextAttribute(IFieldView<TextStyling> stylingPref) {
        TextStyling textStyle = (TextStyling)stylingPref.get();
        return textStyle.getTextAttribute(this.colorManager);
    }

    protected void updateToken(Token token, IFieldView<TextStyling> stylingPref) {
        token.setData((Object)this.createTextAttribute(stylingPref));
        this.handleTokenModified(token);
    }

    protected void handleTokenModified(Token token) {
    }
}

