/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.completion;

import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.ui.text.completion.ILangCompletionProposalComputer;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class CompletionProposalsGrouping {
    protected final String id;
    protected final String name;
    protected final ImageDescriptor image;
    protected final Indexable<ILangCompletionProposalComputer> computers;
    protected String lastErrorMessage = null;

    public CompletionProposalsGrouping(String id, String name, ImageDescriptor image, ArrayList2<ILangCompletionProposalComputer> computers) {
        this.id = id;
        this.name = name;
        this.image = image;
        this.computers = computers;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Indexable<ILangCompletionProposalComputer> getComputers() {
        return this.computers;
    }

    public String getErrorMessage() {
        return this.lastErrorMessage;
    }

    protected void clearErrorMessage() {
        this.lastErrorMessage = null;
    }

    protected void updateErrorMessage(String errorMessage) {
        if (this.lastErrorMessage == null) {
            this.lastErrorMessage = errorMessage;
        }
    }

    public void sessionStarted() {
        this.clearErrorMessage();
        for (ILangCompletionProposalComputer computer : this.computers) {
            computer.sessionStarted();
        }
    }

    public void sessionEnded() {
        this.clearErrorMessage();
        for (ILangCompletionProposalComputer computer : this.computers) {
            computer.sessionEnded();
        }
    }

    public Indexable<ICompletionProposal> computeCompletionProposals(ISourceBufferExt sourceBuffer, ITextViewer viewer, int offset) throws CommonException, OperationCancellation, OperationSoftFailure {
        this.clearErrorMessage();
        ArrayList2 proposals = new ArrayList2();
        for (ILangCompletionProposalComputer computer : this.computers) {
            Indexable<ICompletionProposal> computerProposals = computer.computeCompletionProposals(sourceBuffer, viewer, offset);
            if (computerProposals == null) continue;
            proposals.addAll2(computerProposals);
        }
        return proposals;
    }

    public Indexable<IContextInformation> computeContextInformation(ISourceBufferExt sourceBuffer, ITextViewer viewer, int offset) {
        this.clearErrorMessage();
        ArrayList2 proposals = new ArrayList2();
        for (ILangCompletionProposalComputer computer : this.computers) {
            try {
                Indexable<IContextInformation> computerProposals = computer.computeContextInformation(sourceBuffer, viewer, offset);
                if (computerProposals == null) continue;
                proposals.addAll2(computerProposals);
            }
            catch (OperationSoftFailure e) {
                this.updateErrorMessage(e.getMessage());
            }
        }
        return proposals;
    }
}

