/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.completion;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.text.TextSourceUtils;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.editor.EditorSourceBuffer;
import melnorme.lang.ide.ui.editor.ISourceViewerExt;
import melnorme.lang.ide.ui.editor.hover.BrowserControlCreator;
import melnorme.lang.ide.ui.text.DocDisplayInfoSupplier;
import melnorme.lang.ide.ui.text.completion.ContentAssistantExt;
import melnorme.lang.tooling.ToolCompletionProposal;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LangCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    protected final SourceOpContext sourceOpContext;
    protected final ToolCompletionProposal proposal;
    protected volatile String additionalProposalInfo;
    protected final Image image;
    protected final IContextInformation contextInformation;
    protected int relevance = 0;
    protected int replaceLength;
    protected StyledString styledDisplayString;
    protected ContentAssistantExt caext;
    protected IInformationControlCreator informationControlCreator;
    protected final Object additionalProposalInfo_mutex = new Object();
    protected int endPositionAfterApply;
    protected Point positionAfterApply;
    protected int firstLinkedModeGroupPosition;

    public LangCompletionProposal(SourceOpContext sourceOpContext, ToolCompletionProposal proposal, Image image, IContextInformation contextInformation) {
        this.sourceOpContext = (SourceOpContext)Assert.AssertNamespace.assertNotNull((Object)sourceOpContext);
        this.proposal = (ToolCompletionProposal)Assert.AssertNamespace.assertNotNull((Object)proposal);
        this.additionalProposalInfo = proposal.getDocumentation();
        this.image = image;
        this.contextInformation = contextInformation;
        this.relevance = this.getDefaultRelevance();
        this.replaceLength = proposal.getReplaceLength();
    }

    protected int getReplaceOffset() {
        return this.proposal.getReplaceOffset();
    }

    protected int getReplaceLength() {
        return this.replaceLength;
    }

    public String getBaseReplaceString() {
        return this.proposal.getBaseReplaceString();
    }

    public String getEffectiveReplaceString(boolean nameOnly) {
        if (nameOnly) {
            return this.proposal.getBaseReplaceString();
        }
        return this.proposal.getFullReplaceString();
    }

    public int getRelevance() {
        return this.relevance;
    }

    protected int getDefaultRelevance() {
        String underlyingElementName = this.getUnderlyingElementName();
        if (underlyingElementName != null && underlyingElementName.startsWith("_")) {
            return 10;
        }
        return 0;
    }

    protected String getUnderlyingElementName() {
        return this.proposal.getLabel();
    }

    public String getSortString() {
        return this.proposal.getLabel();
    }

    public String getDisplayString() {
        return this.proposal.getLabel();
    }

    public StyledString getStyledDisplayString() {
        if (this.styledDisplayString == null) {
            StyledString styledString = new StyledString(this.proposal.getLabel());
            this.getStyledDisplayString_TypeLabel(styledString);
            this.getStyledDisplayString_ModuleName(styledString);
            this.styledDisplayString = styledString;
        }
        return this.styledDisplayString;
    }

    protected void getStyledDisplayString_TypeLabel(StyledString styledString) {
        if (this.proposal.getTypeLabel() != null) {
            styledString.append(new StyledString(" " + this.proposal.getTypeLabel(), StyledString.DECORATIONS_STYLER));
        }
    }

    protected void getStyledDisplayString_ModuleName(StyledString styledString) {
        if (this.proposal.getModuleName() != null) {
            styledString.append(new StyledString(" - " + this.proposal.getModuleName(), StyledString.QUALIFIER_STYLER));
        }
    }

    public Image getImage() {
        return this.image;
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public int getContextInformationPosition() {
        return -1;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        ISourceViewerExt sourceViewer;
        IContentAssistant ca;
        if (viewer instanceof ISourceViewerExt && (ca = (sourceViewer = (ISourceViewerExt)viewer).getContentAssistant()) instanceof ContentAssistantExt) {
            this.caext = (ContentAssistantExt)ca;
            if (!this.isAutoInsertable()) {
                this.caext.setAdditionalStatusMessage("Press 'Ctrl+Enter' for name-only insertion;");
            } else {
                this.caext.setAdditionalStatusMessage(null);
                this.caext = null;
            }
        }
    }

    public void unselected(ITextViewer viewer) {
        if (this.caext != null) {
            this.caext.setAdditionalStatusMessage(null);
        }
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.informationControlCreator == null) {
            this.informationControlCreator = new BrowserControlCreator();
        }
        return this.informationControlCreator;
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return info != null ? info.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        Object object = this.additionalProposalInfo_mutex;
        synchronized (object) {
            if (this.additionalProposalInfo == null) {
                this.additionalProposalInfo = this.doGetAdditionalProposalInfo(monitor);
            }
        }
        return this.additionalProposalInfo;
    }

    protected String doGetAdditionalProposalInfo(IProgressMonitor monitor) {
        Document tempDocument = new Document(this.sourceOpContext.getSource());
        this.doApply((IDocument)tempDocument, false);
        try {
            tempDocument.replace(this.endPositionAfterApply, 0, " ");
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        EditorSourceBuffer.DocumentSourceBuffer tempSourceBuffer = new EditorSourceBuffer.DocumentSourceBuffer((IDocument)tempDocument){

            @Override
            public Location getLocation_orNull() {
                return LangCompletionProposal.this.sourceOpContext.getOptionalFileLocation().orElse(null);
            }
        };
        String doc = new DocDisplayInfoSupplier((ISourceBuffer)tempSourceBuffer, this.getReplaceOffset()).doGetDocumentation(EclipseUtils.om((IProgressMonitor)monitor));
        if (doc == null) {
            return null;
        }
        return BrowserControlCreator.wrapHTMLBody(doc);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String prefix;
        if (offset < this.getReplaceOffset()) {
            return false;
        }
        try {
            prefix = document.get(this.getReplaceOffset(), offset - this.getReplaceOffset());
        }
        catch (BadLocationException e) {
            return false;
        }
        boolean validPrefix = this.isValidPrefix(prefix);
        if (validPrefix && event != null) {
            int eventEndOffset = event.fOffset + event.fLength;
            int replaceEndPos = this.getReplaceOffset() + this.getReplaceLength();
            if (event.fOffset >= this.getReplaceOffset() && eventEndOffset <= replaceEndPos) {
                int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
                this.replaceLength = Math.max(this.getReplaceLength() + delta, 0);
            }
        }
        return validPrefix;
    }

    protected boolean isValidPrefix(String prefix) {
        String rplString = this.getBaseReplaceString();
        return TextSourceUtils.isPrefix((String)prefix, (String)rplString, (boolean)true);
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getBaseReplaceString();
    }

    public boolean isAutoInsertable() {
        return this.proposal.getBaseReplaceString().equals(this.proposal.getFullReplaceString());
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0);
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.doApply(document, false);
    }

    public void doApply(IDocument document, boolean nameOnly) {
        int replaceOffset = this.getReplaceOffset();
        String effectiveReplaceString = this.getEffectiveReplaceString(nameOnly);
        int replaceLength = this.getReplaceLength();
        this.endPositionAfterApply = replaceOffset + effectiveReplaceString.length();
        this.positionAfterApply = new Point(this.endPositionAfterApply, 0);
        try {
            document.replace(replaceOffset, replaceLength, effectiveReplaceString);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        return this.positionAfterApply;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        boolean nameOnly = false;
        if ((stateMask & 0x40000) != 0) {
            nameOnly = true;
        }
        this.doApply(viewer.getDocument(), nameOnly);
        if (nameOnly) {
            return;
        }
        try {
            this.applyLinkedMode(viewer);
        }
        catch (BadLocationException e) {
            LangCore.logInternalError((Throwable)e);
        }
    }

    protected void applyLinkedMode(ITextViewer viewer) throws BadLocationException {
        LinkedModeModel model = this.getLinkedModeModel(viewer);
        if (model == null) {
            return;
        }
        model.forceInstall();
        EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)new CompletionProposalExitPolicy());
        ui.setExitPosition(viewer, this.endPositionAfterApply, 0, Integer.MAX_VALUE);
        if (this.firstLinkedModeGroupPosition != -1) {
            this.positionAfterApply = null;
        }
        ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
        ui.setDoContextInfo(true);
        ui.enableColoredLabels(true);
        ui.enter();
    }

    protected LinkedModeModel getLinkedModeModel(ITextViewer viewer) throws BadLocationException {
        Indexable sourceSubElements = this.proposal.getSourceSubElements();
        if (sourceSubElements == null || sourceSubElements.isEmpty()) {
            return null;
        }
        LinkedModeModel model = new LinkedModeModel();
        IDocument document = viewer.getDocument();
        int replaceOffset = this.getReplaceOffset();
        this.firstLinkedModeGroupPosition = -1;
        for (SourceRange sr : sourceSubElements) {
            LinkedPositionGroup group = new LinkedPositionGroup();
            int posOffset = replaceOffset + sr.getOffset();
            group.addPosition(new LinkedPosition(document, posOffset, sr.getLength()));
            if (this.firstLinkedModeGroupPosition == -1) {
                this.firstLinkedModeGroupPosition = posOffset;
            }
            model.addGroup(group);
        }
        return model;
    }

    public String toString() {
        return this.proposal.toString();
    }

    protected class CompletionProposalExitPolicy
    implements LinkedModeUI.IExitPolicy {
        protected CompletionProposalExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            switch (event.character) {
                case '\r': {
                    int endOfReplacement = LangCompletionProposal.this.getReplaceOffset() + LangCompletionProposal.this.getEffectiveReplaceString(false).length();
                    if (offset == endOfReplacement) {
                        return new LinkedModeUI.ExitFlags(1, true);
                    }
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }
    }
}

