/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.tools.console;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import melnorme.lang.ide.core.ILangOperationsListener;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.utils.process.AbstractRunProcessTask;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.tools.console.ConsoleOutputProcessListener;
import melnorme.lang.ide.ui.tools.console.EngineToolsConsole;
import melnorme.lang.ide.ui.tools.console.ToolsConsole;
import melnorme.lang.ide.ui.tools.console.ToolsConsolePrefs;
import melnorme.lang.ide.ui.utils.ConsoleUtils;
import melnorme.lang.ide.ui.utils.StatusMessageDialog;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.util.swt.SWTUtil;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.process.ExternalProcessNotifyingHelper;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsoleOutputStream;

public abstract class LangOperationsConsoleUIHandler
implements ILangOperationsListener {
    protected final Set<String> mutedMessages = Collections.synchronizedSet(new HashSet());

    public void notifyMessage(final String msgId, final StatusLevel statusLevel, final String title, final String message) {
        SWTUtil.runInSWTThread(new Runnable(){

            @Override
            public void run() {
                if (msgId != null && LangOperationsConsoleUIHandler.this.mutedMessages.contains(msgId)) {
                    return;
                }
                Shell shell = WorkbenchUtils.getActiveWorkbenchShell();
                StatusMessageDialog dialog = new StatusMessageDialog(shell, title, statusLevel, message){

                    @Override
                    protected void setIgnoreFutureMessages() {
                        if (msgId != null) {
                            (this).LangOperationsConsoleUIHandler.this.mutedMessages.add(msgId);
                        }
                    }
                };
                if (UIOperationsStatusHandler.isIgnoringHandling()) {
                    Display.getCurrent().asyncExec(() -> dialog.okPressed());
                }
                dialog.open();
            }
        });
    }

    protected String getBuildConsoleName(IProject project) {
        return "Go Build";
    }

    protected ToolsConsole createBuildConsole(String name) {
        return new ToolsConsole(name, LangImages.BUILD_CONSOLE_ICON.getDescriptor());
    }

    protected ToolsConsole getBuildConsole(IProject project, boolean clearConsole) {
        String operationConsoleName = this.getBuildConsoleName(project);
        return ConsoleUtils.getOrCreateToolsConsole(operationConsoleName, clearConsole, ToolsConsole.class, () -> this.createBuildConsole(operationConsoleName));
    }

    public ILangOperationsListener_Default.IToolOperationMonitor beginOperation(ILangOperationsListener_Default.ProcessStartKind kind, boolean clearConsole, boolean activateConsole) {
        ILangOperationsListener_Default.IToolOperationMonitor opHandler = this.doBeginOperation(kind, clearConsole);
        if (activateConsole) {
            opHandler.activate();
        }
        return opHandler;
    }

    protected ILangOperationsListener_Default.IToolOperationMonitor doBeginOperation(ILangOperationsListener_Default.ProcessStartKind kind, boolean clearConsole) {
        switch (kind) {
            case BUILD: {
                ToolsConsole console = this.getBuildConsole(null, clearConsole);
                return this.createConsoleHandler(kind, console, console.stdOut, console.stdErr);
            }
            case CHECK_BUILD: {
                ToolsConsole console = this.getBuildConsole(null, clearConsole);
                return this.createConsoleHandler(kind, console, console.stdOut, console.stdErr_silent);
            }
            case ENGINE_SERVER: {
                EngineToolsConsole console = EngineToolsConsole.getConsole(clearConsole);
                return this.createConsoleHandler(kind, console, console.serverStdOut, console.serverStdErr);
            }
            case ENGINE_TOOLS: {
                EngineToolsConsole console = EngineToolsConsole.getConsole(clearConsole);
                return this.createConsoleHandler(kind, console, console.stdOut, console.stdErr);
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    protected OperationConsoleMonitor createConsoleHandler(ILangOperationsListener_Default.ProcessStartKind kind, ToolsConsole console, IOConsoleOutputStream stdOut, IOConsoleOutputStream stdErr) {
        return new OperationConsoleMonitor(kind, console, stdOut, stdErr);
    }

    protected String getPrefaceText(String prefixText, ProcessBuilder pb) {
        List<String> commandLine = pb.command();
        prefixText = prefixText == null ? ">> Running: " : prefixText;
        String argsLabel = DebugPlugin.renderArguments((String[])((String[])ArrayUtil.createFrom(commandLine, String.class)), null);
        String infoPrefaceText = String.valueOf(prefixText) + argsLabel + "\n";
        return infoPrefaceText;
    }

    protected String getProcessTerminatedMessage(int exitCode) {
        return "  ^^^ Terminated, exit code: " + exitCode + " ^^^\n";
    }

    public class OperationConsoleMonitor
    implements ILangOperationsListener_Default.IToolOperationMonitor {
        protected final ILangOperationsListener_Default.ProcessStartKind kind;
        protected final ToolsConsole console;
        protected final IOConsoleOutputStream infoOut;
        protected final IOConsoleOutputStream stdOut;
        protected final IOConsoleOutputStream stdErr;
        public boolean errorOnNonZeroExitValueForBuild = false;

        public OperationConsoleMonitor(ILangOperationsListener_Default.ProcessStartKind kind, ToolsConsole console, IOConsoleOutputStream stdOut, IOConsoleOutputStream stdErr) {
            this.kind = (ILangOperationsListener_Default.ProcessStartKind)Assert.AssertNamespace.assertNotNull((Object)kind);
            this.console = (ToolsConsole)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)console)));
            this.infoOut = console.infoOut;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }

        public void writeInfoMessage(String operationMessage) {
            this.console.writeOperationInfo(operationMessage);
        }

        public void handleProcessStart(String prefixText, ProcessBuilder pb, AbstractRunProcessTask.ProcessStartHelper processStartHelper) {
            String infoPrefaceText = LangOperationsConsoleUIHandler.this.getPrefaceText(prefixText, pb);
            try {
                if (infoPrefaceText != null) {
                    this.infoOut.write(infoPrefaceText);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connectProcessOutputListener(processStartHelper);
        }

        protected void connectProcessOutputListener(AbstractRunProcessTask.ProcessStartHelper processStartHelper) {
            try {
                processStartHelper.addProcessListener(this.createOutputListener());
            }
            catch (CommonException ce) {
                String text = "  FAILED: " + ce.getMessage();
                Throwable cause = ce.getCause();
                if (cause != null) {
                    text = String.valueOf(text) + "   Reason: " + cause.getMessage() + "\n";
                }
                try {
                    this.infoOut.write(text);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected ExternalProcessNotifyingHelper.IProcessOutputListener createOutputListener() {
            return new ConsoleOutputProcessListener(this.stdOut, this.stdErr){

                @Override
                public void notifyProcessTerminatedAndRead(int exitCode) {
                    super.notifyProcessTerminatedAndRead(exitCode);
                    OperationConsoleMonitor.this.handleProcessTerminated(exitCode);
                }
            };
        }

        protected void handleProcessTerminated(int exitCode) {
            boolean activateOnErrors;
            boolean bl = activateOnErrors = this.kind == ILangOperationsListener_Default.ProcessStartKind.BUILD && (Boolean)ToolsConsolePrefs.ACTIVATE_ON_ERROR_MESSAGES.get() != false;
            if (this.errorOnNonZeroExitValueForBuild && exitCode != 0 && activateOnErrors) {
                this.console.activate();
            }
            try {
                this.infoOut.write(LangOperationsConsoleUIHandler.this.getProcessTerminatedMessage(exitCode));
                this.infoOut.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void activate() {
            this.console.activate();
            Display.getDefault().asyncExec(() -> this.console.activate());
        }
    }
}

