/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.tools.console;

import java.io.IOException;
import melnorme.lang.ide.ui.text.coloring.TextStyling;
import melnorme.lang.ide.ui.tools.console.AbstractProcessMessageConsole;
import melnorme.lang.ide.ui.tools.console.ToolsConsolePage;
import melnorme.lang.ide.ui.tools.console.ToolsConsolePrefs;
import melnorme.util.swt.jface.text.ColorManager;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.ownership.IOwner;
import melnorme.utilbox.ownership.OwnedObjects;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ToolsConsole
extends AbstractProcessMessageConsole {
    public final IOConsoleOutputStream infoOut;
    public final IOConsoleOutputStream stdErr_silent;
    protected final OwnedObjects owned = new OwnedObjects();

    public ToolsConsole(String name, ImageDescriptor imageDescriptor) {
        this(name, imageDescriptor, true);
    }

    protected ToolsConsole(String name, ImageDescriptor imageDescriptor, boolean initializeColors) {
        super(name, imageDescriptor);
        this.infoOut = this.newOutputStream();
        this.stdErr_silent = this.newOutputStream();
        if (initializeColors) {
            this.postToUI_initOutputStreamColors();
        }
    }

    @Override
    protected void ui_initStreamColors() {
        super.ui_initStreamColors();
        this.ui_bindActivateOnErrorsListeners();
        ToolsConsolePrefs.INFO_COLOR.asField().bindOwnedListener((IOwner)this.owned, true, newValue -> this.infoOut.setColor(ToolsConsole.getManagedColor(newValue)));
        ToolsConsolePrefs.STDERR_COLOR.asField().bindOwnedListener((IOwner)this.owned, true, newValue -> {
            this.stdErr.setColor(ToolsConsole.getManagedColor(newValue));
            this.stdErr_silent.setColor(ToolsConsole.getManagedColor(newValue));
        });
        ToolsConsolePrefs.STDOUT_COLOR.asField().bindOwnedListener((IOwner)this.owned, true, newValue -> this.stdOut.setColor(ToolsConsole.getManagedColor(newValue)));
        ToolsConsolePrefs.BACKGROUND_COLOR.asField().bindOwnedListener((IOwner)this.owned, true, newValue -> this.setBackground(ToolsConsole.getManagedColor(newValue)));
    }

    protected void ui_bindActivateOnErrorsListeners() {
        ToolsConsolePrefs.ACTIVATE_ON_ERROR_MESSAGES.asField().bindOwnedListener((IOwner)this.owned, true, newValue -> this.stdErr.setActivateOnWrite(newValue.booleanValue()));
    }

    protected static Color getManagedColor(TextStyling textStyling) {
        return ColorManager.getDefault().getColor(textStyling.rgb);
    }

    @Override
    protected void disposeDo() {
        Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        this.owned.dispose();
        super.disposeDo();
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new ToolsConsolePage((TextConsole)this, view);
    }

    public void writeOperationInfo(String string) {
        try {
            this.infoOut.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

