/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.fntypes.SimpleGetter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class ConsoleUtils {
    public static MessageConsole findOrCreateMessageConsole(String name) {
        MessageConsole console = ConsoleUtils.findConsole(name, MessageConsole.class);
        if (console != null) {
            return console;
        }
        MessageConsole msgConsole = new MessageConsole(name, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{msgConsole});
        return msgConsole;
    }

    public static <T extends IConsole> T findConsole(String name, Class<T> klass) {
        IConsole[] existing;
        IConsoleManager consoleMgr = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = existing = consoleMgr.getConsoles();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (name.equals(console.getName()) && klass.isAssignableFrom(console.getClass())) {
                return (T)((IConsole)klass.cast(console));
            }
            ++n2;
        }
        return null;
    }

    public static MessageConsole recreateMessageConsole(String name, ImageDescriptor imageDescriptor) {
        MessageConsole console = ConsoleUtils.findConsole(name, MessageConsole.class);
        if (console != null) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles((IConsole[])CoreUtil.array((Object[])new MessageConsole[]{console}));
        }
        MessageConsole msgConsole = new MessageConsole(name, imageDescriptor);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles((IConsole[])CoreUtil.array((Object[])new MessageConsole[]{msgConsole}));
        return msgConsole;
    }

    public static <T extends IConsole> T getOrCreateToolsConsole(String name, boolean clearConsole, Class<T> klass, SimpleGetter<T> consoleCreator) {
        Object console = ConsoleUtils.findConsole(name, klass);
        if (console != null) {
            if (clearConsole) {
                ConsolePlugin.getDefault().getConsoleManager().removeConsoles((IConsole[])CoreUtil.array((Object[])new IConsole[]{console}));
                console = null;
            } else {
                return console;
            }
        }
        console = (IConsole)consoleCreator.get();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles((IConsole[])CoreUtil.array((Object[])new IConsole[]{console}));
        return console;
    }
}

