/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import java.util.function.Consumer;
import melnorme.lang.ide.ui.LangUIMessages;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ControlUtils {
    public static void createHorizontalSpacer(Composite topControl, int charHeight, PixelConverter pc) {
        SWTFactoryUtil.createLabel(topControl, 16384, "", GridDataFactory.fillDefaults().hint(pc.convertHeightInCharsToPixels(charHeight), -1).create());
    }

    public static String openFileDialog(String initialValue, Shell shell) throws OperationCancellation {
        String result;
        FileDialog dialog = new FileDialog(shell);
        if (!initialValue.isEmpty()) {
            dialog.setFilterPath(initialValue);
        }
        if ((result = dialog.open()) == null) {
            throw new OperationCancellation();
        }
        return result;
    }

    public static Link createOpenPreferencesDialogLinkedText(Composite topControl, String linkText) {
        return ControlUtils.createOpenPreferencesDialogLinkedText(topControl, linkText, null);
    }

    public static Link createOpenPreferencesDialogLinkedText(final Composite topControl, String linkText, final Consumer<Link> afterDialogOpen) {
        final Link link = new Link(topControl, 0);
        link.setText(linkText);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)topControl.getShell(), (String)e.text, null, null).open();
                if (afterDialogOpen != null) {
                    afterDialogOpen.accept(link);
                }
            }
        });
        return link;
    }

    public static Link createOpenPreferencesDialogLink(Composite topControl, String prefPageId, String linkLabel, Consumer<Link> afterDialogOpen) {
        return ControlUtils.createOpenPreferencesDialogLinkedText(topControl, "<a href=\"" + prefPageId + "\">" + linkLabel + "</a>", afterDialogOpen);
    }

    public static void openStringVariableSelectionDialog_ForText(Text text) {
        Shell shell = text.getShell();
        try {
            String variable = ControlUtils.openStringVariableSelectionDialog(shell);
            text.insert(variable);
        }
        catch (OperationCancellation e) {
            return;
        }
    }

    public static String openStringVariableSelectionDialog(Shell shell) throws OperationCancellation {
        return ControlUtils.openStringVariableSelectionDialog(new StringVariableSelectionDialog(shell));
    }

    public static String openStringVariableSelectionDialog(StringVariableSelectionDialog dialog) throws OperationCancellation {
        dialog.open();
        String result = dialog.getVariableExpression();
        if (result == null) {
            throw new OperationCancellation();
        }
        return result;
    }

    public static String openProgramPathDialog(IProject project, Button button) throws OperationCancellation {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(button.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(LangUIMessages.ProgramPathDialog_title);
        dialog.setMessage(LangUIMessages.ProgramPathDialog_message);
        dialog.setInput((Object)project);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            return resource.getProjectRelativePath().toPortableString();
        }
        throw new OperationCancellation();
    }

    public static <T> T setElementsAndOpenDialog(ElementListSelectionDialog elementListDialog, Indexable<T> configs) throws OperationCancellation {
        return ControlUtils.setElementsAndOpenDialog(elementListDialog, configs.toArray());
    }

    public static <T> T setElementsAndOpenDialog(ElementListSelectionDialog elementListDialog, Object[] elements) throws OperationCancellation {
        elementListDialog.setElements(elements);
        int result = elementListDialog.open();
        if (result != 0) {
            throw new OperationCancellation();
        }
        return (T)elementListDialog.getFirstResult();
    }
}

