/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.lang.ide.ui.utils.StatusMessageDialog2;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.utilbox.fields.validation.IDetailsMessage;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.status.StatusException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class StatusMessageDialogExt
extends StatusMessageDialog2 {
    public StatusMessageDialogExt(Shell shell, String title, StatusException statusMessage) {
        super(shell, title, statusMessage);
    }

    @Override
    protected StatusMessageDialog2.IconAndMessageWidget createIconAndMessageWidget() {
        return new IconAndMessageWidgetExt();
    }

    public static class IconAndMessageWidgetExt
    extends StatusMessageDialog2.IconAndMessageWidget {
        protected Link helpControl;

        @Override
        protected void createMessageControl(Composite topControl) {
            super.createMessageControl(topControl);
            if (this.statusMessage instanceof IDetailsMessage) {
                IDetailsMessage detailsMessage = (IDetailsMessage)this.statusMessage;
                this.createDetailsMessage(topControl, detailsMessage);
            }
        }

        protected void createDetailsMessage(Composite topControl, IDetailsMessage detailsMessage) {
            String additionalMessage = "\n" + detailsMessage.getDetailsMessage();
            this.helpControl = SWTFactoryUtil.createLink(topControl, 64, additionalMessage, IconAndMessageWidgetExt.gdfFillDefaults().grab(true, true).span(2, 1).create());
            this.helpControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String uri = e.text;
                    if (uri.startsWith("http")) {
                        Program.launch((String)uri);
                    } else if (uri.startsWith("pref:")) {
                        String prefId = StringUtil.removeStart((String)"pref:", (String)uri);
                        WorkbenchUtils.openPreferencePage(helpControl.getShell(), prefId);
                    } else {
                        UIOperationsStatusHandler.handleInternalError("Unknown link URI:\n" + uri, null);
                    }
                }
            });
        }

        public Link getHelpControl() {
            return this.helpControl;
        }
    }
}

