/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.utils.StatusMessageDialogExt;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import org.eclipse.swt.widgets.Shell;

public class UIOperationErrorHandlerImpl {
    public void handleStatus(boolean logError, Shell shell, String title, String message, Throwable exception) {
        if (message == null) {
            message = "Error: ";
        }
        StatusException status = new StatusException(Severity.ERROR, message, exception);
        this.handleStatus(logError, shell, title, status);
    }

    public void handleStatus(boolean logError, Shell shell, String title, StatusException status) {
        if (logError) {
            LangCore.logStatusException((StatusException)status);
        }
        if (shell == null) {
            shell = WorkbenchUtils.getActiveWorkbenchShell();
        }
        Assert.AssertNamespace.assertNotNull((Object)shell);
        this.openMessageDialog(shell, title, status);
    }

    protected void openMessageDialog(Shell shell, String title, StatusException status) {
        new StatusMessageDialogExt(shell, title, status).open();
    }

    public final void displayStatusMessage(String title, StatusException status) {
        this.handleStatus(false, null, title, status);
    }

    public void displayStatusMessage(String title, Severity severity, String message) {
        this.handleStatus(false, null, title, new StatusException(severity, message));
    }

    protected static String getExceptionText(Throwable exception) {
        if (exception == null) {
            return null;
        }
        String exceptionText = exception.getClass().getName();
        if (exception.getMessage() != null) {
            exceptionText = String.valueOf(exceptionText) + ": " + exception.getMessage();
        }
        return exceptionText;
    }
}

