/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils.operations;

import melnorme.lang.ide.ui.editor.AbstractLangEditor;
import melnorme.lang.ide.ui.editor.EditorSourceBuffer;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.utils.operations.CalculateValueUIOperation;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractEditorOperation2<RESULT>
extends CalculateValueUIOperation<RESULT> {
    protected final ITextEditor editor;
    protected final IWorkbenchWindow window;
    protected final EditorSourceBuffer sourceBuffer;
    protected final IDocument doc;
    protected final IProject project;
    private final SourceOpContext sourceOpContext;

    public AbstractEditorOperation2(String operationName, ITextEditor editor) {
        this(operationName, editor, new SourceRange(0, 0));
    }

    public AbstractEditorOperation2(String operationName, ITextEditor editor, SourceRange range) {
        super(operationName);
        this.editor = (ITextEditor)Assert.AssertNamespace.assertNotNull((Object)editor);
        this.window = editor.getSite().getWorkbenchWindow();
        this.doc = (IDocument)Assert.AssertNamespace.assertNotNull((Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
        this.project = EditorUtils.getAssociatedProject(editor.getEditorInput());
        this.sourceBuffer = new EditorSourceBuffer(editor);
        this.sourceOpContext = this.sourceBuffer.getSourceOpContext(range);
    }

    public SourceOpContext getSourceOpContext() {
        return this.sourceOpContext;
    }

    public String getSource() {
        return this.sourceOpContext.getSource();
    }

    public SourceRange getOperationRange() {
        return this.sourceOpContext.getOperationRange();
    }

    public int getOperationOffset() {
        return this.sourceOpContext.getOffset();
    }

    public Location getInputLocation() throws CommonException {
        return this.sourceOpContext.getFileLocation();
    }

    @Override
    public void prepareOperation() throws CommonException {
        if (!this.sourceOpContext.getOptionalFileLocation().isPresent()) {
            throw new CommonException("No file available for editor contents.");
        }
    }

    @Override
    protected abstract void handleComputationResult(RESULT var1) throws CommonException;

    protected void handleStatusErrorMessage(String statusErrorMessage) {
        EditorUtils.setStatusLineErrorMessage(this.editor, statusErrorMessage, null);
        Display.getCurrent().beep();
    }

    protected SourceViewer getEditorSourceViewer() throws CommonException {
        if (this.editor instanceof AbstractLangEditor) {
            AbstractLangEditor langEditor = (AbstractLangEditor)this.editor;
            return langEditor.getSourceViewer_();
        }
        throw new CommonException("Possible internal error: SourceViewer not available.");
    }

    protected void setEditorTextPreservingCarret(String newContents) throws CommonException {
        IDocument document;
        if (CoreUtil.areEqual((Object)newContents, (Object)this.doc.get())) {
            return;
        }
        SourceViewer sourceViewer = this.getEditorSourceViewer();
        ISelection sel = sourceViewer.getSelectionProvider().getSelection();
        int line = -1;
        int col = -1;
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            try {
                line = this.doc.getLineOfOffset(textSelection.getOffset());
                col = textSelection.getOffset() - this.doc.getLineOffset(line);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if ((document = sourceViewer.getDocument()) instanceof IDocumentExtension4) {
            IDocumentExtension4 doc_4 = (IDocumentExtension4)document;
            DocumentRewriteSession rewriteSession = doc_4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            document.set(newContents);
            doc_4.stopRewriteSession(rewriteSession);
        } else {
            int topIndex = sourceViewer.getTopIndex();
            document.set(newContents);
            sourceViewer.setTopIndex(topIndex);
        }
        int newOffset = -1;
        if (line != -1 && col != -1) {
            try {
                newOffset = this.getOffsetFor(line, col);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (newOffset != -1) {
            sourceViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(newOffset, 0));
        } else {
            sourceViewer.getSelectionProvider().setSelection(sel);
        }
    }

    protected int getOffsetFor(int line, int col) throws BadLocationException {
        IRegion lineRegion = this.doc.getLineInformation(line);
        int offset = lineRegion.getOffset();
        return offset + Math.min(col, lineRegion.getLength());
    }
}

