/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils.operations;

import melnorme.lang.ide.core.utils.operation.CommonProgressRunnable;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RunOperationAsJob
extends Job {
    protected final CommonProgressRunnable opRunnable;
    protected final String operationName;

    public RunOperationAsJob(String operationName, CommonProgressRunnable opRunnable) {
        super(operationName);
        this.opRunnable = (CommonProgressRunnable)Assert.AssertNamespace.assertNotNull((Object)opRunnable);
        this.operationName = (String)Assert.AssertNamespace.assertNotNull((Object)operationName);
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor pm) {
        try {
            this.opRunnable.run(pm);
        }
        catch (CommonException ce) {
            Display.getDefault().asyncExec(() -> UIOperationsStatusHandler.handleOperationStatus(this.getName(), ce));
        }
        catch (OperationCancellation oc) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

