/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.views;

import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.util.swt.jface.TreeViewerExt;
import melnorme.util.swt.jface.TreeViewerUtil;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.ArrayUtil;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractFilteredTreePopupControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    protected final int treeStyle;
    protected TreeElementsFilter treeElementsFilter;
    protected Text filterText;
    protected TreeViewerExt treeViewer;
    protected Composite fViewMenuButtonComposite;
    protected String filteringString = "";
    protected Object firstDirectlyFilteredInElement;

    public AbstractFilteredTreePopupControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, true, true, false, true, true, null, null);
        this.treeStyle = treeStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText("Outline");
    }

    protected Text getFilterText() {
        return this.filterText;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void dispose() {
        this.close();
    }

    protected boolean hasHeader() {
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    protected IDialogSettings getDialogSettings() {
        return LangUIPlugin.getDialogSettings(this.getDialogSettingsId());
    }

    protected abstract String getDialogSettingsId();

    public boolean hasContents() {
        return this.treeViewer != null && this.treeViewer.getInput() != null;
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void widgetDisposed(DisposeEvent event) {
        this.treeViewer = null;
        this.filterText = null;
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.filterText = this.createFilterText(parent);
        }
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.filterText = this.createFilterText(parent);
        return this.filterText;
    }

    protected Text createFilterText(Composite parent) {
        this.filterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.filterText);
        this.filterText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    AbstractFilteredTreePopupControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractFilteredTreePopupControl.this.treeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractFilteredTreePopupControl.this.treeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractFilteredTreePopupControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.filterText;
    }

    protected Tree createTree(Composite parent, int treeStyle) {
        final Tree tree = new Tree(parent, 4 | treeStyle & 0xFFFFFFFD);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractFilteredTreePopupControl.this.dispose();
                }
            }
        });
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractFilteredTreePopupControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TreeItem selection;
                if (e.button != 1) {
                    return;
                }
                if (tree == e.getSource() && tree.getSelectionCount() == 1 && (selection = tree.getSelection()[0]).equals(tree.getItem(new Point(e.x, e.y)))) {
                    AbstractFilteredTreePopupControl.this.gotoSelectedElement();
                }
            }
        });
        return tree;
    }

    protected void createTreeViewer(Composite parent, int treeStyle) {
        Tree tree = this.createTree(parent, treeStyle);
        this.treeViewer = new TreeViewerFilterExt(tree);
        TreeViewerUtil.addTreeViewerMouseAutoScroller(this.treeViewer);
        this.treeElementsFilter = this.createTreeFilter();
        this.treeViewer.addFilter(this.treeElementsFilter);
        this.treeViewer.setAutoExpandLevel(-1);
    }

    protected Control createDialogArea(Composite parent) {
        this.createTreeViewer(parent, this.treeStyle);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                AbstractFilteredTreePopupControl.this.setFilteringString(text);
            }
        });
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList((Control[])CoreUtil.array((Object[])new Scrollable[]{this.filterText, this.treeViewer.getTree()}));
        } else {
            this.fViewMenuButtonComposite.setTabList((Control[])CoreUtil.array((Object[])new Text[]{this.filterText}));
            composite.setTabList((Control[])CoreUtil.array((Object[])new Composite[]{this.fViewMenuButtonComposite, this.treeViewer.getTree()}));
        }
    }

    public void setInformation(String information) {
    }

    public void setInput(Object information) {
        this.doSetInput(information, information);
    }

    protected void doSetInput(Object newInput, Object selectedElement) {
        this.filterText.setText("");
        this.treeViewer.setInput(newInput);
        this.treeViewer.setSelectedElement(selectedElement);
    }

    protected Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getSelectionFirstElement();
    }

    protected void setFilteringString(String pattern) {
        this.filteringString = pattern;
        this.refreshViewerFiltering();
    }

    protected void refreshViewerFiltering() {
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.refresh();
        this.treeViewer.setSelectedElement(this.firstDirectlyFilteredInElement);
        this.treeViewer.expandAll();
        this.treeViewer.getControl().setRedraw(true);
    }

    protected TreeElementsFilter createTreeFilter() {
        return new TreeElementsFilter();
    }

    protected boolean elementDirectlyFilteredIn(Object element) {
        if (this.filteringString.length() == 0) {
            return true;
        }
        String matchName = this.getText(element);
        Assert.AssertNamespace.assertNotNull((Object)matchName);
        return matchName != null && this.matchNameDirectlyFilteredIn(matchName);
    }

    protected String getText(Object element) {
        IBaseLabelProvider provider = this.treeViewer.getLabelProvider();
        if (provider instanceof ILabelProvider) {
            ILabelProvider labelProvider = (ILabelProvider)provider;
            return labelProvider.getText(element);
        }
        if (provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)provider;
            return labelProvider.getStyledText(element).getString();
        }
        if (provider instanceof DelegatingStyledCellLabelProvider) {
            DelegatingStyledCellLabelProvider styledCellLabelProvider = (DelegatingStyledCellLabelProvider)provider;
            DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider = styledCellLabelProvider.getStyledStringProvider();
            return labelProvider.getStyledText(element).getString();
        }
        return null;
    }

    protected abstract boolean matchNameDirectlyFilteredIn(String var1);

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
    }

    protected abstract void gotoSelectedElement();

    protected class TreeElementsFilter
    extends ViewerFilter {
        protected TreeElementsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Assert.AssertNamespace.assertTrue((viewer == AbstractFilteredTreePopupControl.this.treeViewer ? 1 : 0) != 0);
            return this.elementFilteredIn(element);
        }

        protected boolean elementFilteredIn(Object element) {
            if (AbstractFilteredTreePopupControl.this.elementDirectlyFilteredIn(element)) {
                if (AbstractFilteredTreePopupControl.this.firstDirectlyFilteredInElement == null) {
                    AbstractFilteredTreePopupControl.this.firstDirectlyFilteredInElement = element;
                }
                return true;
            }
            return this.hasFilteredInChildren(element);
        }

        protected boolean hasFilteredInChildren(Object element) {
            Object[] children = ((ITreeContentProvider)AbstractFilteredTreePopupControl.this.treeViewer.getContentProvider()).getChildren(element);
            Object[] objectArray = ArrayUtil.nullToEmpty((Object[])children);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.elementFilteredIn(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    protected class TreeViewerFilterExt
    extends TreeViewerExt {
        public TreeViewerFilterExt(Tree tree) {
            super(tree);
        }

        protected void internalInitializeTree(Control widget) {
            AbstractFilteredTreePopupControl.this.firstDirectlyFilteredInElement = null;
            super.internalInitializeTree(widget);
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            if (element == this.getRoot()) {
                AbstractFilteredTreePopupControl.this.firstDirectlyFilteredInElement = null;
            }
            super.internalRefresh(element, updateLabels);
        }
    }
}

