/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.views;

import melnorme.util.swt.jface.text.ColorManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public interface StylerHelpers {
    public static ForegroundColorStyler fgColor(RGB rgb) {
        return new ForegroundColorStyler(rgb);
    }

    public static class BoldStyler
    extends FontStyler {
        public BoldStyler(StyledString.Styler parentStyler) {
            super(parentStyler);
        }

        @Override
        protected FontDescriptor getModifiedFontDescriptor(FontDescriptor fontDescriptor) {
            return fontDescriptor.setStyle(1);
        }
    }

    public static abstract class FontStyler
    extends StyledString.Styler {
        protected StyledString.Styler parentStyler;

        public FontStyler(StyledString.Styler parentStyler) {
            this.parentStyler = parentStyler;
        }

        public void applyStyles(TextStyle textStyle) {
            Font font;
            if (this.parentStyler != null) {
                this.parentStyler.applyStyles(textStyle);
            }
            if ((font = textStyle.font) == null) {
                font = JFaceResources.getDefaultFont();
            }
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)font);
            fontDescriptor = this.getModifiedFontDescriptor(fontDescriptor);
            textStyle.font = fontDescriptor.createFont((Device)Display.getCurrent());
        }

        protected abstract FontDescriptor getModifiedFontDescriptor(FontDescriptor var1);
    }

    public static class ForegroundColorStyler
    extends StyledString.Styler {
        protected final RGB fgColor;
        protected final ColorManager registry = ColorManager.getDefault();

        public ForegroundColorStyler(RGB fgColor) {
            this.fgColor = fgColor;
        }

        public void applyStyles(TextStyle textStyle) {
            if (this.fgColor != null) {
                textStyle.foreground = this.registry.getColor(this.fgColor);
            }
        }
    }

    public static class ItalicStyler
    extends FontStyler {
        public ItalicStyler(StyledString.Styler parentStyler) {
            super(parentStyler);
        }

        @Override
        protected FontDescriptor getModifiedFontDescriptor(FontDescriptor fontDescriptor) {
            return fontDescriptor.setStyle(2);
        }
    }
}

