/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt;

import melnorme.util.swt.SWTLayoutUtil;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class SWTFactory {
    public static Composite createComposite(Composite parent, GridData gridData) {
        Composite composite = new Composite(parent, 0);
        return SWTLayoutUtil.setLayoutData(composite, gridData);
    }

    public static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        return composite;
    }

    public static Composite createGridComposite(Composite parent, int columns, GridData gridData) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(columns).create());
        if (gridData != null) {
            composite.setLayoutData((Object)gridData);
        }
        return composite;
    }

    public static Group createGroup(Composite parent, String label, GridData gridData) {
        Group group = SWTFactory.createGroup(parent, label);
        return SWTLayoutUtil.setLayoutData(group, gridData);
    }

    public static Group createGroup(Composite parent, String label) {
        return SWTFactory.createGroup(parent, label, 32);
    }

    public static Group createGroup(Composite parent, String label, int style) {
        Group group = new Group(parent, style);
        group.setText(label);
        return group;
    }

    public static Label createIconLabel(Composite parent, Image image, GridData gridData) {
        Label label = SWTFactory.createLabel(parent, 16384, "");
        label.setImage(image);
        return SWTLayoutUtil.setLayoutData(label, gridData);
    }

    public static Label createLabel(Composite parent, int style, String labelText, GridData gridData) {
        Label label = SWTFactory.createLabel(parent, style, labelText);
        return SWTLayoutUtil.setLayoutData(label, gridData);
    }

    public static Label createLabel(Composite parent, int style, String labelText) {
        Label label = new Label(parent, style);
        label.setText(labelText);
        return label;
    }

    public static Link createLink(Composite parent, int style, String labelText, GridData gridData) {
        Link link = SWTFactory.createLink(parent, style, labelText);
        return SWTLayoutUtil.setLayoutData(link, gridData);
    }

    public static Link createLink(Composite parent, int style, String labelText) {
        Link link = new Link(parent, style);
        link.setText(labelText);
        return link;
    }

    public static Button createButton(Composite parent, int style, String label, GridData gridData) {
        return SWTFactory.createButton(parent, style, label, null, gridData);
    }

    public static Button createButton(Composite parent, int style, String label, Image image, GridData gridData) {
        Button button = SWTFactory.createButton(parent, style, label, image);
        return SWTLayoutUtil.setLayoutData(button, gridData);
    }

    public static Button createButton(Composite parent, int style, String label) {
        return SWTFactory.createButton(parent, style, label, null);
    }

    public static Button createButton(Composite parent, int style, String label, Image image) {
        Button button = new Button(parent, style);
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        return SWTFactory.createPushButton(parent, label, image, new GridData());
    }

    public static Button createPushButton(Composite parent, String label, Image image, GridData gridData) {
        Button button = SWTFactory.createButton(parent, 8, label, image, gridData);
        if (gridData != null) {
            gridData.minimumWidth = SWTFactory.getButtonWidthHint(button);
            SWTLayoutUtil.setLayoutData(button, gridData);
        }
        return button;
    }

    public static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Button createPushButton(Composite parent, String label, Image image, GridData gridData, WidgetSelectedListener listener) {
        Button button = SWTFactory.createPushButton(parent, label, image);
        button.addSelectionListener((SelectionListener)listener);
        return SWTLayoutUtil.setLayoutData(button, gridData);
    }

    public static Text createText(Composite parent, int style) {
        return new Text(parent, style);
    }

    public static Text createText(Composite parent, int style, GridData gridData) {
        Text text = SWTFactory.createText(parent, style);
        return SWTLayoutUtil.setLayoutData(text, gridData);
    }

    public static Text createReadonlyText(Composite dialogArea, String initialText) {
        int style = 2056;
        Text text = SWTFactory.createText(dialogArea, style |= 0x42);
        text.setText(initialText);
        return text;
    }

    public static Text createReadonlyText(Composite dialogArea, String initialText, GridData gridData) {
        Text text = SWTFactory.createReadonlyText(dialogArea, initialText);
        return SWTLayoutUtil.setLayoutData(text, gridData);
    }

    public static Combo createCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        return combo;
    }

    public static Combo createCombo(Composite parent, int style, GridData gridData) {
        Combo combo = SWTFactory.createCombo(parent, style);
        return SWTLayoutUtil.setLayoutData(combo, gridData);
    }

    public static interface WidgetDefaultSelectedListener
    extends SelectionListener {
        default public void widgetSelected(SelectionEvent e) {
        }
    }

    public static interface WidgetSelectedListener
    extends SelectionListener {
        default public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

