/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components;

import melnorme.util.swt.components.AbstractDisableableWidget;
import melnorme.util.swt.components.IDisableableWidget;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class CompositeWidget
extends AbstractDisableableWidget {
    private final ArrayList2<AbstractDisableableWidget> subComponents = new ArrayList2();
    protected boolean createInlined = true;
    protected int layoutColumns = 1;
    protected GridDataFactory defaultRowLayout;

    public CompositeWidget(boolean createInlined) {
        this.createInlined = createInlined;
        this.defaultRowLayout = CompositeWidget.gdfFillDefaults().grab(true, false).hint(-1, -1);
    }

    public void addChildWidget(AbstractDisableableWidget ... subComponents) {
        AbstractDisableableWidget[] abstractDisableableWidgetArray = subComponents;
        int n = subComponents.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDisableableWidget subComponent = abstractDisableableWidgetArray[n2];
            this.addChildWidget((T)subComponent);
            ++n2;
        }
    }

    public <T extends AbstractDisableableWidget> T addChildWidget(T subComponent) {
        Assert.AssertNamespace.assertNotNull(subComponent);
        this.validation.addStatusField(true, subComponent.getStatusField());
        subComponent.setParent(this);
        this.subComponents.add(subComponent);
        return subComponent;
    }

    public final Indexable<IDisableableWidget> getChildWidgets() {
        return this.subComponents.upcastTypeParameter();
    }

    @Override
    public final int getPreferredLayoutColumns() {
        return this.layoutColumns;
    }

    @Override
    protected void doUpdateWidgetFromInput() {
        this.subComponents.forEach(subComponent -> subComponent.updateWidgetFromInput());
    }

    @Override
    protected void createContents(Composite topControl) {
        this.createSubComponents(topControl, this.createInlined);
    }

    protected void createSubComponents(Composite topControl, boolean createInlined) {
        if (createInlined) {
            this.getChildWidgets().forEach(subComponent -> subComponent.createComponentInlined(topControl));
        } else {
            this.getChildWidgets().forEach(subComponent -> this.createSubComponent(topControl, (IDisableableWidget)subComponent));
        }
    }

    protected void createSubComponent(Composite topControl, IDisableableWidget subComponent) {
        subComponent.createComponent(topControl, this.getLayoutData(subComponent));
    }

    protected GridData getLayoutData(IDisableableWidget subComponent) {
        return this.createSubComponentDefaultGridData();
    }

    protected GridData createSubComponentDefaultGridData() {
        return this.defaultRowLayout.create();
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        this.subComponents.forEach(subComponent -> subComponent.updateControlEnablement2());
    }
}

