/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTLayoutUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.LabelledFieldWidget;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ColorField
extends LabelledFieldWidget<RGB> {
    protected ColorSelector colorSelector;

    public ColorField(String labelText) {
        super(labelText, LabelledFieldWidget.Option_AllowNull.NO, new RGB(0, 0, 0));
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents_all(Composite topControl) {
        this.createContents_Label(topControl);
        this.createContents_ColorChooser(topControl);
    }

    @Override
    protected void createContents_layout() {
        SWTLayoutUtil.layout2Controls_expandLast((Control)this.label, (Control)this.colorSelector.getButton());
    }

    protected void createContents_ColorChooser(Composite parent) {
        this.colorSelector = new ColorSelectorExt(parent);
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ColorField.this.setFieldValueFromControl(ColorField.this.colorSelector.getColorValue());
            }
        });
    }

    public ColorSelector getColorSelector() {
        return this.colorSelector;
    }

    @Override
    public Control getFieldControl() {
        return this.colorSelector == null ? null : this.colorSelector.getButton();
    }

    @Override
    protected void doUpdateWidgetFromValue() {
        this.colorSelector.setColorValue((RGB)this.getFieldValue());
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        SWTUtil.setEnabledIfOk((Control)this.label, enabled);
        if (this.colorSelector != null) {
            SWTUtil.setEnabledIfOk((Control)this.colorSelector.getButton(), enabled);
        }
    }

    public static class ColorSelectorExt
    extends ColorSelector {
        public ColorSelectorExt(Composite parent) {
            super(parent);
        }

        public void setColorValue(RGB newColor) {
            RGB oldValue = this.getColorValue();
            super.setColorValue(newColor);
            Object[] finalListeners = this.getListeners();
            if (finalListeners.length > 0) {
                PropertyChangeEvent pEvent = new PropertyChangeEvent((Object)this, "colorValue", (Object)oldValue, (Object)newColor);
                Object[] objectArray = finalListeners;
                int n = finalListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    IPropertyChangeListener listener = (IPropertyChangeListener)object;
                    listener.propertyChange(pEvent);
                    ++n2;
                }
            }
        }
    }
}

