/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.SWTLayoutUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.LabelledFieldWidget;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboOptionsField
extends LabelledFieldWidget<String> {
    protected Indexable<String> fieldOptions = ArrayList2.create();
    protected int comboStyle = 4;
    protected Combo combo;

    public ComboOptionsField(String labelText) {
        super(labelText, LabelledFieldWidget.Option_AllowNull.YES, null);
    }

    public Indexable<String> getComboOptions() {
        return this.fieldOptions;
    }

    public void setFieldOptions(String ... fieldOptions) {
        this.setFieldOptions((Indexable<String>)ArrayList2.create((Object[])fieldOptions));
    }

    public void setFieldOptions(Indexable<String> fieldOptions) {
        this.fieldOptions = fieldOptions;
        String fieldValue = this.getEffectiveValue((String)this.getFieldValue());
        this.setComboItems();
        if (fieldValue == null && !fieldOptions.isEmpty()) {
            fieldValue = (String)fieldOptions.get(0);
        }
        this.setFieldValue(fieldValue);
    }

    @Override
    protected void doSetFieldValue(String newValue) {
        super.doSetFieldValue(this.getEffectiveValue(newValue));
    }

    public String getEffectiveValue(String newValue) {
        if (newValue != null) {
            for (String comboOption : this.fieldOptions) {
                if (!newValue.equals(comboOption)) continue;
                return newValue;
            }
        }
        if (!this.fieldOptions.isEmpty()) {
            return (String)this.fieldOptions.get(0);
        }
        return null;
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents_all(Composite topControl) {
        this.createContents_Label(topControl);
        this.createContents_Combo(topControl);
    }

    @Override
    protected void createContents_layout() {
        SWTLayoutUtil.layout2Controls((Control)this.label, (Control)this.combo);
    }

    protected void createContents_Combo(Composite topControl) {
        this.combo = this.createComboControl(topControl);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboOptionsField.this.setFieldValueFromControl(ComboOptionsField.this.combo.getText());
            }
        });
        this.setComboItems();
    }

    protected Combo createComboControl(Composite topControl) {
        return SWTFactoryUtil.createCombo(topControl, this.comboStyle | 8);
    }

    protected void setComboItems() {
        if (SWTUtil.isOkToUse((Control)this.combo)) {
            this.combo.setItems((String[])this.fieldOptions.toArray(String.class));
        }
    }

    public Combo getFieldControl() {
        return this.combo;
    }

    @Override
    protected void doUpdateWidgetFromValue() {
        String stringValue = StringUtil.asString(this.getFieldValue());
        if (stringValue != null) {
            this.combo.setText(stringValue);
        } else if (this.combo.getSelectionIndex() != -1) {
            this.combo.deselect(this.combo.getSelectionIndex());
        }
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        SWTUtil.setEnabledIfOk((Control)this.getFieldControl(), enabled);
    }
}

