/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.IDisableableWidget;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.util.swt.components.fields.FieldCompositeWidget;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IProperty;
import melnorme.utilbox.status.IStatusMessage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;

public abstract class EnablementCompositeWidget<VALUE>
extends FieldCompositeWidget<VALUE> {
    public static final String LABEL_UseDefault = "Use default value.";
    protected String label;
    protected final CheckBoxField enablementField;
    protected final IProperty<VALUE> effectiveValueProperty = new IProperty<VALUE>(){

        public VALUE get() {
            return EnablementCompositeWidget.this.getEffectiveFieldValue();
        }

        public void set(VALUE value) {
            EnablementCompositeWidget.this.setEffectiveFieldValue(value);
        }
    };

    public EnablementCompositeWidget(String label, String useDefaultCheckboxLabel) {
        super(true);
        this.label = (String)Assert.AssertNamespace.assertNotNull((Object)label);
        Assert.AssertNamespace.assertNotNull((Object)useDefaultCheckboxLabel);
        this.enablementField = this.init_createUseDefaultField(useDefaultCheckboxLabel);
        this.enablementField.setFieldValue(true);
        this.enablementField.addChangeListener(this::handleEnablementChanged);
        this.addChildWidget(this.enablementField);
    }

    protected CheckBoxField init_createUseDefaultField(String enablementCheckBoxLabel) {
        return new CheckBoxField(enablementCheckBoxLabel);
    }

    public CheckBoxField getEnablementField() {
        return this.enablementField;
    }

    public boolean isUseDefault() {
        return this.enablementField.getBooleanFieldValue();
    }

    protected void handleEnablementChanged() {
        this.getValidation().setExplicitStatus(null);
        if (this.isUseDefault()) {
            VALUE defaultFieldValue;
            try {
                defaultFieldValue = this.getDefaultFieldValue();
            }
            catch (CommonException e) {
                defaultFieldValue = null;
                this.getValidation().setExplicitStatus((IStatusMessage)e.toStatusException());
            }
            this.field().setFieldValue(defaultFieldValue);
        }
        this.updateChildrenEnablement();
    }

    protected void updateChildrenEnablement() {
        for (IDisableableWidget childWidget : this.getChildWidgets()) {
            if (childWidget == this.enablementField) continue;
            childWidget.setEnabled(!this.isUseDefault());
        }
    }

    protected abstract VALUE getDefaultFieldValue() throws CommonException;

    public VALUE getEffectiveFieldValue() {
        return (VALUE)(this.isUseDefault() ? null : this.field().getFieldValue());
    }

    public void setEffectiveFieldValue(VALUE effectiveFieldValue) {
        this.getEnablementField().setFieldValue(effectiveFieldValue == null);
        if (effectiveFieldValue != null) {
            this.field().setFieldValue(effectiveFieldValue);
        }
    }

    public IProperty<VALUE> asEffectiveValueProperty() {
        return this.effectiveValueProperty;
    }

    public void addEffectiveValueChangeListener(FieldValueListener.FieldChangeListener listener) {
        this.getEnablementField().addChangeListener(listener);
        this.field().addChangeListener(listener);
    }

    @Override
    protected Composite doCreateTopLevelControl(Composite parent) {
        return SWTFactoryUtil.createGroup(parent, this.label, 0);
    }

    @Override
    protected GridLayoutFactory createTopLevelLayout() {
        return GridLayoutFactory.swtDefaults().numColumns(this.getPreferredLayoutColumns());
    }
}

