/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.lang.utils.validators.NumberValidator;
import melnorme.util.swt.components.fields.TextFieldExt;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.fields.IProperty;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;

public class NumberField
extends TextFieldExt {
    protected final IProperty<Integer> intProperty = new IProperty<Integer>(){

        public Integer get() {
            return new NumberValidator().getIntegerFrom((String)NumberField.this.getFieldValue());
        }

        public void set(Integer value) {
            Assert.AssertNamespace.assertTrue((value != null ? 1 : 0) != 0);
            NumberField.this.setFieldValue(value.toString());
        }
    };

    public NumberField(String label, int textLimit) {
        super(label, textLimit);
        this.getValidation().addFieldValidation(true, (IFieldView)this, this::validatePositiveNumber);
    }

    public IStatusMessage validatePositiveNumber() {
        return this.validatePositiveNumber((String)this.getFieldValue());
    }

    public StatusException validatePositiveNumber(String number) {
        try {
            this.doValidatePositiveNumber(number);
            return null;
        }
        catch (CommonException ce) {
            return ce.toStatusException(Severity.ERROR);
        }
    }

    public void doValidatePositiveNumber(String number) throws CommonException {
        new NumberValidator().validateNonNegativeInteger(number);
    }

    public IProperty<Integer> asIntProperty() {
        return this.intProperty;
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        super.doSetEnabled(enabled);
    }
}

