/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.misc;

import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.AbstractDisableableWidget;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusMessage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class StatusMessageWidget
extends AbstractDisableableWidget {
    protected Composite topControl;
    protected Label icon;
    protected Link hintText;

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    public void createComponentInlined(Composite parent) {
        Assert.AssertNamespace.assertFail();
    }

    @Override
    protected void createContents(Composite topControl) {
        this.topControl = topControl;
        this.icon = SWTFactoryUtil.createIconLabel(topControl, null, GridDataFactory.swtDefaults().create());
        this.hintText = SWTFactoryUtil.createLink(topControl, 16384, "", GridDataFactory.fillDefaults().hint(100, -1).grab(true, false).create());
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        StatusMessageWidget.setControlEnabled((Control)this.icon, enabled);
        StatusMessageWidget.setControlEnabled((Control)this.hintText, enabled);
    }

    @Override
    public void updateWidgetFromInput() {
        this.updateWidget(null);
    }

    public void updateWidget(IStatusMessage statusMessage) {
        if (!SWTUtil.isOkToUse((Control)this.icon)) {
            return;
        }
        this.topControl.setVisible(statusMessage != null);
        ((GridData)this.topControl.getLayoutData()).exclude = statusMessage == null;
        this.icon.setImage(statusMessage == null ? null : StatusMessageWidget.getImageForSeverity(statusMessage.getSeverity()));
        this.hintText.setText(statusMessage == null ? "" : statusMessage.getMessage());
        this.updateLayout();
    }

    protected void updateLayout() {
        this.topControl.getParent().layout(true, true);
    }

    public void setStatusMessage(Severity severity, String message) {
        Assert.AssertNamespace.assertNotNull((Object)message);
        this.setStatusMessage((IStatusMessage)new StatusMessage(severity, message));
    }

    public void setStatusMessage(IStatusMessage statusMessage) {
        this.updateWidget(statusMessage);
    }

    public static Image getImageForSeverity(Severity severity) {
        switch (severity) {
            case INFO: {
                return Dialog.getImage((String)"dialog_messasge_info_image");
            }
            case WARNING: {
                return Dialog.getImage((String)"dialog_messasge_warning_image");
            }
            case ERROR: {
                return Dialog.getImage((String)"dialog_message_error_image");
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }
}

