/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.jface;

import melnorme.util.swt.jface.TreeViewerExt;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerUtil {
    public static void addTreeViewerMouseAutoScroller(final TreeViewerExt treeViewer) {
        final Tree tree = treeViewer.getTree();
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                if (tree.equals(e.getSource())) {
                    TreeItem o;
                    if (this.fLastItem == null ^ (o = tree.getItem(new Point(e.x, e.y))) == null) {
                        tree.setCursor(o == null ? null : tree.getDisplay().getSystemCursor(21));
                    }
                    if (o instanceof TreeItem) {
                        Rectangle clientArea = tree.getClientArea();
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                            Point p = tree.toDisplay(e.x, e.y);
                            Item item = treeViewer.scrollUp(p.x, p.y);
                            if (item instanceof TreeItem) {
                                this.fLastItem = (TreeItem)item;
                                tree.setSelection(new TreeItem[]{this.fLastItem});
                            }
                        } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                            Point p = tree.toDisplay(e.x, e.y);
                            Item item = treeViewer.scrollDown(p.x, p.y);
                            if (item instanceof TreeItem) {
                                this.fLastItem = (TreeItem)item;
                                tree.setSelection(new TreeItem[]{this.fLastItem});
                            }
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
    }
}

