/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.jface.resources;

import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.EProtection;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.util.swt.jface.resources.CompositeImageDescriptorExt;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class LangElementImageDescriptor
extends CompositeImageDescriptorExt {
    public static final Point DEFAULT_SIZE = new Point(22, 16);
    protected final Point size;
    protected final ElementAttributes elementAttributes;

    public LangElementImageDescriptor(ImageDescriptor baseImage, ElementAttributes elementData) {
        this(DEFAULT_SIZE, baseImage, elementData);
    }

    public LangElementImageDescriptor(Point size, ImageDescriptor baseImage, ElementAttributes elementAttributes) {
        super(baseImage);
        this.size = (Point)Assert.AssertNamespace.assertNotNull((Object)size);
        this.elementAttributes = (ElementAttributes)Assert.AssertNamespace.assertNotNull((Object)elementAttributes);
    }

    protected Point getSize() {
        return this.size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        LangElementImageDescriptor other = (LangElementImageDescriptor)((Object)obj);
        return CoreUtil.areEqual((Object)this.baseImage, (Object)other.baseImage) && CoreUtil.areEqual((Object)this.size, (Object)other.size) && CoreUtil.areEqual((Object)this.elementAttributes, (Object)other.elementAttributes);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode((Object[])new Object[]{this.baseImage, this.size, this.elementAttributes});
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.baseImage);
        this.drawImage(bg, 0, 0);
        this.resetDrawPosition(CompositeImageDescriptorExt.Corner.TOP_LEFT);
        this.drawTopLeftDecorations();
        this.resetDrawPosition(CompositeImageDescriptorExt.Corner.TOP_RIGHT);
        this.drawTopRightDecorations();
        this.resetDrawPosition(CompositeImageDescriptorExt.Corner.BOTTOM_LEFT);
        this.drawBottomLeftDecorations();
        this.resetDrawPosition(CompositeImageDescriptorExt.Corner.BOTTOM_RIGHT);
        this.drawBottomRightDecorations();
    }

    protected void drawTopLeftDecorations() {
        if (this.elementAttributes.hasFlag(EAttributeFlag.TEMPLATED)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_TEMPLATED, CompositeImageDescriptorExt.Corner.TOP_LEFT);
        }
    }

    protected void drawTopRightDecorations() {
        if (this.elementAttributes.hasFlag(EAttributeFlag.CONST)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_CONST, CompositeImageDescriptorExt.Corner.TOP_RIGHT);
        }
        if (this.elementAttributes.hasFlag(EAttributeFlag.IMMUTABLE)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_IMMUTABLE, CompositeImageDescriptorExt.Corner.TOP_RIGHT);
        }
        if (this.elementAttributes.hasFlag(EAttributeFlag.FINAL)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_FINAL, CompositeImageDescriptorExt.Corner.TOP_RIGHT);
        }
        if (this.elementAttributes.hasFlag(EAttributeFlag.ABSTRACT)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_ABSTRACT, CompositeImageDescriptorExt.Corner.TOP_RIGHT);
        }
        if (this.elementAttributes.hasFlag(EAttributeFlag.STATIC)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_STATIC, CompositeImageDescriptorExt.Corner.TOP_RIGHT);
        }
    }

    protected void drawBottomLeftDecorations() {
        if (this.elementAttributes.hasFlag(EAttributeFlag.ALIASED)) {
            this.drawOverlayAtCursor(LangImages.DESC_OVR_ALIAS, CompositeImageDescriptorExt.Corner.BOTTOM_LEFT);
        }
    }

    protected void drawBottomRightDecorations() {
        ImageDescriptor protectionDecoration = this.getProtectionDecoration();
        if (protectionDecoration != null) {
            this.drawOverlayAtCursor(protectionDecoration, CompositeImageDescriptorExt.Corner.BOTTOM_RIGHT);
        }
    }

    protected ImageDescriptor getProtectionDecoration() {
        return LangElementImageDescriptor.getProtectionDecoration2(this.elementAttributes.getProtection());
    }

    public static ImageDescriptor getProtectionDecoration2(EProtection protection) {
        return LangElementImageDescriptor.getProtectionDecoration_Small(protection);
    }

    public static ImageDescriptor getProtectionDecoration_Big(EProtection protection) {
        if (protection == null) {
            return null;
        }
        switch (protection) {
            case PRIVATE: {
                return LangImages.DESC_OVR_PRIVATE;
            }
            case PROTECTED: {
                return LangImages.DESC_OVR_PROTECTED;
            }
            case PACKAGE: {
                return LangImages.DESC_OVR_DEFAULT;
            }
        }
        return null;
    }

    public static ImageDescriptor getProtectionDecoration_Small(EProtection protection) {
        if (protection == null) {
            return null;
        }
        switch (protection) {
            case PRIVATE: {
                return LangImages.DESC_OVR_PRIVATE_SMALL;
            }
            case PROTECTED: {
                return LangImages.DESC_OVR_PROTECTED_SMALL;
            }
            case PACKAGE: {
                return LangImages.DESC_OVR_DEFAULT_SMALL;
            }
        }
        return null;
    }
}

