/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.jface.text;

import java.util.HashMap;
import java.util.Map;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements ISharedTextColors {
    private static final ColorManager defaultInstance = new ColorManager();
    protected final Map<RGB, Color> colors = new HashMap<RGB, Color>(16);

    public static ColorManager getDefault() {
        return (ColorManager)Assert.AssertNamespace.assertNotNull((Object)defaultInstance);
    }

    public Color getColor(RGB rgb) {
        Color color = this.colors.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colors.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
    }
}

