/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanel;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;
import org.jkiss.utils.CommonUtils;

public abstract class NativeToolConfigPanel<OBJECT_TYPE extends DBSObject>
implements DBTTaskConfigPanel {
    private static final Log log = Log.getLog(NativeToolConfigPanel.class);
    private final DBRRunnableContext runnableContext;
    private final DBTTaskType taskType;
    private final Class<OBJECT_TYPE> objectClass;
    private final Class<? extends DBPDataSourceProvider> providerClass;
    private AbstractNativeToolWizard ieWizard;
    private ClientHomesSelector homesSelector;
    private OBJECT_TYPE selectedObject;
    private DBPDataSourceContainer curDataSource;
    private DatabaseObjectsSelectorPanel selectorPanel;

    public NativeToolConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType, Class<OBJECT_TYPE> objectClass, Class<? extends DBPDataSourceProvider> providerClass) {
        this.runnableContext = runnableContext;
        this.taskType = taskType;
        this.objectClass = objectClass;
        this.providerClass = providerClass;
    }

    public void createControl(Composite parent, TaskConfigurationWizard wizard, final Runnable propertyChangeListener) {
        this.ieWizard = (AbstractNativeToolWizard)wizard;
        Group databasesGroup = UIUtils.createControlGroup((Composite)parent, (String)TaskNativeUIMessages.tools_wizard_database_group_title, (int)1, (int)1808, (int)0);
        this.selectorPanel = new DatabaseObjectsSelectorPanel((Composite)databasesGroup, false, this.runnableContext){

            protected boolean isDatabaseFolderVisible(DBNDatabaseFolder folder) {
                return folder.getChildrenClass() == NativeToolConfigPanel.this.objectClass;
            }

            protected boolean isDatabaseObjectVisible(DBSObject obj) {
                return NativeToolConfigPanel.this.objectClass.isInstance(obj);
            }

            protected void onSelectionChange(Object element) {
                NativeToolConfigPanel.this.selectedObject = element instanceof DBSWrapper && NativeToolConfigPanel.this.objectClass.isInstance(((DBSWrapper)element).getObject()) ? (DBSObject)NativeToolConfigPanel.this.objectClass.cast(((DBSWrapper)element).getObject()) : null;
                Object settings = NativeToolConfigPanel.this.ieWizard.getSettings();
                List databaseObjects = settings.getDatabaseObjects();
                databaseObjects.clear();
                if (NativeToolConfigPanel.this.selectedObject != null) {
                    databaseObjects.add(NativeToolConfigPanel.this.selectedObject);
                }
                if (settings instanceof AbstractImportExportSettings) {
                    ((AbstractImportExportSettings)settings).fillExportObjectsFromInput();
                }
                NativeToolConfigPanel.this.updateHomeSelector();
                propertyChangeListener.run();
            }

            protected boolean isFolderVisible(DBNLocalFolder folder) {
                for (DBNDataSource ds : folder.getNestedDataSources()) {
                    if (!this.isDataSourceVisible(ds)) continue;
                    return true;
                }
                return false;
            }

            protected boolean isDataSourceVisible(DBNDataSource dataSource) {
                try {
                    DBPDriver driver = dataSource.getDataSourceContainer().getDriver();
                    return NativeToolConfigPanel.this.providerClass.isInstance(driver.getDataSourceProvider()) && driver.getNativeClientManager() != null && driver.getNativeClientManager().supportsNativeClients();
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    return false;
                }
            }
        };
        Group clientGroup = UIUtils.createControlGroup((Composite)parent, (String)TaskNativeUIMessages.tools_wizard_client_group_title, (int)1, (int)768, (int)0);
        this.homesSelector = new ClientHomesSelector((Composite)clientGroup, TaskNativeUIMessages.tools_wizard_client_group_client);
        this.homesSelector.addSelectionChangedListener(event -> propertyChangeListener.run());
        this.homesSelector.getPanel().setLayoutData((Object)new GridData(768));
    }

    private void updateHomeSelector() {
        DBPDataSourceContainer newDataSource = null;
        if (this.selectedObject instanceof DBPDataSourceContainer) {
            newDataSource = (DBPDataSourceContainer)this.selectedObject;
        } else if (this.selectedObject != null) {
            newDataSource = this.selectedObject.getDataSource().getContainer();
        }
        if (newDataSource != null && this.curDataSource != newDataSource) {
            this.homesSelector.populateHomes(newDataSource.getDriver(), newDataSource.getConnectionConfiguration().getClientHomeId(), true);
        }
        this.curDataSource = newDataSource;
    }

    public void loadSettings() {
        List databaseObjects = this.ieWizard.getSettings().getDatabaseObjects();
        Iterator iterator = databaseObjects.iterator();
        block3: while (iterator.hasNext()) {
            DBSObject obj;
            DBSObject child = obj = (DBSObject)iterator.next();
            while (child != null) {
                if (this.objectClass.isInstance(child)) {
                    this.selectedObject = (DBSObject)this.objectClass.cast(child);
                    continue block3;
                }
                child = child.getParentObject();
            }
        }
        DBPDataSourceContainer container = this.ieWizard.getSettings().getDataSourceContainer();
        if (this.selectorPanel != null && (this.selectedObject != null || container != null)) {
            try {
                DBNDatabaseNode[] catalogNode = new DBNDatabaseNode[1];
                this.ieWizard.getRunnableContext().run(true, true, monitor -> {
                    DBNDatabaseNode dBNDatabaseNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)(this.selectedObject != null ? this.selectedObject : container), (boolean)false);
                });
                if (catalogNode[0] != null) {
                    List<DBNDatabaseNode> selCatalogs = Collections.singletonList(catalogNode[0]);
                    this.selectorPanel.setSelection(selCatalogs);
                }
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Catalogs", " Error loading catalog list", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void saveSettings() {
        String selectedHome = this.homesSelector.getSelectedHome();
        this.curDataSource.getConnectionConfiguration().setClientHomeId(selectedHome);
        this.curDataSource.persistConfiguration();
    }

    public boolean isComplete() {
        return this.homesSelector.getSelectedHome() != null && this.selectedObject != null;
    }

    public String getErrorMessage() {
        if (this.selectedObject == null) {
            return TaskNativeUIMessages.tools_wizard_error_no_database_object_selected;
        }
        if (CommonUtils.isEmpty((String)this.homesSelector.getSelectedHome())) {
            return TaskNativeUIMessages.tools_wizard_error_no_native_client_selected;
        }
        return null;
    }
}

