/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import net.haesleinhuepf.clij.CLIJ;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import sc.fiji.labkit.pixel_classification.gpu.api.DefaultGpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuScope;

public class GpuPool {
    private final BlockingDeque<Integer> deviceIds;
    private final GenericObjectPool<DefaultGpuApi> pool;
    private static final GpuPool POOL = new GpuPool();

    public static GpuApi borrowGpu() {
        if (!GpuPool.isGpuAvailable()) {
            throw new IllegalStateException("No OpenCL device is available.");
        }
        return POOL.gpu();
    }

    private GpuPool() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        this.deviceIds = new LinkedBlockingDeque<Integer>(GpuPool.initializeDeviceIds());
        System.out.println("OpenCL device used: " + this.deviceIds);
        config.setMaxTotal(this.deviceIds.size());
        config.setMinIdle(0);
        config.setMinEvictableIdleTimeMillis(2000L);
        config.setTimeBetweenEvictionRunsMillis(500L);
        this.pool = new GenericObjectPool((PooledObjectFactory)new MyObjectFactory(), config);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.pool.close()));
    }

    public GpuApi gpu() {
        try {
            DefaultGpuApi gpu = (DefaultGpuApi)this.pool.borrowObject();
            return new GpuScope(gpu, () -> this.pool.returnObject((Object)gpu));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isGpuAvailable() {
        return GpuPool.size() > 0;
    }

    public static int size() {
        return GpuPool.POOL.pool.getMaxTotal();
    }

    private static List<Integer> initializeDeviceIds() {
        String configString = System.getenv("LABKIT_OPENCL_DEVICES");
        List<String> availableDeviceNames = GpuPool.getAvailableDeviceNames();
        if (availableDeviceNames == null || availableDeviceNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (configString == null || configString.isEmpty()) {
            return GpuPool.defaultOpenClDeviceIds(availableDeviceNames);
        }
        return GpuPool.parseOpenClConfigString(configString, availableDeviceNames);
    }

    private static List<String> getAvailableDeviceNames() {
        try {
            return CLIJ.getAvailableDeviceNames();
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    static List<Integer> parseOpenClConfigString(String configString, List<String> availableDeviceName) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String config : configString.split(";")) {
            config = config.trim();
            int space = config.indexOf(" ");
            String first = config.substring(0, space);
            String second = config.substring(space + 1).trim();
            result.addAll(Collections.nCopies(Integer.parseInt(first), GpuPool.findOpenClDeviceId(second, availableDeviceName)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Integer> defaultOpenClDeviceIds(List<String> availableDeviceNames) {
        int deviceIndex = GpuPool.defaultOpenCLDeviceId(availableDeviceNames);
        try (CLIJ clij = new CLIJ(deviceIndex);){
            long memory = clij.getGPUMemoryInBytes();
            int instances = (int)(memory / 500000000L);
            List<Integer> list = Collections.nCopies(instances, deviceIndex);
            return list;
        }
    }

    static int findOpenClDeviceId(String id, List<String> availableDeviceNames) {
        if (id.startsWith("device_id:")) {
            return Integer.parseInt(id.substring("device_id:".length()));
        }
        if (id.equals("*")) {
            return GpuPool.defaultOpenCLDeviceId(availableDeviceNames);
        }
        for (int i = 0; i < availableDeviceNames.size(); ++i) {
            if (!availableDeviceNames.get(i).contains(id)) continue;
            return i;
        }
        throw new RuntimeException("No such OpenCL device found: " + id);
    }

    private static int defaultOpenCLDeviceId(List<String> availableDeviceNames) {
        for (int i = 0; i < availableDeviceNames.size(); ++i) {
            if (availableDeviceNames.get(i).contains("CPU")) continue;
            return i;
        }
        return 0;
    }

    private class MyObjectFactory
    implements PooledObjectFactory<DefaultGpuApi> {
        private MyObjectFactory() {
        }

        public PooledObject<DefaultGpuApi> makeObject() throws Exception {
            int deviceId = (Integer)GpuPool.this.deviceIds.take();
            System.out.println("Create gpu context for device: " + deviceId);
            return new DefaultPooledObject((Object)new DefaultGpuApi(deviceId));
        }

        public void destroyObject(PooledObject<DefaultGpuApi> pooledObject) throws Exception {
            DefaultGpuApi gpuApi = (DefaultGpuApi)pooledObject.getObject();
            gpuApi.close();
            int deviceId = gpuApi.getOpenClDeviceId();
            System.out.println("Return context for device: " + deviceId);
            GpuPool.this.deviceIds.put(deviceId);
        }

        public boolean validateObject(PooledObject<DefaultGpuApi> pooledObject) {
            return true;
        }

        public void activateObject(PooledObject<DefaultGpuApi> pooledObject) {
        }

        public void passivateObject(PooledObject<DefaultGpuApi> pooledObject) {
        }
    }
}

