/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractGroupFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;

public abstract class AbstractSigmaGroupFeatureOp
extends AbstractGroupFeatureOp {
    private final boolean includeZero;

    protected AbstractSigmaGroupFeatureOp(boolean includeZero) {
        this.includeZero = includeZero;
    }

    private List<Double> initSigmas() {
        ArrayList<Double> sigmas = new ArrayList<Double>();
        if (this.includeZero) {
            sigmas.add(0.0);
        }
        sigmas.addAll(this.globalSettings().sigmas());
        return sigmas;
    }

    @Override
    protected List<FeatureSetting> initFeatures() {
        Class<? extends FeatureOp> featureClass = this.getSingleFeatureClass();
        return this.initSigmas().stream().map(sigma -> new FeatureSetting(featureClass, "sigma", sigma)).collect(Collectors.toList());
    }

    protected abstract Class<? extends FeatureOp> getSingleFeatureClass();
}

