/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.gabor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imagej.ops.OpEnvironment;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;
import sc.fiji.labkit.pixel_classification.utils.views.FastViews;

@Deprecated
@Plugin(type=FeatureOp.class, label="Gabor")
public class SingleGaborFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma;
    @Parameter
    private double gamma;
    @Parameter
    private double psi;
    @Parameter
    private double frequency;
    @Parameter
    private int nAngles;
    @Parameter
    private boolean legacyNormalize = false;
    private List<RandomAccessibleInterval<FloatType>> kernels;

    public void initialize() {
        if (this.sigma == 0.0) {
            throw new AssertionError((Object)"sigma must be non zero.");
        }
        this.kernels = this.initGaborKernels(this.sigma, this.gamma, this.psi, this.frequency, this.nAngles);
    }

    @Override
    public int count() {
        return 2;
    }

    @Override
    public void apply(FeatureInput in, List<RandomAccessibleInterval<FloatType>> out) {
        this.gaborProcessChannel(this.kernels, in.original(), out.get(0), out.get(1));
    }

    @Override
    public List<String> attributeLabels() {
        String details = "_" + this.sigma + "_" + this.gamma + "_" + (int)(this.psi / 0.7853981633974483) + "_" + this.frequency;
        return Arrays.asList("Gabor_1" + details, "Gabor_2" + details);
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    private List<RandomAccessibleInterval<FloatType>> initGaborKernels(double sigma, double gamma, double psi, double frequency, int nAngles) {
        int largerSigma;
        double sigma_x = sigma;
        double sigma_y = sigma / gamma;
        int n = largerSigma = sigma_x > sigma_y ? (int)sigma_x : (int)sigma_y;
        if (largerSigma < 1) {
            largerSigma = 1;
        }
        int filterSizeX = 6 * largerSigma + 1;
        int filterSizeY = 6 * largerSigma + 1;
        int middleX = Math.round(filterSizeX / 2);
        int middleY = Math.round(filterSizeY / 2);
        ArrayList<RandomAccessibleInterval<FloatType>> kernels = new ArrayList<RandomAccessibleInterval<FloatType>>();
        double rotationAngle = Math.PI / (double)nAngles;
        FinalInterval interval = new FinalInterval(new long[]{-middleX, -middleY}, new long[]{middleX, middleX});
        for (int i = 0; i < nAngles; ++i) {
            double theta = rotationAngle * (double)i;
            RandomAccessibleInterval<FloatType> kernel = RevampUtils.createImage((Interval)interval, new FloatType());
            SingleGaborFeature.garborKernel(kernel, psi, frequency, sigma_x, sigma_y, theta);
            kernels.add(kernel);
        }
        return kernels;
    }

    private static void garborKernel(RandomAccessibleInterval<FloatType> kernel, double psi, double frequency, double sigma_x, double sigma_y, double theta) {
        Cursor cursor = Views.iterable(kernel).cursor();
        double filterSizeX = kernel.max(0) - kernel.min(0) + 1L;
        double sigma_x2 = sigma_x * sigma_x;
        double sigma_y2 = sigma_y * sigma_y;
        while (cursor.hasNext()) {
            cursor.next();
            double x = cursor.getDoublePosition(0);
            double y = cursor.getDoublePosition(1);
            double xPrime = x * Math.cos(theta) + y * Math.sin(theta);
            double yPrime = y * Math.cos(theta) - x * Math.sin(theta);
            double a = 1.0 / (Math.PI * 2 * sigma_x * sigma_y) * Math.exp(-0.5 * (xPrime * xPrime / sigma_x2 + yPrime * yPrime / sigma_y2));
            double c = Math.cos(Math.PI * 2 * (frequency * xPrime) / filterSizeX + psi);
            ((FloatType)cursor.get()).set((float)(a * c));
        }
    }

    private void gaborProcessChannel(List<RandomAccessibleInterval<FloatType>> kernels, RandomAccessible<FloatType> channel, RandomAccessibleInterval<FloatType> max, RandomAccessibleInterval<FloatType> min) {
        RandomAccessibleInterval<FloatType> interval = min;
        RandomAccessibleInterval<FloatType> stack = RevampUtils.createImage(RevampUtils.appendDimensionToInterval(interval, 0L, kernels.size() - 1), new FloatType());
        FFTConvolution fftConvolution = new FFTConvolution(channel, interval, (RandomAccessible)kernels.get(0), (Interval)kernels.get(0), (ImgFactory)new ArrayImgFactory());
        fftConvolution.setKeepImgFFT(true);
        for (int i = 0; i < kernels.size(); ++i) {
            RandomAccessibleInterval<FloatType> kernel = kernels.get(i);
            IntervalView slice = Views.hyperSlice(stack, (int)2, (long)i);
            fftConvolution.setKernel(kernel);
            fftConvolution.setOutput((RandomAccessibleInterval)slice);
            fftConvolution.convolve();
            if (!this.legacyNormalize) continue;
            SingleGaborFeature.normalize(this.ops(), (RandomAccessibleInterval<FloatType>)slice);
        }
        SingleGaborFeature.maxAndMinProjection(stack, max, min);
    }

    private static void maxAndMinProjection(RandomAccessibleInterval<FloatType> stack, RandomAccessibleInterval<FloatType> max, RandomAccessibleInterval<FloatType> min) {
        RandomAccessibleInterval<Composite<FloatType>> collapsed = FastViews.collapse(stack);
        long size = stack.max(2) - stack.min(2) + 1L;
        LoopBuilder.setImages(collapsed, max).forEachPixel((in, out) -> out.set(SingleGaborFeature.max((Composite<FloatType>)in, size)));
        LoopBuilder.setImages(collapsed, min).forEachPixel((in, out) -> out.set(SingleGaborFeature.min((Composite<FloatType>)in, size)));
    }

    private static float max(Composite<FloatType> in, long size) {
        float max = Float.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < size) {
            max = Math.max(max, ((FloatType)in.get((long)i)).get());
            ++i;
        }
        return max;
    }

    private static float min(Composite<FloatType> in, long size) {
        float min = Float.POSITIVE_INFINITY;
        int i = 0;
        while ((long)i < size) {
            min = Math.min(min, ((FloatType)in.get((long)i)).get());
            ++i;
        }
        return min;
    }

    static void normalize(OpEnvironment ops, RandomAccessibleInterval<FloatType> image2) {
        DoubleType mean = (DoubleType)ops.stats().mean((Iterable)Views.iterable(image2));
        DoubleType stdDev = (DoubleType)ops.stats().stdDev((Iterable)Views.iterable(image2));
        float mean2 = (float)mean.get();
        float invStdDev = stdDev.get() == 0.0 ? 1.0f : (float)(1.0 / stdDev.get());
        Views.iterable(image2).forEach(value -> value.set((value.get() - mean2) * invStdDev));
    }
}

