/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.Font;
import java.awt.Rectangle;

public class Time_Stamper
implements ExtendedPlugInFilter {
    ImagePlus imp;
    static int x = 2;
    static int y = 15;
    static int size = 12;
    int maxWidth;
    Font font;
    static double start = 0.0;
    static double interval = 1.0;
    static String suffix = "sec";
    static int decimalPlaces = 0;
    int idx = 1;
    static boolean digital = false;
    boolean AAtext = true;
    boolean addToOverlay;
    final int flags = 2111;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Time_Stamper.class);
        return 2111;
    }

    public void setNPasses(int nPasses) {
    }

    public void run(ImageProcessor ip) {
        ip.setFont(this.font);
        ip.setColor(Toolbar.getForegroundColor());
        ip.setAntialiasedText(this.AAtext);
        boolean useFrames = this.imp.isHyperStack() || this.imp.getNFrames() > 1;
        int[] pos = this.imp.convertIndexToPosition(this.idx);
        int frame = useFrames ? pos[2] : pos[1];
        double time = start + (double)(frame - 1) * interval;
        String s = "";
        s = digital ? this.getString2(time) : this.getString(time);
        if (this.addToOverlay) {
            Overlay overlay = this.imp.getOverlay();
            if (overlay == null) {
                overlay = new Overlay();
                this.imp.setOverlay(overlay);
            }
            TextRoi textRoi = new TextRoi(x + this.maxWidth - ip.getStringWidth(s), y, s);
            textRoi.setPosition(pos[0], pos[1], pos[2]);
            overlay.add((Roi)textRoi);
        } else {
            ip.moveTo(x + this.maxWidth - ip.getStringWidth(s), y);
            ip.drawString(s);
        }
        ++this.idx;
    }

    String getString(double time) {
        if (Math.abs(interval) < 1.0E-5) {
            return suffix;
        }
        if (decimalPlaces == 0) {
            return (int)time + " " + suffix;
        }
        return IJ.d2s((double)time, (int)decimalPlaces) + " " + suffix;
    }

    String getString2(double time) {
        if (time < 10.0) {
            return "00:0" + (int)time;
        }
        if (time < 60.0) {
            return "00:" + (int)time;
        }
        if (time >= 60.0) {
            int hour = (int)time / 60;
            int min = (int)time % 60;
            if (hour < 10 && min < 10) {
                return "0" + hour + ":0" + min;
            }
            if (hour < 10 && min >= 10) {
                return "0" + hour + ":" + min;
            }
            if (hour >= 10 && min < 10) {
                return hour + ":0" + min;
            }
            if (hour >= 10 && min >= 10) {
                return hour + ":" + min;
            }
        }
        if (decimalPlaces == 0) {
            return "" + (int)time;
        }
        return IJ.d2s((double)time, (int)decimalPlaces);
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
            size = (int)(((double)roi.height - 1.10526) / 0.934211);
            if (size < 7) {
                size = 7;
            }
            if (size > 80) {
                size = 80;
            }
        }
        String[] timeunitsoptions = new String[]{"hours", "minutes", "seconds"};
        GenericDialog gd = new GenericDialog("Time Stamper");
        gd.addNumericField("Starting Time:", start, 2);
        gd.addNumericField("Interval:", interval, 2);
        gd.addNumericField("X Location:", (double)x, 0);
        gd.addNumericField("Y Location:", (double)y, 0);
        gd.addNumericField("Font Size:", (double)size, 0);
        gd.addCheckbox("'00:00' format:", digital);
        gd.addNumericField("Decimal Places:", (double)decimalPlaces, 0);
        gd.addStringField("Or with a suffix  Suffix:", suffix);
        gd.addCheckbox("Anti-Aliased text?", true);
        gd.addCheckbox("Overlay", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        start = gd.getNextNumber();
        interval = gd.getNextNumber();
        int timeindex = gd.getNextChoiceIndex();
        x = (int)gd.getNextNumber();
        y = (int)gd.getNextNumber();
        size = (int)gd.getNextNumber();
        digital = gd.getNextBoolean();
        decimalPlaces = (int)gd.getNextNumber();
        this.AAtext = gd.getNextBoolean();
        suffix = gd.getNextString();
        this.font = new Font("SansSerif", 0, size);
        ip.setFont(this.font);
        if (y < size) {
            y = size;
        }
        this.maxWidth = ip.getStringWidth(this.getString(start + interval * (double)imp.getStackSize()));
        this.addToOverlay = gd.getNextBoolean();
        imp.startTiming();
        return 2111;
    }
}

