/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyFunctions;
import QuickPALM.ParticleSaver;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.plugin.frame.RoiManager;

class MyDialogs {
    ImagePlus imp;
    RoiManager rmanager;
    Roi[] rois;
    Prefs prefs = new Prefs();
    String ptablefile;
    int width;
    int height;
    int nslices;
    String imtitle;
    int nrois;
    int snr;
    double pixelsize;
    double fwhm;
    double pthrsh = 0.2;
    boolean smartsnr;
    int buffer;
    double cal_z;
    int window;
    double magn;
    double minsize;
    double maxsize;
    double symmetry;
    int maxpart;
    int threads;
    String model;
    String[] models = new String[5];
    boolean part_divergence;
    boolean part_extrainfo;
    boolean is3d;
    String calfile;
    boolean view = true;
    int viewer_accumulate;
    int viewer_update;
    double saturation;
    boolean attach;
    String imagedir;
    String pattern;
    String prefix;
    String sufix;
    int nimchars;
    int nimstart;
    int waittime;
    double viewer_tpixelsize;
    int viewer_owidth;
    int viewer_oheight;
    String[] view_modes = new String[4];
    String view_mode;
    boolean viewer_doConvolve;
    boolean viewer_do3d;
    boolean viewer_doMovie;
    double viewer_mergeabove;
    double viewer_mergebellow;
    double viewer_fwhm;
    boolean viewer_is8bit;
    double viewer_zstep;

    MyDialogs() {
    }

    public boolean getImageDirectory() {
        DirectoryChooser chooser = new DirectoryChooser("Choose directory to process");
        this.imagedir = chooser.getDirectory();
        return true;
    }

    public boolean getCalibrationFile() {
        String cal_dir = Prefs.get((String)"QuickPALM.cal_dir", (String)".");
        String cal_file = Prefs.get((String)"QuickPALM.cal_file", (String)"Astigmatism calibration.xls");
        OpenDialog chooser = new OpenDialog("Astigmatism calibration", cal_dir, cal_file);
        this.calfile = chooser.getDirectory() + chooser.getFileName();
        Prefs.set((String)"QuickPALM.cal_dir", (String)chooser.getDirectory());
        Prefs.set((String)"QuickPALM.cal_file", (String)chooser.getFileName());
        return true;
    }

    public boolean getParticlesTableFile() {
        String ptable_dir = Prefs.get((String)"QuickPALM.ptable_dir", (String)".");
        String ptable_file = Prefs.get((String)"QuickPALM.ptable_file", (String)"Particles Table.xls");
        OpenDialog chooser = new OpenDialog("Load Particles Table", ptable_dir, ptable_file);
        this.ptablefile = chooser.getDirectory() + chooser.getFileName();
        Prefs.set((String)"QuickPALM.ptable_dir", (String)chooser.getDirectory());
        Prefs.set((String)"QuickPALM.ptable_file", (String)chooser.getFileName());
        return true;
    }

    public boolean checkBeads() {
        this.rmanager = RoiManager.getInstance();
        if (IJ.versionLessThan((String)"1.26i")) {
            return false;
        }
        if (this.rmanager == null) {
            IJ.error((String)"Add bead ROIs to the RoiManager first (select region then press [t]).");
            return false;
        }
        this.nrois = this.rmanager.getCount();
        if (this.nrois == 0) {
            IJ.error((String)"Add bead ROIs to the RoiManager first (select region then press [t]).");
            return false;
        }
        this.rois = this.rmanager.getRoisAsArray();
        return true;
    }

    public boolean checkDrift() {
        this.rmanager = RoiManager.getInstance();
        if (IJ.versionLessThan((String)"1.26i")) {
            return false;
        }
        if (this.rmanager == null) {
            IJ.error((String)"Add ROIs to use in drift correction to the RoiManager first (select region then press [t]).");
            return false;
        }
        this.nrois = this.rmanager.getCount();
        if (this.nrois == 0) {
            IJ.error((String)"Add ROIs to use in drift correction to the RoiManager first (select region then press [t]).");
            return false;
        }
        this.rois = this.rmanager.getRoisAsArray();
        return true;
    }

    public boolean checkResolution() {
        this.rmanager = RoiManager.getInstance();
        if (IJ.versionLessThan((String)"1.26i")) {
            return false;
        }
        if (this.rmanager == null) {
            IJ.error((String)"Add ROIs to use in resolution estimation to the RoiManager first (select region then press [t]).");
            return false;
        }
        this.nrois = this.rmanager.getCount();
        if (this.nrois == 0) {
            IJ.error((String)"Add ROIs to use in resolution estimation to the RoiManager first (select region then press [t]).");
            return false;
        }
        this.rois = this.rmanager.getRoisAsArray();
        return true;
    }

    public boolean beadCalibration3d() {
        this.imp = IJ.getImage();
        if (this.imp == null) {
            IJ.noImage();
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.error((String)"Stack required");
            return false;
        }
        if (this.imp.getType() != 0 && this.imp.getType() != 1) {
            IJ.error((String)"8 or 16 bit greyscale image required");
            return false;
        }
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        this.nslices = this.imp.getStackSize();
        this.imtitle = this.imp.getTitle();
        this.models[0] = "*None*";
        this.models[1] = "line";
        this.models[2] = "2nd degree polynomial";
        this.models[3] = "3rd degree polynomial";
        this.models[4] = "4th degree polynomial";
        GenericDialog gd = new GenericDialog("3D PALM calibration");
        gd.addNumericField("Maximum FWHM (in px)", Prefs.get((String)"QuickPALM.3Dcal_fwhm", (double)20.0), 0);
        gd.addNumericField("Particle local threshold (% maximum intensity)", Prefs.get((String)"QuickPALM.pthrsh", (double)20.0), 0);
        gd.addNumericField("Z-spacing (nm)", Prefs.get((String)"QuickPALM.z-step", (double)10.0), 2);
        gd.addNumericField("Calibration Z-smoothing (radius)", Prefs.get((String)"QuickPALM.window", (double)1.0), 0);
        gd.addChoice("Model", this.models, Prefs.get((String)"QuickPALM.model", (String)this.models[3]));
        gd.addCheckbox("Show divergence of bead positions against model", Prefs.get((String)"QuickPALM.3Dcal_showDivergence", (boolean)false));
        gd.addCheckbox("Show extra particle info", Prefs.get((String)"QuickPALM.3Dcal_showExtraInfo", (boolean)false));
        gd.addMessage("\n\nDon't forget to save the table in the end...");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.fwhm = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.QuickPALM.3Dcal_fwhm", (double)this.fwhm);
        this.pthrsh = gd.getNextNumber() / 100.0;
        Prefs.set((String)"QuickPALM.pthrsh", (double)(this.pthrsh * 100.0));
        this.cal_z = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.z-step", (double)this.cal_z);
        this.window = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.window", (int)this.window);
        this.model = gd.getNextChoice();
        Prefs.set((String)"QuickPALM.model", (String)this.model);
        this.part_divergence = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.3Dcal_showDivergence", (boolean)this.part_divergence);
        this.part_extrainfo = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.3Dcal_showExtraInfo", (boolean)this.part_extrainfo);
        return true;
    }

    public boolean reconstructDataset() {
        this.view_modes[0] = "3D color";
        this.view_modes[1] = "2D histogram";
        this.view_modes[2] = "2D particle intensity (16-bit)";
        this.view_modes[3] = "2D particle intensity (8-bit)";
        GenericDialog gd = new GenericDialog("Reconstruct PALM/STORM Dataset");
        gd.addNumericField("Target pixel size for the rendered image (nm)", Prefs.get((String)"QuickPALM.viewer_tpixelsize", (double)30.0), 2);
        gd.addNumericField("Original image width (px)", Prefs.get((String)"QuickPALM.viewer_owidth", (double)512.0), 2);
        gd.addNumericField("Original image height (px)", Prefs.get((String)"QuickPALM.viewer_oheight", (double)512.0), 2);
        gd.addChoice("View mode", this.view_modes, Prefs.get((String)"QuickPALM.view_mode", (String)this.view_modes[1]));
        gd.addCheckbox("Simulate sub-difraction spot (gaussian convolution - only 2D)", Prefs.get((String)"QuickPALM.viewer_doConvolve", (boolean)true));
        gd.addCheckbox("Make 3D stack", false);
        gd.addCheckbox("Make movie", false);
        gd.addMessage("\n");
        gd.addMessage("-- Simulate sub-difraction spot settings (used only if selected) --");
        gd.addNumericField("FWHM of the spot", Prefs.get((String)"QuickPALM.viewer_fwhm", (double)30.0), 2);
        gd.addMessage("\n");
        gd.addMessage("-- Make 3D stack settings (used only if selected) --");
        gd.addNumericField("Z-spacing between slices (nm)", Prefs.get((String)"QuickPALM.viewer_zstep", (double)50.0), 2);
        gd.addNumericField("Merge particle Z-position above (nm - 0 for full Z range)", Prefs.get((String)"QuickPALM.viewer_mergeabove", (double)0.0), 2);
        gd.addNumericField("Merge particle Z-position bellow (nm - 0 for full Z range)", Prefs.get((String)"QuickPALM.viewer_mergebellow", (double)0.0), 2);
        gd.addMessage("\n");
        gd.addMessage("-- Make movie settings (used only if selected) --");
        gd.addNumericField("Make a reconstruction in every N frames", Prefs.get((String)"QuickPALM.viewer_update", (double)10.0), 0);
        gd.addNumericField("Accumulate N neighboring frames for each reconstruction\n(set to 0 to accumulate all the preceding frames)", Prefs.get((String)"QuickPALM.viewer_accumulate", (double)100.0), 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.viewer_tpixelsize = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_tpixelsize", (double)this.viewer_tpixelsize);
        this.viewer_owidth = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_owidth", (int)this.viewer_owidth);
        this.viewer_oheight = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_oheight", (int)this.viewer_oheight);
        this.view_mode = gd.getNextChoice();
        Prefs.set((String)"QuickPALM.view_mode", (String)this.view_mode);
        this.viewer_doConvolve = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.viewer_doConvolve", (boolean)this.viewer_doConvolve);
        this.viewer_do3d = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.viewer_do3d", (boolean)this.viewer_do3d);
        this.viewer_doMovie = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.viewer_doMovie", (boolean)this.viewer_doMovie);
        this.viewer_fwhm = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_fwhm", (double)this.viewer_fwhm);
        this.viewer_zstep = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_zstep", (double)this.viewer_zstep);
        this.viewer_mergeabove = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_mergeabove", (double)this.viewer_mergeabove);
        this.viewer_mergebellow = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_mergebellow", (double)this.viewer_mergebellow);
        this.viewer_update = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_update", (int)this.viewer_update);
        this.viewer_accumulate = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.viewer_accumulate", (int)this.viewer_accumulate);
        return true;
    }

    public boolean analyseParticles(MyFunctions f) {
        GenericDialog gd = new GenericDialog("Analyse PALM/STORM Particles");
        gd.addNumericField("Minimum SNR", Prefs.get((String)"QuickPALM.snr", (double)5.0), 2);
        gd.addNumericField("Maximum FWHM (in px)", Prefs.get((String)"QuickPALM.fwhm", (double)4.0), 0);
        gd.addNumericField("Image plane pixel size (nm)", Prefs.get((String)"QuickPALM.pixelsize", (double)106.0), 2);
        gd.addCheckbox("Smart SNR", Prefs.get((String)"QuickPALM.smartsnr", (boolean)true));
        gd.addCheckbox("3D PALM (astigmatism) - will require calibration file", Prefs.get((String)"QuickPALM.is3d", (boolean)false));
        gd.addCheckbox("Online rendering", Prefs.get((String)"QuickPALM.view", (boolean)true));
        gd.addCheckbox("Attach to running acquisition", Prefs.get((String)"QuickPALM.attach", (boolean)false));
        gd.addCheckbox("Stream particle info directly into file", Prefs.get((String)"QuickPALM.stream", (boolean)true));
        gd.addMessage("\n");
        gd.addMessage("-- Online rendering settings (used only if selected) --");
        gd.addMessage("\n");
        gd.addNumericField("Pixel size of rendered image (nm)", 30.0, 2);
        gd.addNumericField("Accumulate last (0 to accumulate all frames)", 0.0, 0);
        gd.addNumericField("Update every (frames)", 10.0, 0);
        gd.addMessage("\n");
        gd.addMessage("-- Attach to running acquisition settings (used only if selected) --");
        gd.addMessage("\n");
        gd.addStringField("_Image name pattern (NN...NN represents the numerical change)", Prefs.get((String)"QuickPALM.pattern", (String)"imgNNNNNNNNN.tif"), 20);
        gd.addNumericField("Start NN...NN with", 0.0, 0);
        gd.addNumericField("In acquisition max. wait time for new image (ms)", 50.0, 0);
        gd.addMessage("\n");
        gd.addMessage("-- Advanced settings (don't normally need to be changed) --");
        gd.addMessage("\n");
        gd.addNumericField("_Minimum symmetry (%)", Prefs.get((String)"QuickPALM.symmetry", (double)50.0), 0);
        gd.addNumericField("Local threshold (% maximum intensity)", Prefs.get((String)"QuickPALM.lthreshold", (double)20.0), 0);
        gd.addNumericField("_Maximum iterations per frame", Prefs.get((String)"QuickPALM.maxiter", (double)1000.0), 0);
        gd.addNumericField("Threads (each takes ~3*[frame size] in memory)", Prefs.get((String)"QuickPALM.nthreads", (double)50.0), 0);
        gd.addMessage("\n\nDon't forget to save the table in the end...");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.snr = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.snr", (int)this.snr);
        this.fwhm = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.fwhm", (double)this.fwhm);
        this.pixelsize = gd.getNextNumber();
        Prefs.set((String)"QuickPALM.pixelsize", (double)this.pixelsize);
        this.smartsnr = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.smartsnr", (boolean)this.smartsnr);
        this.is3d = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.is3d", (boolean)this.is3d);
        this.view = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.view", (boolean)this.view);
        this.attach = gd.getNextBoolean();
        Prefs.set((String)"QuickPALM.attach", (boolean)this.attach);
        if (gd.getNextBoolean()) {
            f.psave = new ParticleSaver();
            f.psave.setup();
            Prefs.set((String)"QuickPALM.stream", (boolean)true);
        } else {
            Prefs.set((String)"QuickPALM.stream", (boolean)false);
        }
        this.magn = this.pixelsize / gd.getNextNumber();
        this.viewer_accumulate = (int)gd.getNextNumber();
        this.viewer_update = (int)gd.getNextNumber();
        this.pattern = gd.getNextString().trim();
        Prefs.set((String)"QuickPALM.pattern", (String)this.pattern);
        this.prefix = this.pattern.substring(0, this.pattern.indexOf("N"));
        this.sufix = this.pattern.substring(this.pattern.lastIndexOf("N") + 1, this.pattern.length());
        this.nimchars = this.pattern.split("N").length - 1;
        this.nimstart = (int)gd.getNextNumber();
        this.waittime = (int)gd.getNextNumber();
        this.symmetry = gd.getNextNumber() / 100.0;
        Prefs.set((String)"QuickPALM.symmetry", (double)this.symmetry);
        this.pthrsh = gd.getNextNumber() / 100.0;
        Prefs.set((String)"QuickPALM.lthreshold", (double)(this.pthrsh * 100.0));
        this.maxpart = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.maxiter", (int)this.maxpart);
        this.threads = (int)gd.getNextNumber();
        Prefs.set((String)"QuickPALM.nthreads", (int)this.threads);
        return true;
    }
}

