/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.audioengines;

import org.scijava.java3d.AudioDevice;
import org.scijava.java3d.PhysicalEnvironment;
import org.scijava.java3d.Sound;

public abstract class AudioEngine
implements AudioDevice {
    int fileDescriptor;
    int audioPlaybackType = 0;
    float distanceToSpeaker = 0.0f;
    float angleOffsetToSpeaker = 0.0f;
    int channelsAvailable = 8;
    int totalChannels = 8;

    public AudioEngine(PhysicalEnvironment physicalEnvironment) {
        physicalEnvironment.setAudioDevice(this);
    }

    @Override
    public abstract boolean initialize();

    @Override
    public abstract boolean close();

    @Override
    public void setAudioPlaybackType(int type) {
        this.audioPlaybackType = type;
    }

    @Override
    public int getAudioPlaybackType() {
        return this.audioPlaybackType;
    }

    @Override
    public void setCenterEarToSpeaker(float distance) {
        this.distanceToSpeaker = distance;
    }

    @Override
    public float getCenterEarToSpeaker() {
        return this.distanceToSpeaker;
    }

    @Override
    public void setAngleOffsetToSpeaker(float angle) {
        this.angleOffsetToSpeaker = angle;
    }

    @Override
    public float getAngleOffsetToSpeaker() {
        return this.angleOffsetToSpeaker;
    }

    @Override
    public int getTotalChannels() {
        return this.totalChannels;
    }

    @Override
    public int getChannelsAvailable() {
        return this.channelsAvailable;
    }

    @Override
    public int getChannelsUsedForSound(Sound sound) {
        if (sound != null) {
            return sound.getNumberOfChannelsUsed();
        }
        return -1;
    }
}

