/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.analysis;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.io.DirectoryChooser;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.Mesh_Maker;
import ij3d.Utils;
import ini.trakem2.Project;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Line3D;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Worker;
import ini.trakem2.vector.Editions;
import ini.trakem2.vector.VectorString;
import ini.trakem2.vector.VectorString3D;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import mpi.fruitfly.general.MultiThreading;
import mpicbg.models.AffineModel3D;
import mpicbg.models.MovingLeastSquaresTransform;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class Compare {
    public static final int TRANS_ROT = 0;
    public static final int TRANS_ROT_SCALE = 1;
    public static final int TRANS_ROT_SCALE_SHEAR = 2;
    public static final int LEVENSHTEIN = 0;
    public static final int DISSIMILARITY = 1;
    public static final int AVG_PHYS_DIST = 2;
    public static final int MEDIAN_PHYS_DIST = 3;
    public static final int CUM_PHYST_DIST = 4;
    public static final int STD_DEV = 5;
    public static final int COMBINED = 6;
    public static final int PROXIMITY = 7;
    public static final int PROXIMITY_MUT = 8;
    public static final int STD_DEV_ALL = 9;
    public static final int COMBINED_SCORE_INDICES = 10;
    private static final String[] distance_types = new String[]{"Levenshtein", "Dissimilarity", "Average physical distance", "Median physical distance", "Cummulative physical distance", "Standard deviation of correspondences only", "Combined SLM", "Proximity", "Proximity of mutation pairs", "Standard deviation of all pairs", "Combined score indices"};
    public static final double[] W = new double[]{0.3238955445631255, -0.001738441643315311, -0.03506078734289302, 0.7148869480636044};

    private Compare() {
    }

    private static int[] findFirstXYZAxes(String[] preset, ArrayList<ZDisplayable> pipes, String[] pipe_names) {
        int[] s = new int[]{-1, -1, -1};
        int next = 0;
        for (ZDisplayable zd : pipes) {
            pipe_names[next] = zd.getProject().getShortMeaningfulTitle(zd);
            if (-1 != s[0] && -1 != s[1] && -1 != s[2]) {
                ++next;
                continue;
            }
            String name = pipe_names[next].toLowerCase();
            if (-1 != name.indexOf(preset[0])) {
                s[0] = next;
            } else if (-1 != name.indexOf(preset[1])) {
                s[1] = next;
            } else if (-1 != name.indexOf(preset[2])) {
                s[2] = next;
            }
            ++next;
        }
        return s;
    }

    public static Object[] obtainOrigin(Line3D[] axes, int transform_type, Vector3d[] o_ref) {
        int i;
        Calibration cal;
        VectorString3D[] vs = new VectorString3D[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            vs[i2] = axes[i2].asVectorString3D();
        }
        Calibration calibration = cal = null != axes[0].getLayerSet() ? axes[0].getLayerSet().getCalibration() : null;
        if (null != cal) {
            for (int i3 = 0; i3 < 3; ++i3) {
                vs[i3].calibrate(cal);
            }
        }
        double delta = 0.0;
        for (i = 0; i < 3; ++i) {
            delta += vs[i].getAverageDelta();
        }
        delta /= 3.0;
        for (i = 0; i < 3; ++i) {
            vs[i].resample(delta);
        }
        Vector3d[] o = Compare.createOrigin(vs[0], vs[1], vs[2], transform_type, o_ref);
        return new Object[]{vs, o};
    }

    public static Vector3d[] createOrigin(VectorString3D x, VectorString3D y, VectorString3D z, int transform_type) {
        ini.trakem2.utils.Utils.log2("WARNING TODO shouldn't be using this method ever");
        return Compare.createOrigin(x, y, z, transform_type, null);
    }

    public static Vector3d[] createOrigin(VectorString3D x, VectorString3D y, VectorString3D z, int transform_type, Vector3d[] o_ref) {
        VectorString3D[] vs = new VectorString3D[]{z, y, x};
        ArrayList<Point3d> ps = new ArrayList<Point3d>();
        int[] dir = new int[]{1, 1, 1};
        for (int i = 0; i < vs.length; ++i) {
            for (int k = i + 1; k < vs.length; ++k) {
                double min_dist = Double.MAX_VALUE;
                int ia = 0;
                int ib = 0;
                for (int a = 0; a < vs[i].length(); ++a) {
                    for (int b = 0; b < vs[k].length(); ++b) {
                        double d = VectorString3D.distance((VectorString3D)vs[i], (int)a, (VectorString3D)vs[k], (int)b);
                        if (!(d < min_dist)) continue;
                        min_dist = d;
                        ia = a;
                        ib = b;
                    }
                }
                ps.add(new Point3d((vs[i].getPoint(0, ia) + vs[k].getPoint(0, ib)) / 2.0, (vs[i].getPoint(1, ia) + vs[k].getPoint(1, ib)) / 2.0, (vs[i].getPoint(2, ia) + vs[k].getPoint(2, ib)) / 2.0));
                if (ia > vs[i].length() / 2) {
                    dir[i] = -1;
                }
                if (ib <= vs[k].length() / 2) continue;
                dir[k] = -1;
            }
        }
        Vector3d origin = new Vector3d();
        int len = ps.size();
        for (Point3d p : ps) {
            p.x /= (double)len;
            p.y /= (double)len;
            p.z /= (double)len;
        }
        for (Point3d p : ps) {
            origin.add((Tuple3d)p);
        }
        Vector3d vz = z.sumVector();
        Vector3d vy = y.sumVector();
        Vector3d vx = x.sumVector();
        vz.scale((double)dir[0]);
        vy.scale((double)dir[1]);
        vx.scale((double)dir[2]);
        Vector3d v1 = vx;
        Vector3d v2 = vy;
        Vector3d v3 = vz;
        if (0 == transform_type || 1 == transform_type) {
            Vector3d vc_medial = new Vector3d();
            vc_medial.cross(vz, vy);
            Vector3d vc_dorsal = new Vector3d();
            vc_dorsal.cross(vz, vc_medial);
            Vector3d vc_dor = new Vector3d(vc_dorsal);
            vc_dor.add((Tuple3d)vy);
            if (vc_dor.length() < vy.length()) {
                vc_dorsal.scale(-1.0);
                ini.trakem2.utils.Utils.log("Mirroring Y axis");
            }
            v1 = vc_medial;
            v2 = vc_dorsal;
            if (0 == transform_type && null != o_ref) {
                v1.normalize();
                v1.scale(o_ref[0].length());
                v2.normalize();
                v2.scale(o_ref[1].length());
                v3.normalize();
                v3.scale(o_ref[2].length());
            }
        }
        return new Vector3d[]{v1, v2, v3, origin};
    }

    private static VectorString3D makeVSFromP(Vector3d p, Vector3d origin) throws Exception {
        int i;
        double[] x1 = new double[20];
        double[] y1 = new double[20];
        double[] z1 = new double[20];
        double K = 10.0;
        x1[0] = p.x * 10.0;
        y1[0] = p.y * 10.0;
        z1[0] = p.z * 10.0;
        for (i = 1; i < x1.length; ++i) {
            x1[i] = p.x * 10.0 + x1[i - 1];
            y1[i] = p.y * 10.0 + y1[i - 1];
            z1[i] = p.z * 10.0 + z1[i - 1];
        }
        i = 0;
        while (i < x1.length) {
            int n = i;
            x1[n] = x1[n] + origin.x;
            int n2 = i;
            y1[n2] = y1[n2] + origin.y;
            int n3 = i++;
            z1[n3] = z1[n3] + origin.z;
        }
        return new VectorString3D(x1, y1, z1, false);
    }

    public static void testCreateOrigin(LayerSet ls, VectorString3D vs1, VectorString3D vs2, VectorString3D vs3) {
        try {
            int i;
            double delta = (vs1.getAverageDelta() + vs2.getAverageDelta() + vs3.getAverageDelta()) / 3.0;
            vs1.resample(delta);
            vs2.resample(delta);
            vs3.resample(delta);
            Vector3d[] o = Compare.createOrigin(vs1, vs2, vs3, 0);
            Display3D.addMesh(ls, Compare.makeVSFromP(o[0], o[3]), "v1", Color.green);
            Display3D.addMesh(ls, Compare.makeVSFromP(o[1], o[3]), "v2", Color.orange);
            Display3D.addMesh(ls, Compare.makeVSFromP(o[2], o[3]), "v3", Color.red);
            System.out.println("v1:" + o[0]);
            System.out.println("v2:" + o[1]);
            System.out.println("v3:" + o[2]);
            Matrix3d rotm = new Matrix3d(o[0].x, o[1].x, o[2].x, o[0].y, o[1].y, o[2].y, o[0].z, o[1].z, o[2].z);
            Transform3D rot = new Transform3D(rotm, new Vector3d(), 1.0);
            rot.invert();
            System.out.println("o3: " + o[3].toString());
            for (i = 0; i < 3; ++i) {
                o[i].x += o[3].x;
                o[i].y += o[3].y;
                o[i].z += o[3].z;
            }
            for (i = 0; i < 3; ++i) {
                o[i].sub((Tuple3d)o[3]);
                rot.transform(o[i]);
            }
            System.out.println("v1:" + o[0]);
            System.out.println("v2:" + o[1]);
            System.out.println("v3:" + o[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Chain> createPipeChains(ProjectThing root_pt, LayerSet ls) throws Exception {
        return Compare.createPipeChains(root_pt, ls, null);
    }

    public static ArrayList<Chain> createPipeChains(ProjectThing root_pt, LayerSet ls, String regex_exclude) throws Exception {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        Pattern exclude = null;
        if (null != regex_exclude) {
            exclude = Pattern.compile(regex_exclude, 32);
        }
        Compare.appendAndFork(root_pt, null, null, chains, ls, exclude);
        return chains;
    }

    private static void appendAndFork(ProjectThing parent, Chain chain, HashSet<ProjectThing> hs_c_done, ArrayList<Chain> chains, LayerSet ls, Pattern exclude) throws Exception {
        if (null != exclude && exclude.matcher(parent.getTitle()).matches()) {
            ini.trakem2.utils.Utils.logAll("Excluding node " + parent + " with title " + parent.getTitle() + ", and all its children nodes.");
            return;
        }
        ArrayList<ProjectThing> children = parent.getChildren();
        if (null == children) {
            return;
        }
        if (null == hs_c_done) {
            hs_c_done = new HashSet();
        }
        for (ProjectThing child : children) {
            if (hs_c_done.contains(child)) continue;
            if (null != exclude && exclude.matcher(child.getTitle()).matches()) {
                ini.trakem2.utils.Utils.log2("Excluding child " + child + " with title " + child.getTitle());
                continue;
            }
            hs_c_done.add(child);
            if (child.getObject() instanceof Line3D) {
                Line3D pipe = (Line3D)child.getObject();
                if (!pipe.getLayerSet().equals(ls) || pipe.length() < 2) continue;
                if (null == chain) {
                    chain = new Chain(pipe);
                    chains.add(chain);
                } else {
                    chain.append(pipe);
                }
                boolean first = true;
                Chain base = chain.duplicate();
                for (ProjectThing c : children) {
                    Chain ca;
                    ArrayList<Line3D> child_pipes;
                    if (hs_c_done.contains(c) || (child_pipes = c.findChildrenOfType(Line3D.class)).size() <= 0) continue;
                    if (first) {
                        ca = chain;
                        first = false;
                    } else {
                        ca = base.duplicate();
                        chains.add(ca);
                    }
                    Compare.appendAndFork(c, ca, hs_c_done, chains, ls, exclude);
                }
                continue;
            }
            if (0 == child.findChildrenOfType(Line3D.class).size()) {
                chain = null;
            }
            Compare.appendAndFork(child, chain, hs_c_done, chains, ls, exclude);
        }
    }

    private static void sortMatches(List<ChainMatch> list, int distance_type_1, int distance_type_2, int min_number) {
        boolean debug = false;
        if (10 == distance_type_1) {
            int[] params = new int[]{0, 2, 4, 5, 7};
            float[] indices = new float[list.size()];
            Object ind = null;
            for (int i = 0; i < params.length; ++i) {
                ArrayList<ChainMatch> li = new ArrayList<ChainMatch>(list);
                Collections.sort(li, new ChainMatchComparator(params[i]));
                int k = 0;
                while (k < indices.length) {
                    ChainMatch cm = list.get(k);
                    int index = li.indexOf(cm);
                    int n = k++;
                    indices[n] = indices[n] + (float)index;
                }
            }
            Object[] cm = list.toArray(new ChainMatch[0]);
            M.quicksort(indices, cm);
            list.clear();
            for (int i = 0; i < cm.length; ++i) {
                list.add((ChainMatch)cm[i]);
            }
            return;
        }
        Collections.sort(list, new ChainMatchComparator(distance_type_1));
        if (9 == distance_type_2) {
            return;
        }
        double roof = list.get((int)0).phys_dist * 1.5;
        int count = 0;
        Iterator<ChainMatch> it = list.iterator();
        while (it.hasNext()) {
            ChainMatch cm = it.next();
            if (!(cm.phys_dist > roof) || ++count <= min_number) continue;
            it.remove();
        }
        Collections.sort(list, new ChainMatchComparator(distance_type_2));
    }

    protected static final Object[] findBestMatch(VectorString3D vs1, VectorString3D vs2, double delta, boolean skip_ends, int max_mut, float min_chunk) {
        return Compare.findBestMatch(vs1, vs2, delta, skip_ends, max_mut, min_chunk, 6, false, false);
    }

    protected static final Object[] findBestMatch(VectorString3D vs1, VectorString3D vs2, double delta, boolean skip_ends, int max_mut, float min_chunk, int distance_type, boolean direct, boolean substring_matching) {
        return Compare.findBestMatch(vs1, vs2, delta, skip_ends, max_mut, min_chunk, 6, direct, substring_matching, 1.1, 1.1, 1.0);
    }

    public static final Object[] findBestMatch(VectorString3D vs1, VectorString3D vs2, double delta, boolean skip_ends, int max_mut, float min_chunk, int distance_type, boolean direct, boolean substring_matching, double wi, double wd, double wm) {
        if (substring_matching) {
            VectorString3D shorter = vs1.length() < vs2.length() ? vs1 : vs2;
            VectorString3D longer = vs1 == shorter ? vs2 : vs1;
            int shorter_len = shorter.length();
            int max_offset = longer.length() - shorter_len + 1;
            Object[] best = null;
            for (int k = 0; k < max_offset; ++k) {
                double dbest;
                Object[] ob;
                VectorString3D longer_sub = longer.substring(k, k + shorter_len);
                Object[] objectArray = ob = direct ? Compare.matchDirect(shorter, longer_sub, delta, skip_ends, max_mut, min_chunk, distance_type, wi, wd, wm) : Compare.matchFwdRev(shorter, longer_sub, delta, skip_ends, max_mut, min_chunk, distance_type, wi, wd, wm);
                if (null == best) {
                    best = ob;
                    continue;
                }
                double dob = (Double)ob[1];
                if (!(dob < (dbest = ((Double)best[1]).doubleValue()))) continue;
                best = ob;
            }
            return best;
        }
        if (direct) {
            return Compare.matchDirect(vs1, vs2, delta, skip_ends, max_mut, min_chunk, distance_type, wi, wd, wm);
        }
        return Compare.matchFwdRev(vs1, vs2, delta, skip_ends, max_mut, min_chunk, distance_type, wi, wd, wm);
    }

    public static final double score(double seq_sim, double levenshtein, double median_phys_dist, double[] w) {
        return seq_sim * w[0] + levenshtein * w[1] + median_phys_dist * w[2] + w[3];
    }

    private static final double getScore(Editions ed, boolean skip_ends, int max_mut, float min_chunk, int distance_type) {
        switch (distance_type) {
            case 0: {
                return ed.getDistance();
            }
            case 1: {
                return 1.0 - ed.getSimilarity(skip_ends, max_mut, min_chunk);
            }
            case 2: {
                return ed.getPhysicalDistance(skip_ends, max_mut, min_chunk, true);
            }
            case 3: {
                return ed.getStatistics(skip_ends, max_mut, min_chunk, false)[3];
            }
            case 4: {
                return ed.getPhysicalDistance(skip_ends, max_mut, min_chunk, false);
            }
            case 5: {
                return ed.getStdDev(skip_ends, max_mut, min_chunk);
            }
            case 9: {
                return ed.getStatistics(skip_ends, max_mut, min_chunk, false)[2];
            }
            case 6: {
                return 1.0 / Compare.score(ed.getSimilarity(), ed.getDistance(), ed.getStatistics(skip_ends, max_mut, min_chunk, false)[3], W);
            }
            case 7: {
                return ed.getStatistics(skip_ends, max_mut, min_chunk, false)[7];
            }
            case 8: {
                return ed.getStatistics(skip_ends, max_mut, min_chunk, false)[8];
            }
        }
        return Double.NaN;
    }

    private static final Object[] matchDirect(VectorString3D vs1, VectorString3D vs2, double delta, boolean skip_ends, int max_mut, float min_chunk, int distance_type, double wi, double wd, double wm) {
        Object[] objectArray;
        Editions ed2;
        double score2;
        Editions ed1 = new Editions((VectorString)vs1, (VectorString)vs2, delta, false, wi, wd, wm);
        double score1 = Compare.getScore(ed1, skip_ends, max_mut, min_chunk, distance_type);
        if (score1 < (score2 = Compare.getScore(ed2 = new Editions((VectorString)vs2, (VectorString)vs1, delta, false, wi, wd, wm), skip_ends, max_mut, min_chunk, distance_type))) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = ed1;
            objectArray = objectArray2;
            objectArray2[1] = score1;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = ed2;
            objectArray = objectArray3;
            objectArray3[1] = score2;
        }
        return objectArray;
    }

    private static final Object[] matchFwdRev(VectorString3D vs1, VectorString3D vs2, double delta, boolean skip_ends, int max_mut, float min_chunk, int distance_type, double wi, double wd, double wm) {
        VectorString3D vs1rev = vs1.makeReversedCopy();
        VectorString3D vs2rev = vs2.makeReversedCopy();
        Editions[] ed = new Editions[]{new Editions((VectorString)vs1, (VectorString)vs2, delta, false, wi, wd, wm), new Editions((VectorString)vs1rev, (VectorString)vs2rev, delta, false, wi, wd, wm), new Editions((VectorString)vs1, (VectorString)vs2rev, delta, false, wi, wd, wm), new Editions((VectorString)vs1rev, (VectorString)vs2, delta, false, wi, wd, wm)};
        double best_score = Double.MAX_VALUE;
        Editions best_ed = null;
        for (int i = 0; i < ed.length; ++i) {
            double score = Compare.getScore(ed[i], skip_ends, max_mut, min_chunk, distance_type);
            if (!(score < best_score)) continue;
            best_ed = ed[i];
            best_score = score;
        }
        try {
            double score_center;
            Editions ed_center = best_ed.recreateFromCenter(max_mut);
            if (null != ed_center && (score_center = Compare.getScore(ed_center, skip_ends, max_mut, min_chunk, distance_type)) < best_score) {
                best_ed = ed_center;
                best_score = score_center;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[]{best_ed, new Double(best_score)};
    }

    public static final Object[] gatherChains(Project[] p, CATAParameters cp) throws Exception {
        return Compare.gatherChains(p, cp, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final Object[] gatherChains(Project[] p, CATAParameters cp, String[] ignore) throws Exception {
        String regex_exclude = null;
        if (null != ignore) {
            StringBuilder sb = new StringBuilder();
            for (String string : ignore) {
                sb.append("(.*").append(string).append(".*)|");
            }
            sb.setLength(sb.length() - 1);
            regex_exclude = sb.toString();
        }
        ini.trakem2.utils.Utils.logAll("Compare/gatherChains: using ignore string: " + regex_exclude);
        ini.trakem2.utils.Utils.logAll("Compare/gatherChains: using regex: " + cp.regex);
        ArrayList[] p_chains = new ArrayList[p.length];
        ArrayList chains = new ArrayList();
        for (int i = 0; i < p.length; ++i) {
            if (null == cp.regex) {
                p_chains[i] = Compare.createPipeChains(p[i].getRootProjectThing(), p[i].getRootLayerSet(), regex_exclude);
            } else {
                for (ProjectThing projectThing : p[i].getRootProjectThing().findChildren(cp.regex, regex_exclude, true)) {
                    ArrayList<Chain> ac = Compare.createPipeChains(projectThing, p[i].getRootLayerSet(), regex_exclude);
                    if (null == p_chains[i]) {
                        p_chains[i] = ac;
                        continue;
                    }
                    p_chains[i].addAll(ac);
                }
                if (null == p_chains[i]) {
                    p_chains[i] = new ArrayList();
                }
            }
            chains.addAll(p_chains[i]);
            Calibration cal = p[i].getRootLayerSet().getCalibrationCopy();
            for (Chain chain : p_chains[i]) {
                chain.vs.calibrate(cal);
            }
        }
        int n_chains = chains.size();
        if (4 == cp.transform_type) {
            if (0.0 == cp.delta) {
                for (Chain chain : chains) {
                    cp.delta += chain.vs.getAverageDelta() / (double)n_chains;
                }
            }
            ini.trakem2.utils.Utils.log2("Using delta: " + cp.delta);
            for (Chain chain : chains) {
                chain.vs.resample(cp.delta, cp.with_source);
                chain.vs.relative();
            }
        } else {
            if (3 == cp.transform_type) {
                ini.trakem2.utils.Utils.log2("Moving Least Squares Registration based on common fiducial points");
                HashMap<Project, Map<String, Tuple3d>> fiducials = new HashMap<Project, Map<String, Tuple3d>>();
                for (Project pr : p) {
                    HashSet<ProjectThing> fids = pr.getRootProjectThing().findChildrenOfTypeR("fiducial_points");
                    if (null == fids || 0 == fids.size()) {
                        ini.trakem2.utils.Utils.log("No fiducial points found in project: " + pr);
                        continue;
                    }
                    fiducials.put(pr, Compare.extractPoints((ProjectThing)fids.iterator().next()));
                }
                if (!fiducials.isEmpty()) {
                    ArrayList<VectorString3D> arrayList = new ArrayList<VectorString3D>();
                    Calibration cal2 = p[0].getRootLayerSet().getCalibrationCopy();
                    for (Chain chain : chains) {
                        Project pr = chain.pipes.get(0).getProject();
                        if (pr == p[0]) continue;
                        arrayList.clear();
                        arrayList.add(chain.vs);
                        chain.vs = Compare.transferVectorStrings(arrayList, (Map)fiducials.get(pr), (Map)fiducials.get(p[0])).get(0);
                        chain.vs.setCalibration(cal2);
                    }
                }
            } else if (cp.transform_type < 3) {
                void var8_29;
                Vector3d[][] o = new Vector3d[p.length][];
                boolean bl = false;
                while (var8_29 < p.length) {
                    ArrayList<ZDisplayable> pipes = p[var8_29].getRootLayerSet().getZDisplayables(Line3D.class, true);
                    String[] pipe_names = new String[pipes.size()];
                    for (int k = 0; k < pipes.size(); ++k) {
                        pipe_names[k] = p[var8_29].getMeaningfulTitle(pipes.get(k));
                    }
                    int[] s = Compare.findFirstXYZAxes(cp.preset, pipes, pipe_names);
                    if (-1 == s[0] || -1 == s[1] || -1 == s[2]) {
                        ini.trakem2.utils.Utils.log("Can't find axes for project " + p[var8_29]);
                        o = null;
                        return null;
                    }
                    Object[] pack = Compare.obtainOrigin(new Line3D[]{(Line3D)((Object)pipes.get(s[0])), (Line3D)((Object)pipes.get(s[1])), (Line3D)((Object)pipes.get(s[2]))}, cp.transform_type, o[0]);
                    o[var8_29] = (Vector3d[])pack[1];
                    ++var8_29;
                }
                Transform3D transform3D = Compare.createTransform(o[0]);
                for (int i = 1; i < p.length; ++i) {
                    Vector3d trans = new Vector3d(-o[i][3].x, -o[i][3].y, -o[i][3].z);
                    Transform3D M_query = Compare.createTransform(o[i]);
                    Transform3D T = new Transform3D(transform3D);
                    T.mulInverse(M_query);
                    for (Chain chain : p_chains[i]) {
                        chain.vs.transform(T);
                    }
                }
            }
            if (0.0 == cp.delta) {
                for (Chain chain : chains) {
                    cp.delta += chain.vs.getAverageDelta() / (double)n_chains;
                }
            }
            ini.trakem2.utils.Utils.log2("Using delta: " + cp.delta);
            for (Chain chain : chains) {
                chain.vs.resample(cp.delta, cp.with_source);
            }
        }
        return new Object[]{chains, p_chains};
    }

    public static Bureaucrat compareAllToAll(boolean to_file, String regex, String[] ignore, Project[] projects) {
        return Compare.compareAllToAll(to_file, regex, ignore, projects, false, false, 0, null);
    }

    public static Bureaucrat compareAllToAll(final boolean to_file, final String regex, final String[] ignore, Project[] projects, final boolean crop, final boolean from_end, final int max_n_elements, final String outgroup) {
        final Project[] p = null == projects ? Project.getProjects().toArray(new Project[0]) : projects;
        Worker worker = new Worker("Comparing all to all"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                try {
                    int i;
                    int next;
                    CATAParameters cp = new CATAParameters();
                    if (!cp.setup(to_file, regex, false, false)) {
                        this.finishedWorking();
                        return;
                    }
                    String filename = null;
                    String dir = null;
                    if (to_file) {
                        SaveDialog sd = new SaveDialog("Save matrix", OpenDialog.getDefaultDirectory(), null, ".csv");
                        filename = sd.getFileName();
                        if (null == filename) {
                            this.finishedWorking();
                            return;
                        }
                        dir = sd.getDirectory().replace('\\', '/');
                        if (!dir.endsWith("/")) {
                            dir = dir + "/";
                        }
                    }
                    Object[] ob = Compare.gatherChains(p, cp, ignore);
                    ArrayList chains = (ArrayList)ob[0];
                    ArrayList[] p_chains = (ArrayList[])ob[1];
                    ob = null;
                    if (null == chains) {
                        this.finishedWorking();
                        return;
                    }
                    int n_chains = chains.size();
                    if (crop) {
                        for (Chain chain : chains) {
                            if (from_end) {
                                int start = chain.vs.length() - max_n_elements;
                                if (start <= 0) continue;
                                chain.vs = chain.vs.substring(start, chain.vs.length());
                                chain.vs.resample(cp.delta, cp.with_source);
                                continue;
                            }
                            if (max_n_elements >= chain.vs.length()) continue;
                            chain.vs = chain.vs.substring(0, max_n_elements);
                            chain.vs.resample(cp.delta, cp.with_source);
                        }
                    }
                    VectorString3D[] vs = new VectorString3D[n_chains];
                    for (int i2 = 0; i2 < n_chains; ++i2) {
                        vs[i2] = ((Chain)chains.get((int)i2)).vs;
                    }
                    float[][] scores = Compare.scoreAllToAll(vs, cp.distance_type, cp.delta, cp.skip_ends, cp.max_mut, cp.min_chunk, cp.direct, cp.substring_matching, this);
                    if (null == scores) {
                        this.finishedWorking();
                        return;
                    }
                    this.result = new Object[]{scores, chains};
                    if (!to_file) {
                        this.finishedWorking();
                        return;
                    }
                    File f = new File(dir + filename);
                    OutputStreamWriter dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f)), "8859_1");
                    if (cp.normalize) {
                        int j;
                        int i3;
                        float max = 0.0f;
                        for (i3 = 0; i3 < scores.length; ++i3) {
                            for (j = i3; j < scores[0].length; ++j) {
                                if (!(scores[i3][j] > max)) continue;
                                max = scores[i3][j];
                            }
                        }
                        for (i3 = 0; i3 < scores.length; ++i3) {
                            for (j = i3; j < scores[0].length; ++j) {
                                float[] fArray = scores[j];
                                int n = i3;
                                float f2 = fArray[n] / max;
                                fArray[n] = f2;
                                scores[i3][j] = f2;
                            }
                        }
                    }
                    if (cp.format.equals(cp.formats[0])) {
                        try {
                            StringBuffer[] titles = new StringBuffer[n_chains];
                            next = 0;
                            for (i = 0; i < p.length; ++i) {
                                String prefix = ini.trakem2.utils.Utils.getCharacter(i + 1);
                                dos.write("\"\"");
                                for (Chain chain : p_chains[i]) {
                                    dos.write(",");
                                    titles[next] = new StringBuffer().append('\"').append(prefix).append(' ').append(chain.getCellTitle()).append('\"');
                                    dos.write(titles[next].toString());
                                    ++next;
                                }
                            }
                            dos.write("\n");
                            for (i = 0; i < n_chains; ++i) {
                                StringBuffer line = new StringBuffer();
                                line.append(titles[i]);
                                for (int j = 0; j < n_chains; ++j) {
                                    line.append(',').append(scores[i][j]);
                                }
                                line.append('\n');
                                dos.write(line.toString());
                            }
                            dos.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (cp.format.equals(cp.formats[1])) {
                        try {
                            StringBuffer sb = new StringBuffer("<?xml version=\"1.0\"?>\n<!DOCTYPE ggobidata SYSTEM \"ggobi.dtd\">\n");
                            sb.append("<ggobidata count=\"2\">\n");
                            sb.append("<data name=\"Pipe Chains\">\n");
                            sb.append("<description />\n");
                            sb.append("<variables count=\"0\">\n</variables>\n");
                            sb.append("<records count=\"").append(chains.size()).append("\" glyph=\"fr 1\" color=\"3\">\n");
                            next = 0;
                            for (i = 0; i < p.length; ++i) {
                                String prefix = ini.trakem2.utils.Utils.getCharacter(i + 1);
                                String color = new StringBuffer("color=\"").append(i + 1).append('\"').toString();
                                for (Chain chain : p_chains[i]) {
                                    sb.append("<record id=\"").append(next + 1).append("\" label=\"").append(prefix).append(' ').append(chain.getCellTitle()).append("\" ").append(color).append("></record>\n");
                                    ++next;
                                }
                            }
                            sb.append("</records>\n</data>\n");
                            sb.append("<data name=\"distances\">\n");
                            sb.append("<description />\n");
                            sb.append("<variables count=\"1\">\n<realvariable name=\"D\" />\n</variables>\n");
                            sb.append("<records count=\"").append(n_chains * (n_chains - 1)).append("\" glyph=\"fr 1\" color=\"0\">\n");
                            for (i = 0; i < n_chains; ++i) {
                                for (int j = 0; j < n_chains; ++j) {
                                    if (i == j) continue;
                                    sb.append("<record source=\"").append(i + 1).append("\" destination=\"").append(j + 1).append("\">").append(scores[i][j]).append("</record>\n");
                                }
                            }
                            sb.append("</records>\n</data>\n");
                            sb.append("</ggobidata>");
                            dos.write(sb.toString());
                            dos.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (cp.format.equals(cp.formats[2])) {
                        try {
                            ArrayList<Project> projects = new ArrayList<Project>();
                            for (Chain chain : chains) {
                                Project p2 = chain.getRoot().getProject();
                                if (projects.contains(p2)) continue;
                                projects.add(p2);
                            }
                            HashSet names = new HashSet();
                            StringBuffer sb = new StringBuffer();
                            sb.append(scores.length).append('\n');
                            dos.write(sb.toString());
                            AtomicInteger ids = new AtomicInteger(0);
                            File ftags = new File(dir + filename + ".tags");
                            OutputStreamWriter dostags = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(ftags)), "8859_1");
                            for (int i4 = 0; i4 < scores.length; ++i4) {
                                sb.setLength(0);
                                int id = ids.incrementAndGet();
                                String sid = ini.trakem2.utils.Utils.getCharacter(id);
                                String name = ((Chain)chains.get(i4)).getShortCellTitle();
                                if (sid.length() > 10) {
                                    ini.trakem2.utils.Utils.log2("Ignoring " + name + " : id longer than 10 chars: " + id);
                                    continue;
                                }
                                boolean k = true;
                                String project_name = "";
                                if (projects.size() > 1) {
                                    project_name = ini.trakem2.utils.Utils.getCharacter(projects.indexOf(((Chain)chains.get(i4)).getRoot().getProject()) + 1).toLowerCase();
                                    name = project_name + name;
                                }
                                dostags.write(sid + '\t' + name + '\n');
                                if (null != outgroup && -1 != name.indexOf(outgroup)) {
                                    ini.trakem2.utils.Utils.logAll("Outgroup 0-based index is " + id + ", with id " + sid + ", with name " + name);
                                }
                                int len = 12;
                                sb.append(sid);
                                for (int j = 12 - sid.length(); j > 0; --j) {
                                    sb.append(' ');
                                }
                                int count = 0;
                                for (int j = 0; j < scores[0].length; ++j) {
                                    sb.append(' ').append(scores[i4][j]);
                                    if (7 != ++count || j >= scores[0].length - 1) continue;
                                    sb.append('\n');
                                    count = 0;
                                    while (++count < 12) {
                                        sb.append(' ');
                                    }
                                    sb.append(' ');
                                    count = 0;
                                }
                                sb.append('\n');
                                dos.write(sb.toString());
                            }
                            dos.flush();
                            dostags.flush();
                            dostags.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    dos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, p);
    }

    public static float[][] scoreAllToAll(final VectorString3D[] vs, final int distance_type, final double delta, final boolean skip_ends, final int max_mut, final float min_chunk, final boolean direct, final boolean substring_matching, final Worker worker) {
        final float[][] scores = new float[vs.length][vs.length];
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = MultiThreading.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int i = ai.getAndIncrement();
                    while (i < vs.length) {
                        VectorString3D vs1 = vs[i];
                        for (int j = i + 1; j < vs.length; ++j) {
                            if (null != worker && worker.hasQuitted()) {
                                return;
                            }
                            Object[] ob = Compare.findBestMatch(vs[i], vs[j], delta, skip_ends, max_mut, min_chunk, distance_type, direct, substring_matching);
                            Editions ed = (Editions)ob[0];
                            scores[i][j] = (float)Compare.getScore(ed, skip_ends, max_mut, min_chunk, distance_type);
                            scores[j][i] = scores[i][j];
                        }
                        i = ai.getAndIncrement();
                    }
                }
            };
        }
        MultiThreading.startAndJoin(threads);
        if (null != worker && worker.hasQuitted()) {
            return null;
        }
        return scores;
    }

    public static Transform3D createTransform(Vector3d[] o) {
        return new Transform3D(new Matrix4d(o[0].x, o[1].x, o[2].x, o[3].x, o[0].y, o[1].y, o[2].y, o[3].y, o[0].z, o[1].z, o[2].z, o[3].z, 0.0, 0.0, 0.0, 1.0));
    }

    public static Bureaucrat variabilityAnalysis(Project reference_project, final String regex, final String[] ignore, final boolean show_cata_dialog, final boolean generate_plots, final boolean show_plots, final String plot_dir_, final boolean show_3D, final boolean show_condensed_3D, final boolean show_sources_3D, final Map<Project, Color> sources_color_table, final boolean show_envelope_3D, final float envelope_alpha, final double delta_envelope, final int envelope_type, final boolean show_axes_3D, final boolean heat_map, final Map<String, VectorString3D> map_condensed, Project[] projects) {
        Project[] p;
        Project[] projectArray = p = null == projects ? Project.getProjects().toArray(new Project[0]) : projects;
        if (null != reference_project && reference_project != p[0]) {
            for (int i = 0; i < p.length; ++i) {
                if (reference_project != p[i]) continue;
                p[i] = p[0];
                p[0] = reference_project;
                break;
            }
        }
        Worker worker = new Worker("Comparing all to all"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                try {
                    ini.trakem2.utils.Utils.log2("Asking for CATAParameters...");
                    CATAParameters cp = new CATAParameters();
                    cp.regex = regex;
                    cp.delta_envelope = delta_envelope;
                    cp.envelope_type = envelope_type;
                    if (show_cata_dialog && !cp.setup(false, regex, true, true)) {
                        this.finishedWorking();
                        return;
                    }
                    cp.with_source = true;
                    HashMap<String, Display3D> results = new HashMap<String, Display3D>();
                    String plot_dir = plot_dir_;
                    if (generate_plots && !show_plots) {
                        DirectoryChooser dc;
                        if (null == plot_dir && null == (plot_dir = (dc = new DirectoryChooser("Choose plots directory")).getDirectory())) {
                            this.finishedWorking();
                            return;
                        }
                        if (IJ.isWindows()) {
                            plot_dir = plot_dir.replace('\\', '/');
                        }
                        if (!plot_dir.endsWith("/")) {
                            plot_dir = plot_dir + "/";
                        }
                    }
                    ini.trakem2.utils.Utils.log2("Gathering chains...");
                    Object[] ob = Compare.gatherChains(p, cp, ignore);
                    ArrayList chains = (ArrayList)ob[0];
                    ArrayList[] p_chains = (ArrayList[])ob[1];
                    ob = null;
                    if (null == chains) {
                        this.finishedWorking();
                        return;
                    }
                    ini.trakem2.utils.Utils.log2("Collecting bundles...");
                    HashMap<Project, HashMap<String, VectorString3D>> axes = new HashMap<Project, HashMap<String, VectorString3D>>();
                    HashMap<String, ArrayList<Chain>> bundles = new HashMap<String, ArrayList<Chain>>();
                    for (Chain chain : chains) {
                        String string = chain.getCellTitle();
                        String t = string.toLowerCase();
                        if (0 == t.indexOf(91) || 0 == t.indexOf(35)) continue;
                        ini.trakem2.utils.Utils.log("Accepting " + string);
                        String string2 = string.substring(0, string.indexOf(32));
                        ArrayList<Chain> bc = (ArrayList<Chain>)bundles.get(string2);
                        if (null == bc) {
                            bc = new ArrayList<Chain>();
                            bundles.put(string2, bc);
                        }
                        bc.add(chain);
                    }
                    ini.trakem2.utils.Utils.log2("Found " + bundles.size() + " bundles.");
                    chains = null;
                    if (null != cp.regex && show_axes_3D && axes.size() < 3) {
                        String cp_regex = cp.regex;
                        cp.regex = "mb";
                        Object[] o = Compare.gatherChains(p, cp, ignore);
                        ArrayList arrayList = (ArrayList)o[0];
                        ini.trakem2.utils.Utils.logAll("Found " + arrayList.size() + " chains for lobes");
                        for (Chain chain : arrayList) {
                            String t = chain.getCellTitle().toLowerCase();
                            if (-1 == t.indexOf("peduncle") && -1 == t.indexOf("medial lobe") && -1 == t.indexOf("dorsal lobe")) continue;
                            ini.trakem2.utils.Utils.logAll("adding " + t);
                            Project pr = chain.pipes.get(0).getProject();
                            HashMap<String, VectorString3D> m = (HashMap<String, VectorString3D>)axes.get(pr);
                            if (null == m) {
                                m = new HashMap<String, VectorString3D>();
                                axes.put(pr, m);
                            }
                            m.put(t, chain.vs);
                        }
                        cp.regex = cp_regex;
                    } else {
                        ini.trakem2.utils.Utils.logAll("Not: cp.regex = " + cp.regex + "  show_axes_3D = " + show_axes_3D + "  axes.size() = " + axes.size());
                    }
                    HashMap condensed = new HashMap();
                    ini.trakem2.utils.Utils.log2("Condensing each bundle...");
                    for (Map.Entry entry : bundles.entrySet()) {
                        ArrayList bc = (ArrayList)entry.getValue();
                        if (bc.size() < 2) {
                            ini.trakem2.utils.Utils.log2("Skipping single: " + (String)entry.getKey());
                            continue;
                        }
                        VectorString3D[] vs = new VectorString3D[bc.size()];
                        for (int i = 0; i < vs.length; ++i) {
                            vs[i] = ((Chain)bc.get((int)i)).vs;
                        }
                        VectorString3D c = Compare.condense(cp, vs, this);
                        c.setCalibration(p[0].getRootLayerSet().getCalibrationCopy());
                        condensed.put(entry.getKey(), c);
                        if (!this.hasQuitted()) continue;
                        return;
                    }
                    if (null != map_condensed) {
                        map_condensed.putAll(condensed);
                    }
                    if (generate_plots) {
                        ini.trakem2.utils.Utils.log2("Plotting stdDev for each condensed bundle...");
                        for (Map.Entry entry : condensed.entrySet()) {
                            String name = (String)entry.getKey();
                            VectorString3D c = (VectorString3D)entry.getValue();
                            Plot plot = Compare.makePlot(cp, name, c);
                            if (show_plots) {
                                plot.show();
                                continue;
                            }
                            if (null == plot_dir) continue;
                            new FileSaver(plot.getImagePlus()).saveAsPng(plot_dir + name.replace('/', '-') + ".png");
                        }
                    }
                    if (show_3D) {
                        Color color;
                        Object greens;
                        HashMap<String, Color> heat_table = new HashMap<String, Color>();
                        if (heat_map || show_envelope_3D) {
                            ImagePlus imagePlus = new ImagePlus("lut", (ImageProcessor)new ByteProcessor(4, 4));
                            IJ.run((ImagePlus)imagePlus, (String)"Fire", (String)"");
                            IndexColorModel icm = (IndexColorModel)imagePlus.getProcessor().getColorModel();
                            byte[] reds = new byte[256];
                            greens = new byte[256];
                            byte[] blues = new byte[256];
                            icm.getReds(reds);
                            icm.getGreens((byte[])greens);
                            icm.getBlues(blues);
                            ArrayList names = new ArrayList(bundles.keySet());
                            Collections.sort(names);
                            double max = 0.0;
                            HashMap heats = new HashMap();
                            for (String string : names) {
                                VectorString3D vs_merged = (VectorString3D)condensed.get(string);
                                if (null == vs_merged) {
                                    ini.trakem2.utils.Utils.logAll("WARNING could not find a condensed pipe for " + string);
                                    continue;
                                }
                                double[] stdDev = vs_merged.getStdDevAtEachPoint();
                                Arrays.sort(stdDev);
                                double median = stdDev[stdDev.length / 2];
                                if (max < median) {
                                    max = median;
                                }
                                heats.put(string, median);
                            }
                            for (Map.Entry entry : heats.entrySet()) {
                                String name = (String)entry.getKey();
                                double median = (Double)entry.getValue();
                                int index = (int)(median / max * 255.0);
                                if (index > 255) {
                                    index = 255;
                                }
                                color = new Color(0xFF & reds[index], 0xFF & greens[index], 0xFF & blues[index]);
                                ini.trakem2.utils.Utils.log2(name + '\t' + median + '\t' + reds[index] + '\t' + (int)greens[index] + '\t' + blues[index]);
                                heat_table.put(name, color);
                            }
                        }
                        LayerSet layerSet = new LayerSet(p[0], -1L, "Common", 10.0f, 10.0f, 0.0, 0.0, 0.0, 512.0f, 512.0f, false, 2, new AffineTransform());
                        Display3D d3d = Display3D.get(layerSet);
                        float env_alpha = envelope_alpha;
                        if (env_alpha < 0.0f) {
                            ini.trakem2.utils.Utils.log2("WARNING envelope_alpha is invalid: " + envelope_alpha + "\n    Using 0.4f instead");
                            env_alpha = 0.4f;
                        } else if (env_alpha > 1.0f) {
                            env_alpha = 1.0f;
                        }
                        greens = bundles.keySet().iterator();
                        while (greens.hasNext()) {
                            String name = (String)greens.next();
                            ArrayList bc = (ArrayList)bundles.get(name);
                            VectorString3D vs_merged = (VectorString3D)condensed.get(name);
                            if (null == vs_merged) {
                                ini.trakem2.utils.Utils.logAll("WARNING: could not find a condensed vs for " + name);
                                continue;
                            }
                            if (show_sources_3D) {
                                if (null != sources_color_table) {
                                    HashSet<String> titles = new HashSet<String>();
                                    for (Chain chain : bc) {
                                        String title;
                                        Color color2 = (Color)sources_color_table.get(chain.getRoot().getProject());
                                        String t = title = chain.getCellTitle();
                                        int i = 2;
                                        while (titles.contains(t)) {
                                            t = title + "-" + i;
                                            ++i;
                                        }
                                        titles.add(t);
                                        Display3D.addMesh(layerSet, chain.vs, t, null != color2 ? color2 : Color.gray);
                                    }
                                } else {
                                    for (Chain chain : bc) {
                                        Display3D.addMesh(layerSet, chain.vs, chain.getCellTitle(), Color.gray);
                                    }
                                }
                            }
                            if (show_condensed_3D) {
                                Display3D.addMesh(layerSet, vs_merged, name + "-condensed", heat_map ? (Color)heat_table.get(name) : Color.red);
                            }
                            if (show_envelope_3D) {
                                double[] widths = Compare.makeEnvelope(cp, vs_merged);
                                if (cp.delta_envelope > 1.0) {
                                    vs_merged.addDependent(widths);
                                    vs_merged.resample(cp.delta_envelope);
                                    widths = vs_merged.getDependent(0);
                                }
                                Display3D.addMesh(layerSet, vs_merged, name + "-envelope", heat_map ? (Color)heat_table.get(name) : Color.red, widths, env_alpha);
                                continue;
                            }
                            if (!heat_map) continue;
                            double x = vs_merged.getPoints(0)[0];
                            double y = vs_merged.getPoints(1)[0];
                            double z = vs_merged.getPoints(2)[0];
                            double r = 10.0;
                            color = (Color)heat_table.get(name);
                            if (null == color) {
                                ini.trakem2.utils.Utils.logAll("WARNING: heat table does not have a color for " + name);
                                continue;
                            }
                            Content content = d3d.getUniverse().addMesh(Mesh_Maker.createSphere((double)x, (double)y, (double)z, (double)10.0), Utils.toColor3f((Color)((Color)heat_table.get(name))), name + "-sphere", 1);
                        }
                        if (show_axes_3D) {
                            for (int i = 0; i < p.length; ++i) {
                                Map m = (Map)axes.get(p[i]);
                                if (null == m) {
                                    ini.trakem2.utils.Utils.log2("No axes found for project " + p[i]);
                                    continue;
                                }
                                for (Map.Entry e : m.entrySet()) {
                                    Display3D.addMesh(layerSet, (VectorString3D)e.getValue(), (String)e.getKey() + "-" + i, Color.gray);
                                }
                            }
                        }
                        results.put("d3d", Display3D.get(layerSet));
                    }
                    this.result = results;
                    ini.trakem2.utils.Utils.log2("Done.");
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, p[0]);
    }

    public static Plot makePlot(CATAParameters cp, String name, VectorString3D c) {
        double[] stdDev = c.getStdDevAtEachPoint();
        if (null == stdDev) {
            return null;
        }
        double[] index = new double[stdDev.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ini.trakem2.utils.Utils.log2("name is " + name);
        ini.trakem2.utils.Utils.log2("c is " + c);
        ini.trakem2.utils.Utils.log2("cp is " + cp);
        ini.trakem2.utils.Utils.log2("stdDev is " + stdDev);
        ini.trakem2.utils.Utils.log2("c.getCalibrationCopy() is " + c.getCalibrationCopy());
        ini.trakem2.utils.Utils.log2("c.getDelta() is " + c.getDelta());
        Calibration cal = c.getCalibrationCopy();
        if (null == cal) {
            ini.trakem2.utils.Utils.log2("WARNING null calibration!");
        }
        Plot plot = new Plot(name, name + " -- Point index (delta: " + ini.trakem2.utils.Utils.cutNumber(c.getDelta(), 2) + " " + (null == cal ? "pixels" : cal.getUnits()) + ")", "Std Dev", index, stdDev);
        plot.setLimits(0.0, cp.plot_max_x, 0.0, cp.plot_max_y);
        plot.setSize(cp.plot_width, cp.plot_height);
        plot.setLineWidth(2);
        return plot;
    }

    public static double[] makeEnvelope(CATAParameters cp, VectorString3D c) {
        double[] width;
        block7: {
            block8: {
                block6: {
                    if (cp.envelope_type <= 0) {
                        return c.getStdDevAtEachPoint();
                    }
                    width = new double[c.length()];
                    if (cp.envelope_type >= 3) break block6;
                    double[] std = c.getStdDevAtEachPoint();
                    int f = cp.envelope_type + 1;
                    for (int i = 0; i < std.length; ++i) {
                        width[i] = (double)f * std[i];
                    }
                    break block7;
                }
                if (3 != cp.envelope_type) break block8;
                int i = 0;
                for (ArrayList ap : c.getSource()) {
                    double sum = 0.0;
                    for (Point3d p : ap) {
                        sum += c.distance(i, p);
                    }
                    width[i] = sum / (double)ap.size();
                    ++i;
                }
                break block7;
            }
            if (4 != cp.envelope_type) break block7;
            int i = 0;
            for (ArrayList ap : c.getSource()) {
                double max = 0.0;
                for (Point3d p : ap) {
                    max = Math.max(max, c.distance(i, p));
                }
                width[i] = max;
                ++i;
            }
        }
        return width;
    }

    public static VectorString3D condense(CATAParameters cp, VectorString3D[] vs, Worker worker) throws Exception {
        int i;
        if (1 == vs.length) {
            return vs[0];
        }
        if (0.0 == cp.delta) {
            for (i = 0; i < vs.length; ++i) {
                cp.delta += vs[i].getAverageDelta();
            }
            cp.delta /= (double)vs.length;
        }
        for (i = 0; i < vs.length; ++i) {
            vs[i].resample(cp.delta, true);
        }
        try {
            if (2 == vs.length) {
                VectorString3D.createInterpolatedPoints((Editions)new Editions((VectorString)vs[0], (VectorString)vs[1], cp.delta, false), (double)0.5);
            }
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        float[][] scores = Compare.scoreAllToAll(vs, cp.distance_type, cp.delta, cp.skip_ends, cp.max_mut, cp.min_chunk, cp.direct, cp.substring_matching, worker);
        HashMap<Cell<VectorString3D>, Float> table = new HashMap<Cell<VectorString3D>, Float>();
        for (int i2 = 1; i2 < scores.length; ++i2) {
            for (int j = 0; j < i2; ++j) {
                table.put(new Cell<VectorString3D>(vs[i2], vs[j]), Float.valueOf(scores[i2][j]));
            }
        }
        HashSet<VectorString3D> remaining = new HashSet<VectorString3D>();
        for (VectorString3D v : vs) {
            remaining.add(v);
        }
        while (table.size() > 0) {
            if (null != worker && worker.hasQuitted()) {
                return null;
            }
            float min = Float.MAX_VALUE;
            Cell cell = null;
            for (Map.Entry e : table.entrySet()) {
                float f = ((Float)e.getValue()).floatValue();
                if (!(f < min)) continue;
                min = f;
                cell = (Cell)e.getKey();
            }
            Iterator it = table.keySet().iterator();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (c.t1 != cell.t1 && c.t2 != cell.t2 && c.t2 != cell.t1 && c.t1 != cell.t2) continue;
                it.remove();
            }
            remaining.remove(cell.t1);
            remaining.remove(cell.t2);
            double alpha = (double)((VectorString3D)cell.t1).getNSources() / (double)(((VectorString3D)cell.t1).getNSources() + ((VectorString3D)cell.t2).getNSources());
            Editions eds = new Editions((VectorString)cell.t1, (VectorString)cell.t2, cp.delta, false);
            VectorString3D vs_merged = null;
            if (cp.cut_uneven_ends) {
                int i3;
                int[][] editions = eds.getEditions();
                int first = 0;
                int last = editions.length - 1;
                int n_mut = 0;
                for (i3 = 0; i3 < last; ++i3) {
                    if (3 != editions[i3][0] || ++n_mut <= cp.max_mut) continue;
                    first = i3 - n_mut + 1;
                    break;
                }
                n_mut = 0;
                for (i3 = last; i3 > first; --i3) {
                    if (3 != editions[i3][0] || ++n_mut <= cp.max_mut) continue;
                    last = i3 + n_mut - 1;
                    break;
                }
                vs_merged = VectorString3D.createInterpolatedPoints((Editions)eds, (double)alpha, (int)first, (int)last);
            } else {
                vs_merged = VectorString3D.createInterpolatedPoints((Editions)eds, (double)alpha);
            }
            vs_merged.resample(cp.delta, true);
            for (VectorString3D v : remaining) {
                Object[] ob = Compare.findBestMatch(vs_merged, v, cp.delta, cp.skip_ends, cp.max_mut, cp.min_chunk, cp.distance_type, cp.direct, cp.substring_matching);
                Editions ed = (Editions)ob[0];
                float score = (float)Compare.getScore(ed, cp.skip_ends, cp.max_mut, cp.min_chunk, cp.distance_type);
                table.put(new Cell<VectorString3D>(vs_merged, v), Float.valueOf(score));
            }
            remaining.add(vs_merged);
        }
        if (1 != remaining.size()) {
            ini.trakem2.utils.Utils.log2("WARNING: remaining.size() == " + remaining.size());
        }
        return (VectorString3D)remaining.iterator().next();
    }

    public static List<VectorString3D> transferVectorStrings(List<VectorString3D> vs, List<Tuple3d> source, List<Tuple3d> target, Class<AffineModel3D> model_class) throws Exception {
        if (source.size() != target.size()) {
            ini.trakem2.utils.Utils.log2("Could not generate a MovingLeastSquaresTransform: different number of source and target points.");
            return null;
        }
        if (source.size() < 1 || target.size() < 1) {
            ini.trakem2.utils.Utils.log2("Cannot transform with less than one point correspondence!");
            return null;
        }
        ArrayList<PointMatch> pm = new ArrayList<PointMatch>();
        Iterator<Tuple3d> si = source.iterator();
        Iterator<Tuple3d> ti = target.iterator();
        while (si.hasNext()) {
            Tuple3d sp = si.next();
            Tuple3d tp = ti.next();
            pm.add(new PointMatch(new Point(new double[]{sp.x, sp.y, sp.z}), new Point(new double[]{tp.x, tp.y, tp.z}), 1.0));
        }
        MovingLeastSquaresTransform mls = new MovingLeastSquaresTransform();
        mls.setModel(model_class);
        mls.setMatches(pm);
        double[] point = new double[3];
        ArrayList<VectorString3D> vt = new ArrayList<VectorString3D>();
        for (VectorString3D vi : vs) {
            double[] x = vi.getPoints(0);
            double[] y = vi.getPoints(1);
            double[] z = vi.getPoints(2);
            double[] tx = new double[x.length];
            double[] ty = new double[x.length];
            double[] tz = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                point[0] = x[i];
                point[1] = y[i];
                point[2] = z[i];
                mls.applyInPlace(point);
                tx[i] = point[0];
                ty[i] = point[1];
                tz[i] = point[2];
            }
            try {
                vt.add(new VectorString3D(tx, ty, tz, vi.isClosed()));
            }
            catch (Exception exception) {}
        }
        return vt;
    }

    private static boolean extractMatches(Map<String, Tuple3d> source, Map<String, Tuple3d> target, List<Tuple3d> so, List<Tuple3d> ta) {
        if (null == source || null == target || null == so || null == ta) {
            return false;
        }
        so.clear();
        ta.clear();
        for (Map.Entry<String, Tuple3d> e : target.entrySet()) {
            Tuple3d point = source.get(e.getKey());
            if (null == point) continue;
            so.add(point);
            ta.add(e.getValue());
        }
        if (0 == so.size()) {
            ini.trakem2.utils.Utils.log2("No points in common!");
            return false;
        }
        return true;
    }

    public static List<VectorString3D> transferVectorStrings(List<VectorString3D> vs, Map<String, Tuple3d> source, Map<String, Tuple3d> target) throws Exception {
        if (null == source || null == target) {
            return null;
        }
        ArrayList<Tuple3d> so = new ArrayList<Tuple3d>();
        ArrayList<Tuple3d> ta = new ArrayList<Tuple3d>();
        for (Map.Entry<String, Tuple3d> e : target.entrySet()) {
            Tuple3d point = source.get(e.getKey());
            if (null == point) continue;
            so.add(point);
            ta.add(e.getValue());
        }
        if (0 == so.size()) {
            ini.trakem2.utils.Utils.log2("No points in common!");
            return null;
        }
        ini.trakem2.utils.Utils.log2("Found points in common: " + so.size());
        return Compare.transferVectorStrings(vs, so, ta, AffineModel3D.class);
    }

    public static List<VectorString3D> transferVectorStrings(List<VectorString3D> vs, ProjectThing source_fiduciary, ProjectThing target_fiduciary) throws Exception {
        return Compare.transferVectorStrings(vs, Compare.extractPoints(source_fiduciary), Compare.extractPoints(target_fiduciary));
    }

    public static Map<String, Tuple3d> extractPoints(ProjectThing fiducial) {
        if (!fiducial.getType().equals("fiducial_points")) {
            ini.trakem2.utils.Utils.log("Can only extract points from 'fiducial_points' type.");
            return null;
        }
        ArrayList<ProjectThing> fiducials = fiducial.getChildren();
        if (null == fiducials || 0 == fiducials.size()) {
            ini.trakem2.utils.Utils.log("No fiducial points can be extracted from " + fiducial);
            return null;
        }
        HashMap<String, Tuple3d> fide = new HashMap<String, Tuple3d>();
        for (ProjectThing child : fiducials) {
            double[][] b;
            String title;
            Ball ball;
            if (child.getType().equals("ball")) {
                ball = (Ball)child.getObject();
                title = ball.getTitle();
            } else {
                ArrayList<ProjectThing> balls = child.findChildrenOfType("ball");
                if (null == balls || 0 == balls.size()) {
                    ini.trakem2.utils.Utils.log2("Ignoring empty fiducial " + child);
                    continue;
                }
                ball = (Ball)balls.get(0).getObject();
                title = child.getType();
            }
            if ((b = ball.getWorldBalls()).length <= 0) continue;
            fide.put(title.toLowerCase(), (Tuple3d)new Point3d(b[0][0], b[0][1], b[0][2]));
            ini.trakem2.utils.Utils.log2("Found fiducial point " + title.toLowerCase());
        }
        return fide;
    }

    public static final Bureaucrat reliabilityAnalysis(String[] ignore) {
        return Compare.reliabilityAnalysis(ignore, true, true, true, 1.0, 1.1, 1.1, 1.0);
    }

    public static final Bureaucrat reliabilityAnalysis(final String[] ignore, final boolean output_arff, final boolean weka_classify, final boolean show_dialog, final double delta, final double wi, final double wd, final double wm) {
        final Project[] p = Project.getProjects().toArray(new Project[0]);
        Worker worker = new Worker("Reliability by name"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                try {
                    Iterator oi;
                    StringBuilder arff;
                    final CATAParameters cp = new CATAParameters();
                    cp.delta = delta;
                    if (show_dialog && !cp.setup(false, null, false, false)) {
                        this.finishedWorking();
                        return;
                    }
                    Object[] ob = Compare.gatherChains(p, cp, ignore);
                    ArrayList chains = (ArrayList)ob[0];
                    final ArrayList[] p_chains = (ArrayList[])ob[1];
                    ob = null;
                    if (null == chains) {
                        this.finishedWorking();
                        return;
                    }
                    ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                    final TreeMap indices = new TreeMap();
                    final ArrayList cin = new ArrayList();
                    final TreeMap indices_f = new TreeMap();
                    final ArrayList cin_f = new ArrayList();
                    ArrayList fus = new ArrayList();
                    StringBuilder stringBuilder = arff = output_arff ? new StringBuilder("@RELATION Lineages\n\n") : null;
                    if (output_arff) {
                        arff.append("@ATTRIBUTE APD NUMERIC\n");
                        arff.append("@ATTRIBUTE CPD NUMERIC\n");
                        arff.append("@ATTRIBUTE STD NUMERIC\n");
                        arff.append("@ATTRIBUTE MPD NUMERIC\n");
                        arff.append("@ATTRIBUTE PM NUMERIC\n");
                        arff.append("@ATTRIBUTE LEV NUMERIC\n");
                        arff.append("@ATTRIBUTE SIM NUMERIC\n");
                        arff.append("@ATTRIBUTE PRX NUMERIC\n");
                        arff.append("@ATTRIBUTE PRM NUMERIC\n");
                        arff.append("@ATTRIBUTE LR NUMERIC\n");
                        arff.append("@ATTRIBUTE TR NUMERIC\n");
                        arff.append("@ATTRIBUTE CLASS {false,true}\n");
                        arff.append("\n@DATA\n");
                    }
                    final AtomicInteger obs_good = new AtomicInteger(0);
                    final AtomicInteger obs_wrong = new AtomicInteger(0);
                    final AtomicInteger exp_good = new AtomicInteger(0);
                    final AtomicInteger exp_bad = new AtomicInteger(0);
                    final AtomicInteger obs_bad_classified_good_ones = new AtomicInteger(0);
                    final AtomicInteger obs_well_classified_bad_ones = new AtomicInteger(0);
                    final AtomicInteger not_found = new AtomicInteger(0);
                    final AtomicInteger already_classified = new AtomicInteger(0);
                    Method classify_ = null;
                    if (weka_classify) {
                        try {
                            classify_ = Class.forName("lineage.LineageClassifier").getDeclaredMethod("classify", double[].class);
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                    }
                    final Method classify = classify_;
                    for (int _i = 0; _i < p_chains.length; ++_i) {
                        final int n = _i;
                        ini.trakem2.utils.Utils.log2("Project " + p[n] + " has " + p_chains[n].size() + " chains.");
                        for (int _j = 0; _j < p_chains.length; ++_j) {
                            final int j = _j;
                            if (n == j) continue;
                            final String[] titles_j = new String[p_chains[j].size()];
                            int next = 0;
                            for (Chain cj : p_chains[j]) {
                                String string = cj.getCellTitle();
                                titles_j[next++] = string.substring(0, string.indexOf(32));
                            }
                            TreeSet<String> ts_families = new TreeSet<String>();
                            for (int f = 0; f < titles_j.length; ++f) {
                                int n2;
                                Object object = titles_j[f];
                                for (n2 = 0; n2 < ((String)object).length() && Character.isUpperCase(((String)object).charAt(n2)); ++n2) {
                                }
                                ts_families.add(((String)object).substring(0, n2));
                            }
                            ArrayList families = new ArrayList(ts_families);
                            fus.add(exec.submit(new Callable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object call() {
                                    for (Chain chain : p_chains[n]) {
                                        int u;
                                        VectorString3D vs1 = chain.vs;
                                        String title = chain.getCellTitle();
                                        title = title.substring(0, title.indexOf(32));
                                        int title_index = -1;
                                        for (int k = 0; k < titles_j.length; ++k) {
                                            if (!title.equals(titles_j[k])) continue;
                                            title_index = k;
                                            break;
                                        }
                                        if (-1 == title_index) {
                                            ini.trakem2.utils.Utils.log2(title + " not found in project " + p[j]);
                                            if (!weka_classify) continue;
                                            not_found.incrementAndGet();
                                            continue;
                                        }
                                        if (weka_classify) {
                                            exp_good.incrementAndGet();
                                            exp_bad.addAndGet(titles_j.length - 1);
                                        }
                                        ArrayList<ChainMatch> list = new ArrayList<ChainMatch>();
                                        for (u = 0; u < title.length() && Character.isUpperCase(title.charAt(u)); ++u) {
                                        }
                                        String family_name = title.substring(0, u);
                                        String last_classify = null;
                                        int g = 0;
                                        for (Chain cj : p_chains[j]) {
                                            VectorString3D vs2 = cj.vs;
                                            Object[] ob = Compare.findBestMatch(vs1, vs2, cp.delta, cp.skip_ends, cp.max_mut, cp.min_chunk, cp.distance_type, cp.direct, cp.substring_matching, wi, wd, wm);
                                            Editions ed = (Editions)ob[0];
                                            double[] stats = ed.getStatistics(cp.skip_ends, cp.max_mut, cp.min_chunk, cp.score_mut_only);
                                            ChainMatch cm = new ChainMatch(cj, null, ed, stats, Compare.score(ed.getSimilarity(), ed.getDistance(), stats[3], W));
                                            cm.title = titles_j[g];
                                            list.add(cm);
                                            ++g;
                                            if (!weka_classify) continue;
                                            double[] param = new double[11];
                                            for (int p = 0; p < stats.length; ++p) {
                                                param[p] = stats[p];
                                            }
                                            try {
                                                if (((Boolean)classify.invoke(null, new Object[]{param})).booleanValue()) {
                                                    if (null != last_classify) {
                                                        ini.trakem2.utils.Utils.log2("ALREADY CLASSIFIED " + title + " as " + last_classify + "  (now: " + cm.title + " )");
                                                        already_classified.incrementAndGet();
                                                    }
                                                    last_classify = cm.title;
                                                    if (title.equals(cm.title)) {
                                                        obs_good.incrementAndGet();
                                                        continue;
                                                    }
                                                    ini.trakem2.utils.Utils.log2("WRONG CLASSIFICATION of " + title + " as " + cm.title);
                                                    obs_wrong.incrementAndGet();
                                                    continue;
                                                }
                                                if (title.equals(cm.title)) {
                                                    obs_bad_classified_good_ones.incrementAndGet();
                                                    continue;
                                                }
                                                obs_well_classified_bad_ones.incrementAndGet();
                                            }
                                            catch (Exception ee) {
                                                IJError.print(ee);
                                            }
                                        }
                                        Compare.sortMatches(list, cp.distance_type, cp.distance_type_2, cp.min_matches);
                                        if (output_arff) {
                                            for (int h = 0; h < 8; ++h) {
                                                ChainMatch cm = (ChainMatch)list.get(h);
                                                StringBuilder sb = new StringBuilder();
                                                sb.append(cm.phys_dist).append(',').append(cm.cum_phys_dist).append(',').append(cm.stdDev).append(',').append(cm.median).append(',').append(cm.prop_mut).append(',').append(cm.ed.getDistance()).append(',').append(cm.seq_sim).append(',').append(cm.proximity).append(',').append(cm.proximity_mut).append(',').append(cm.prop_len).append(',').append(cm.tortuosity_ratio).append(',').append(title.equals(cm.title)).append('\n');
                                                StringBuilder stringBuilder = arff;
                                                synchronized (stringBuilder) {
                                                    arff.append((CharSequence)sb);
                                                    continue;
                                                }
                                            }
                                        }
                                        int f = 0;
                                        boolean found_specific = false;
                                        boolean found_family = false;
                                        for (ChainMatch cm : list) {
                                            ArrayList<Integer> al;
                                            TreeMap treeMap;
                                            if (!found_specific && title.equals(cm.title)) {
                                                treeMap = indices;
                                                synchronized (treeMap) {
                                                    al = (ArrayList<Integer>)indices.get(title);
                                                    if (null == al) {
                                                        al = new ArrayList<Integer>();
                                                        indices.put(title, al);
                                                        cin.add(new CITuple(title, chain, al));
                                                    }
                                                    al.add(f);
                                                }
                                                found_specific = true;
                                            }
                                            if (!found_family && cm.title.startsWith(family_name)) {
                                                treeMap = indices_f;
                                                synchronized (treeMap) {
                                                    al = (ArrayList)indices_f.get(family_name);
                                                    if (null == al) {
                                                        al = new ArrayList();
                                                        indices_f.put(family_name, al);
                                                        cin_f.add(new CITuple(family_name, chain, al));
                                                    }
                                                    al.add(f);
                                                }
                                                found_family = true;
                                            }
                                            if (found_specific && found_family) break;
                                            ++f;
                                        }
                                        if (found_specific) continue;
                                        ini.trakem2.utils.Utils.log2("NOT FOUND any match for " + title + " within a list of size " + list.size() + ", in project " + chain.getRoot().getProject());
                                    }
                                    return null;
                                }
                            }));
                        }
                    }
                    for (Future future : fus) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                    }
                    exec.shutdownNow();
                    if (weka_classify) {
                        try {
                            Class.forName("lineage.LineageClassifier").getDeclaredMethod("flush", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                    }
                    if (output_arff) {
                        ini.trakem2.utils.Utils.saveToFile(new File(System.getProperty("user.dir") + "/lineages.arff"), arff.toString());
                    }
                    StringBuilder sb = new StringBuilder();
                    TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
                    TreeMap<Integer, Integer> sum_f = new TreeMap<Integer, Integer>();
                    TreeMap<String, TreeMap<Integer, Integer>> sum_fw = new TreeMap<String, TreeMap<Integer, Integer>>();
                    sb.append("List of scoring indices for each (starting at index 1, aka best possible score):\n");
                    for (CITuple ci : cin) {
                        Collections.sort(ci.list);
                        int last = 0;
                        int count = 1;
                        for (int n : ci.list) {
                            int n3;
                            if (last == n) {
                                ++count;
                            } else {
                                sb.append(ci.title).append(' ').append(last + 1).append(' ').append(count).append('\n');
                                last = n;
                                count = 1;
                            }
                            oi = new Integer(n);
                            treeMap.put((Integer)((Object)oi), (treeMap.containsKey(oi) ? (Integer)treeMap.get(oi) : 0) + 1);
                            for (n3 = 0; n3 < ci.title.length() && Character.isUpperCase(ci.title.charAt(n3)); ++n3) {
                            }
                            String string = ci.title.substring(0, n3);
                            TreeMap<Integer, Integer> sfw = (TreeMap<Integer, Integer>)sum_fw.get(string);
                            if (null == sfw) {
                                sfw = new TreeMap<Integer, Integer>();
                                sum_fw.put(string, sfw);
                            }
                            sfw.put((Integer)((Object)oi), (sfw.containsKey(oi) ? (Integer)sfw.get(oi) : 0) + 1);
                        }
                        if (0 != count) {
                            sb.append(ci.title).append(' ').append(last + 1).append(' ').append(count).append('\n');
                        }
                        if (last <= 6) continue;
                        ini.trakem2.utils.Utils.log2("BAD index " + last + " for chain " + ci.title + " " + ci.chain.getRoot() + " of project " + ci.chain.getRoot().getProject());
                    }
                    sb.append("===============================\n");
                    for (CITuple ci : cin_f) {
                        Collections.sort(ci.list);
                        int last = 0;
                        int count = 1;
                        for (int n : ci.list) {
                            if (last == n) {
                                ++count;
                            } else {
                                last = n;
                                count = 1;
                            }
                            oi = new Integer(n);
                            sum_f.put((Integer)((Object)oi), (sum_f.containsKey(oi) ? (Integer)sum_f.get(oi) : 0) + 1);
                        }
                    }
                    sb.append("===============================\n");
                    sb.append("Global count of index ocurrences:\n");
                    int total = 0;
                    int top2 = 0;
                    int top5 = 0;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        sb.append(entry.getKey()).append(' ').append(entry.getValue()).append('\n');
                        total += ((Integer)entry.getValue()).intValue();
                        if ((Integer)entry.getKey() < 2) {
                            top2 += ((Integer)entry.getValue()).intValue();
                        }
                        if ((Integer)entry.getKey() >= 5) continue;
                        top5 += ((Integer)entry.getValue()).intValue();
                    }
                    sb.append("total: ").append(total).append('\n');
                    sb.append("top1: ").append((float)((Integer)treeMap.get(treeMap.firstKey())).intValue() / (float)total).append('\n');
                    sb.append("top2: ").append((float)top2 / (float)total).append('\n');
                    sb.append("top5: ").append((float)top5 / (float)total).append('\n');
                    sb.append("===============================\n");
                    sb.append("Family-wise count of index ocurrences:\n");
                    for (Map.Entry fe : sum_fw.entrySet()) {
                        int total2 = 0;
                        int top52 = 0;
                        for (Map.Entry entry : ((TreeMap)fe.getValue()).entrySet()) {
                            sb.append((String)fe.getKey()).append(' ').append(entry.getKey()).append(' ').append(entry.getValue()).append('\n');
                            total2 += ((Integer)entry.getValue()).intValue();
                            if ((Integer)entry.getKey() >= 5) continue;
                            top52 += ((Integer)entry.getValue()).intValue();
                        }
                        sb.append("total: ").append(total2).append('\n');
                        sb.append("top1: ").append((float)((Integer)((TreeMap)fe.getValue()).get(((TreeMap)fe.getValue()).firstKey())).intValue() / (float)total2).append('\n');
                        sb.append("top5: ").append((float)top52 / (float)total2).append('\n');
                    }
                    sb.append("===============================\n");
                    double first = 0.0;
                    double first_5 = 0.0;
                    double d = 0.0;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        int n = (Integer)entry.getKey();
                        int a = (Integer)entry.getValue();
                        d += (double)a;
                        if (0 == n) {
                            first = a;
                        }
                        if (n >= 5) continue;
                        first_5 += (double)a;
                    }
                    this.result = new double[]{first / d, first_5 / d};
                    sb.append("Global count of index occurrences family-wise:\n");
                    for (Map.Entry entry : sum_f.entrySet()) {
                        sb.append(entry.getKey()).append(' ').append(entry.getValue()).append('\n');
                    }
                    sb.append("===============================\n");
                    sb.append("A summarizing histogram of how well each chain scores, for those that have 4 homologous members. It's the number of 1st scores (zeroes) versus the total number of scores:\n");
                    TreeMap hsc = new TreeMap();
                    for (CITuple cITuple : cin) {
                        int size = cITuple.list.size();
                        ArrayList<String> al = (ArrayList<String>)hsc.get(size);
                        if (null == al) {
                            al = new ArrayList<String>();
                            hsc.put(size, al);
                        }
                        int count = 0;
                        for (Integer i : cITuple.list) {
                            if (0 != i) break;
                            ++count;
                        }
                        al.add(new StringBuffer(cITuple.title).append(" =").append(count).append('/').append(cITuple.list.size()).append('\n').toString());
                    }
                    for (Map.Entry entry : hsc.entrySet()) {
                        sb.append("For ").append(entry.getKey()).append(" matches:\n");
                        for (String s : (ArrayList)entry.getValue()) {
                            sb.append(s);
                        }
                    }
                    sb.append("=========================\n");
                    sb.append("Number of top scoring per family:\n");
                    TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                    for (CITuple ci : cin_f) {
                        int count = 0;
                        for (Integer i : ci.list) {
                            if (0 != i) break;
                            ++count;
                        }
                        treeMap2.put(ci.title, ci.title + " =" + count + '/' + ci.list.size() + '\n');
                    }
                    for (String s : treeMap2.values()) {
                        sb.append(s);
                    }
                    sb.append("=========================\n");
                    if (weka_classify) {
                        sb.append("Decision tree:\n");
                        sb.append("Expected good matches: " + exp_good.get() + "\n");
                        sb.append("Expected bad matches: " + exp_bad.get() + "\n");
                        sb.append("Observed good matches: " + obs_good.get() + "\n");
                        sb.append("Observed bad matches: " + obs_wrong.get() + "\n");
                        sb.append("Observed well classified bad ones: " + obs_well_classified_bad_ones.get() + "\n");
                        sb.append("Observed bad classified good ones: " + obs_bad_classified_good_ones.get() + "\n");
                        sb.append("Not found, so skipped: " + not_found.get() + "\n");
                        sb.append("Already classified: " + already_classified.get() + "\n");
                        sb.append("=========================\n");
                    }
                    if (output_arff) {
                        ini.trakem2.utils.Utils.log(sb.toString());
                    } else {
                        ini.trakem2.utils.Utils.log2(sb.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, p);
    }

    public static final Bureaucrat reliabilityAnalysisSpaceExploration(final String[] ignore) {
        double MIN_DELTA = 0.4;
        double MAX_DELTA = 20.0;
        double INC_DELTA = 0.1;
        double MIN_WEIGHT = 0.0;
        double MAX_WEIGHT = 2.0;
        double INC_WEIGHT = 0.1;
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Space Exploration"){

            @Override
            public void exec() {
                File f = new File(System.getProperty("user.dir") + "/lineage_space_exploration.data");
                OutputStreamWriter dos = null;
                try {
                    dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f)), "8859_1");
                    for (double delta = 0.4; delta <= 20.05; delta += 0.1) {
                        for (double weight = 0.0; weight <= 2.05; weight += 0.1) {
                            Bureaucrat b = Compare.reliabilityAnalysis(ignore, false, false, false, delta, weight, weight, 1.0);
                            b.join();
                            double[] result = (double[])b.getWorker().getResult();
                            StringBuilder sb = new StringBuilder();
                            sb.append(delta).append('\t').append(weight).append('\t').append(result[0]).append('\t').append(result[1]).append('\n');
                            dos.write(sb.toString());
                            dos.flush();
                            ini.trakem2.utils.Utils.log2("===========================\n\n");
                            ini.trakem2.utils.Utils.log2(sb.toString());
                            ini.trakem2.utils.Utils.log2("===========================\n\n");
                        }
                    }
                    dos.flush();
                    dos.close();
                }
                catch (Exception e) {
                    try {
                        dos.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }, Project.getProjects().toArray(new Project[0]));
    }

    private static final class CITuple {
        String title;
        Chain chain;
        ArrayList<Integer> list;

        CITuple(String t, Chain c, ArrayList<Integer> l) {
            this.title = t;
            this.chain = c;
            this.list = l;
        }
    }

    private static final class Cell<T> {
        final T t1;
        final T t2;

        Cell(T t1, T t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public final boolean equals(Object ob1, Object ob2) {
            Cell cell1 = (Cell)ob1;
            Cell cell2 = (Cell)ob2;
            return cell1.t1 == cell2.t1 && cell1.t2 == cell2.t2 || cell2.t1 == cell1.t1 && cell2.t2 == cell1.t2;
        }
    }

    public static class CATAParameters {
        public double delta = 1.0;
        public boolean skip_ends = false;
        public int max_mut = 5;
        public float min_chunk = 0.5f;
        public boolean score_mut_only = false;
        public int transform_type = 3;
        public boolean chain_branches = true;
        public final String[][] presets = new String[][]{{"medial lobe", "dorsal lobe", "peduncle"}};
        public String[] preset = this.presets[0];
        public final String[] preset_names = new String[]{"X - 'medial lobe', Y - 'dorsal lobe', Z - 'peduncle'"};
        public final String[] formats = new String[]{"ggobi XML", ".csv", "Phylip .dis"};
        public String format = this.formats[2];
        public int distance_type = 2;
        public int distance_type_2 = 9;
        public int min_matches = 10;
        public boolean normalize = false;
        public boolean direct = true;
        public boolean substring_matching = false;
        public String regex = "";
        public boolean with_source = false;
        public double plot_max_x = 200.0;
        public double plot_max_y = 20.0;
        public int plot_width = 600;
        public int plot_height = 400;
        public boolean cut_uneven_ends = true;
        public int envelope_type = 2;
        public double delta_envelope = 1.0;

        public boolean setup(boolean to_file, String regex, boolean plot, boolean condense) {
            GenericDialog gd = new GenericDialog("All to all");
            gd.addMessage("Choose a point interdistance to resample to, or 0 for the average of all.");
            gd.addNumericField("point_interdistance: ", this.delta, 2);
            gd.addCheckbox("skip insertion/deletion strings at ends when scoring", this.skip_ends);
            gd.addNumericField("maximum_ignorable consecutive muts in endings: ", (double)this.max_mut, 0);
            gd.addNumericField("minimum_percentage that must remain: ", (double)this.min_chunk, 2);
            gd.addCheckbox("Score mutations only", this.score_mut_only);
            ini.trakem2.utils.Utils.addEnablerListener((Checkbox)gd.getCheckboxes().get(0), new Component[]{(Component)gd.getNumericFields().get(0), (Component)gd.getNumericFields().get(1)}, null);
            String[] transforms = new String[]{"translate and rotate", "translate, rotate and scale", "translate, rotate, scale and shear", "moving least squares", "relative", "direct"};
            gd.addChoice("Transform_type: ", transforms, transforms[this.transform_type]);
            gd.addCheckbox("Chain_branches", this.chain_branches);
            gd.addChoice("Presets: ", this.preset_names, this.preset_names[0]);
            gd.addMessage("");
            gd.addChoice("Scoring type: ", distance_types, distance_types[this.distance_type]);
            String[] distance_types2 = new String[]{"Levenshtein", "Dissimilarity", "Average physical distance", "Median physical distance", "Cummulative physical distance", "Standard deviation", "Combined SLM", "Proximity", "Proximity of mutation pairs", "None"};
            gd.addChoice("Resort scores by: ", distance_types2, distance_types2[this.distance_type_2]);
            gd.addNumericField("Min_matches: ", (double)this.min_matches, 0);
            if (to_file) {
                gd.addChoice("File format: ", this.formats, this.formats[2]);
            }
            gd.addCheckbox("normalize", this.normalize);
            gd.addCheckbox("direct", this.direct);
            gd.addCheckbox("substring_matching", this.substring_matching);
            gd.addStringField("regex: ", null != regex ? regex : "");
            if (plot) {
                gd.addNumericField("plot_width: ", (double)this.plot_width, 0);
                gd.addNumericField("plot_height: ", (double)this.plot_height, 0);
                gd.addNumericField("plot_max_x: ", this.plot_max_x, 2);
                gd.addNumericField("plot_max_y: ", this.plot_max_y, 2);
            }
            if (condense) {
                gd.addCheckbox("cut_uneven_ends", this.cut_uneven_ends);
                String[] env = new String[]{"1 std dev", "2 std dev", "3 std dev", "average", "maximum"};
                gd.addChoice("envelope", env, env[this.envelope_type]);
                gd.addNumericField("delta envelope:", this.delta_envelope, 1);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.delta = gd.getNextNumber();
            this.skip_ends = gd.getNextBoolean();
            this.max_mut = (int)gd.getNextNumber();
            this.min_chunk = (float)gd.getNextNumber();
            this.score_mut_only = gd.getNextBoolean();
            if (this.skip_ends) {
                if (this.max_mut < 0) {
                    this.max_mut = 0;
                }
                if (this.min_chunk <= 0.0f) {
                    this.skip_ends = false;
                }
                if (this.min_chunk > 1.0f) {
                    this.min_chunk = 1.0f;
                }
            }
            this.transform_type = gd.getNextChoiceIndex();
            this.chain_branches = gd.getNextBoolean();
            this.preset = this.presets[gd.getNextChoiceIndex()];
            this.distance_type = gd.getNextChoiceIndex();
            this.distance_type_2 = gd.getNextChoiceIndex();
            this.min_matches = (int)gd.getNextNumber();
            if (this.min_matches < 0) {
                ini.trakem2.utils.Utils.log("Using 0 min_matches!");
                this.min_matches = 0;
            }
            this.format = this.formats[0];
            if (to_file) {
                this.format = gd.getNextChoice().trim();
            }
            this.normalize = gd.getNextBoolean();
            this.direct = gd.getNextBoolean();
            this.substring_matching = gd.getNextBoolean();
            this.regex = gd.getNextString().trim();
            if (0 == this.regex.length()) {
                this.regex = null;
            }
            if (plot) {
                this.plot_width = (int)gd.getNextNumber();
                this.plot_height = (int)gd.getNextNumber();
                this.plot_max_x = gd.getNextNumber();
                this.plot_max_y = gd.getNextNumber();
            }
            if (condense) {
                this.cut_uneven_ends = gd.getNextBoolean();
                this.envelope_type = gd.getNextChoiceIndex();
                this.delta_envelope = gd.getNextNumber();
                ini.trakem2.utils.Utils.log2("delta_envelope has been set to " + this.delta_envelope);
            }
            return true;
        }
    }

    private static class ChainMatchComparator
    implements Comparator<ChainMatch> {
        final int distance_type;

        ChainMatchComparator(int distance_type) {
            this.distance_type = distance_type;
        }

        @Override
        public int compare(ChainMatch cm1, ChainMatch cm2) {
            double val = 0.0;
            switch (this.distance_type) {
                case 6: {
                    val = cm1.score - cm2.score;
                    break;
                }
                case 0: {
                    val = cm2.ed.getDistance() - cm1.ed.getDistance();
                    break;
                }
                case 1: {
                    val = cm1.seq_sim - cm2.seq_sim;
                    break;
                }
                case 2: {
                    val = cm2.phys_dist - cm1.phys_dist;
                    break;
                }
                case 3: {
                    val = cm2.median - cm1.median;
                    break;
                }
                case 4: {
                    val = cm2.cum_phys_dist - cm1.cum_phys_dist;
                    break;
                }
                case 5: {
                    val = cm2.stdDev - cm1.stdDev;
                    break;
                }
                case 7: {
                    val = cm2.proximity - cm1.proximity;
                    break;
                }
                case 8: {
                    val = cm2.proximity_mut - cm1.proximity_mut;
                }
            }
            if (val > 0.0) {
                return -1;
            }
            if (val < 0.0) {
                return 1;
            }
            return 0;
        }
    }

    private static class ChainMatch {
        Chain query;
        Chain ref;
        Editions ed;
        double score;
        double seq_sim;
        double phys_dist;
        double cum_phys_dist;
        double stdDev;
        double median;
        double prop_mut;
        double prop_len;
        double proximity;
        double proximity_mut;
        double tortuosity_ratio;
        String title = null;

        ChainMatch(Chain query, Chain ref, Editions ed, double[] stats, double score) {
            this.query = query;
            this.ref = ref;
            this.ed = ed;
            this.phys_dist = stats[0];
            this.cum_phys_dist = stats[1];
            this.stdDev = stats[2];
            this.median = stats[3];
            this.prop_mut = stats[4];
            this.score = score;
            this.seq_sim = stats[6];
            this.proximity = stats[7];
            this.proximity_mut = stats[8];
            this.prop_len = stats[9];
            this.tortuosity_ratio = stats[10];
        }
    }

    public static class Chain {
        final ArrayList<Line3D> pipes = new ArrayList();
        public VectorString3D vs;
        public String title = null;

        private Chain() {
        }

        public Chain(Line3D root) {
            this.pipes.add(root);
            this.vs = root.asVectorString3D();
        }

        public final void append(Line3D p) throws Exception {
            this.pipes.add(p);
            this.vs = this.vs.chain(p.asVectorString3D());
        }

        public final Chain duplicate() {
            Chain chain = new Chain();
            chain.pipes.addAll(this.pipes);
            chain.vs = (VectorString3D)this.vs.clone();
            return chain;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("len: ");
            sb.append(this.pipes.size()).append("   ");
            for (Line3D p : this.pipes) {
                sb.append('#').append(p.getId()).append(' ');
            }
            return sb.toString();
        }

        public final String getTitle() {
            if (null != this.title) {
                return this.title;
            }
            StringBuffer sb = new StringBuffer(this.pipes.get(0).getProject().getTitle());
            sb.append(' ');
            for (Line3D p : this.pipes) {
                sb.append(' ').append('#').append(p.getId());
            }
            return sb.toString();
        }

        public final String getCellTitle() {
            if (null != this.title) {
                return this.title;
            }
            Line3D root = this.pipes.get(0);
            String mt = root.getProject().getShortMeaningfulTitle((ZDisplayable)((Object)root));
            if (1 == this.pipes.size()) {
                return mt;
            }
            StringBuffer sb = new StringBuffer(mt);
            for (int i = 1; i < this.pipes.size(); ++i) {
                sb.append(' ').append('#').append(this.pipes.get(i).getId());
            }
            return sb.toString();
        }

        public final String getShortCellTitle() {
            if (null != this.title) {
                return this.title;
            }
            Line3D root = this.pipes.get(0);
            ProjectThing pt = root.getProject().findProjectThing((ZDisplayable)((Object)root));
            String short_title = null;
            String title = (pt = (ProjectThing)pt.getParent()).getTitle();
            if (!title.equals(pt.getType())) {
                short_title = title;
            }
            if (null == short_title && !(title = (pt = (ProjectThing)pt.getParent()).getTitle()).equals(pt.getType())) {
                short_title = title;
            }
            if (null != short_title && short_title.length() > 10) {
                short_title = null;
            }
            if (null == short_title && (short_title = Long.toString(root.getId())).length() <= 8) {
                short_title = "id" + short_title;
            }
            while (short_title.length() > 10) {
                short_title = short_title.substring(1);
            }
            return short_title;
        }

        public final Color getColor() {
            return this.pipes.get(0).getColor();
        }

        public final Line3D getRoot() {
            return this.pipes.get(0);
        }

        public final void showCentered2D(boolean shift_down) {
            Rectangle b = null;
            Display display = Display.getFront();
            for (Line3D line3d : this.pipes) {
                ZDisplayable p = (ZDisplayable)((Object)line3d);
                if (null == b) {
                    b = p.getBoundingBox();
                } else {
                    b.add(p.getBoundingBox());
                }
                p.setVisible(true);
                display.select(p, shift_down);
            }
            display.select((ZDisplayable)((Object)this.pipes.get(0)), shift_down);
            display.getCanvas().showCentered(b);
        }
    }
}

